
CREATE TABLE PROVE.TIPO_STRUMENTO (NOME VARCHAR NOT NULL, DESCRIZIONE VARCHAR(30), PRIMARY KEY (NOME))
CREATE TABLE PROVE.AMMESSO (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.VOTO (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.MATERIA (CODICE VARCHAR NOT NULL, NOME VARCHAR(30), PRIMARY KEY (CODICE))
CREATE TABLE PROVE.TIPO_CANDIDATO (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.CORSO_DI_STUDIO (ID INTEGER IDENTITY(1,1) NOT NULL, INDIRIZZO INTEGER, SEZIONE VARCHAR(15), PLESSO VARCHAR(10), PRIMARY KEY (ID))
CREATE TABLE PROVE.FORMAZIONE (ID INTEGER NOT NULL, DESCRIZIONE VARCHAR(130), NOME VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.GENITORE (ID INTEGER IDENTITY(1,1) NOT NULL, ISTRUZIONE INTEGER, LUOGO_NASCITA INTEGER, OCCUPAZIONE INTEGER, SESSO VARCHAR, PRIMARY KEY (ID))
CREATE TABLE PROVE.ARRIVO_ITALIA (ID INTEGER IDENTITY(1,1) NOT NULL, LIVELLO INTEGER, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.COMPILA_QUESTIONARIO (VALORE VARCHAR(30), ALUNNO BIGINT NOT NULL, STRUMENTO INTEGER NOT NULL, FASCICOLO INTEGER, PRIMARY KEY (ALUNNO, STRUMENTO))
CREATE TABLE PROVE.FASCICOLO (CODICE VARCHAR(15), DOMANDA VARCHAR(300), SEQUENZIALE INTEGER NOT NULL, STRUMENTO INTEGER NOT NULL, PRIMARY KEY (SEQUENZIALE, STRUMENTO))
CREATE TABLE PROVE.ESITO_PROVA (ANNO TINYINT, VALORE INTEGER, ALUNNO BIGINT NOT NULL, STRUMENTO INTEGER NOT NULL, TEMPO_AGGIUNTIVO INTEGER, PRIMARY KEY (ALUNNO, STRUMENTO))
CREATE TABLE PROVE.ORE_SETTIMANALI (ID INTEGER IDENTITY(1,1) NOT NULL, LIVELLO INTEGER, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.VOTO_ESAME (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.RANGE (PUNTEGGIO INTEGER, RISPOSTE_MAX INTEGER, RISPOSTE_MIN INTEGER NOT NULL, BLOCCO VARCHAR NOT NULL, STRUMENTO INTEGER NOT NULL, PRIMARY KEY (RISPOSTE_MIN, BLOCCO, STRUMENTO))
CREATE TABLE PROVE.ISTRUZIONE (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(200), PRIMARY KEY (ID))
CREATE TABLE PROVE.STATO_ALUNNO (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.OCCUPAZIONE (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(200), PRIMARY KEY (ID))
CREATE TABLE PROVE.MESE_NASCITA (ID INTEGER IDENTITY(1,1) NOT NULL, NOME VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.RISPOSTA_ITEM (ITEM BIGINT NOT NULL, RISPOSTA VARCHAR NOT NULL, ALUNNO BIGINT NOT NULL, PRIMARY KEY (ITEM, RISPOSTA, ALUNNO))
CREATE TABLE PROVE.TEMPO_AGGIUNTIVO (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.PERCORSO (ID INTEGER NOT NULL, NOME VARCHAR(100), PRIMARY KEY (ID))
CREATE TABLE PROVE.TIPO_DOMANDA (CODICE VARCHAR NOT NULL, NOME VARCHAR(30), PRIMARY KEY (CODICE))
CREATE TABLE PROVE.CLASSE (ID INTEGER IDENTITY(1,1) NOT NULL, ANNO_DI_CORSO INTEGER, CODICE VARCHAR(15), LIVELLO INTEGER, N_ALUNNI INTEGER, CORSO_DI_STUDIO INTEGER, PRIMARY KEY (ID))
CREATE TABLE PROVE.CONTESTO_ESAME (ALUNNO BIGINT NOT NULL, ANNO INTEGER, COGNOME VARCHAR(100), NOME VARCHAR(100), AMMESSO INTEGER, TIPO_CANDIDATO INTEGER, VOTO_AMMISSIONE INTEGER, PRIMARY KEY (ALUNNO))
CREATE TABLE PROVE.STRUMENTO (ID INTEGER IDENTITY(1,1) NOT NULL, ANNO INTEGER, LIVELLO INTEGER, MATERIA VARCHAR(30), PROGETTO VARCHAR(30), TIPO VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.CONTESTO (ANNO_NASCITA VARCHAR(30), MATERNA VARCHAR(30), NIDO VARCHAR(30), ANNO VARCHAR NOT NULL, ALUNNO BIGINT NOT NULL, ARRIVO_ITALIA INTEGER, DISABILITA INTEGER, GENITORE_1 INTEGER, GENITORE_2 INTEGER, LUOGO_NASCITA INTEGER, MESE_NASCITA INTEGER, ORALE_ITA INTEGER, ORALE_MAT INTEGER, ORE_ITA INTEGER, ORE_MAT INTEGER, ORE_SETTIMANALI INTEGER, SCRITTO_ITA INTEGER, SCRITTO_MAT INTEGER, SESSO VARCHAR, STATO INTEGER, PRIMARY KEY (ANNO, ALUNNO))
CREATE TABLE PROVE.DISABILITA (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.LUOGO_NASCITA (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.ITEM (ID BIGINT IDENTITY(1,1) NOT NULL, ALTERNATIVE_DI_RISPOSTA VARCHAR(300), CODICE_FORTE VARCHAR(10), ETICHETTA VARCHAR(10), GRUPPO INTEGER, POSIZIONE INTEGER, RISPOSTA_CORRETTA VARCHAR(100), STRUMENTO INTEGER, FASCICOLO INTEGER, TIPO_DOMANDA VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.PLESSO (MECCANOGRAFICO VARCHAR NOT NULL, ISTITUTO VARCHAR(10), FORMAZIONE INTEGER, PRIMARY KEY (MECCANOGRAFICO))
CREATE TABLE PROVE.ORE_MATERIA (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.SVOLGE_PROVA (VALORE VARCHAR(30), ALUNNO BIGINT NOT NULL, STRUMENTO INTEGER NOT NULL, FASCICOLO INTEGER, PRIMARY KEY (ALUNNO, STRUMENTO))
CREATE TABLE PROVE.GRUPPO (ID INTEGER IDENTITY(1,1) NOT NULL, BLOCCO VARCHAR(10), METODO_DI_CORREZIONE INTEGER, PRIMARY KEY (ID))
CREATE TABLE PROVE.ALUNNO (ID BIGINT IDENTITY(1,1) NOT NULL, SEQUENZIALE INTEGER, SIDI VARCHAR(100), CLASSE INTEGER, PRIMARY KEY (ID))
CREATE TABLE PROVE.BLOCCO (ETICHETTA VARCHAR(10) NOT NULL, DIFFICOLTA VARCHAR(30), PRIMARY KEY (ETICHETTA))
CREATE TABLE PROVE.SETTORE (ID INTEGER NOT NULL, NOME VARCHAR(30), PERCORSO INTEGER, PRIMARY KEY (ID))
CREATE TABLE PROVE.INDIRIZZO (ID INTEGER IDENTITY(1,1) NOT NULL, NOME VARCHAR(200), SETTORE INTEGER references PROVE.SETTORE (ID), PRIMARY KEY (ID))
CREATE TABLE PROVE.PROGETTO (NOME VARCHAR NOT NULL, DESCRIZIONE VARCHAR(30), ID INTEGER, PRIMARY KEY (NOME))
CREATE TABLE PROVE.VOTO_AMMISSIONE (ID INTEGER IDENTITY(1,1) NOT NULL, VALORE VARCHAR(30), PRIMARY KEY (ID))
CREATE TABLE PROVE.METODO_DI_CORREZIONE (ID INTEGER IDENTITY(1,1) NOT NULL PRIMARY KEY, FATTORE_DI_CORREZIONE DECIMAL(5,2))
CREATE TABLE PROVE.SESSO (CODICE VARCHAR NOT NULL, DESCRIZIONE VARCHAR(30), PRIMARY KEY (CODICE))
CREATE TABLE PROVE.ESAME_ALUNNO (ANNO SMALLINT NOT NULL, ALUNNO BIGINT NOT NULL, VOTO_ESAME_ITALIANO INTEGER, VOTO_ESAME_LINGUA INTEGER, VOTO_ESAME_MATEMATICA INTEGER, VOTO_INVALSI INTEGER, PRIMARY KEY (ANNO, ALUNNO))

ALTER TABLE PROVE.CORSO_DI_STUDIO ADD CONSTRAINT FK_CORSO_DI_STUDIO_PLESSO FOREIGN KEY (PLESSO) REFERENCES PLESSO (MECCANOGRAFICO)
ALTER TABLE PROVE.GENITORE ADD CONSTRAINT FK_GENITORE_ISTRUZIONE FOREIGN KEY (ISTRUZIONE) REFERENCES ISTRUZIONE (ID)
ALTER TABLE PROVE.GENITORE ADD CONSTRAINT FK_GENITORE_SESSO FOREIGN KEY (SESSO) REFERENCES SESSO (CODICE)
ALTER TABLE PROVE.GENITORE ADD CONSTRAINT FK_GENITORE_LUOGO_NASCITA FOREIGN KEY (LUOGO_NASCITA) REFERENCES LUOGO_NASCITA (ID)
ALTER TABLE PROVE.GENITORE ADD CONSTRAINT FK_GENITORE_OCCUPAZIONE FOREIGN KEY (OCCUPAZIONE) REFERENCES OCCUPAZIONE (ID)
ALTER TABLE PROVE.COMPILA_QUESTIONARIO ADD CONSTRAINT FK_COMPILA_QUESTIONARIO_ALUNNO FOREIGN KEY (ALUNNO) REFERENCES ALUNNO (ID)
ALTER TABLE PROVE.COMPILA_QUESTIONARIO ADD CONSTRAINT FK_COMPILA_QUESTIONARIO_FASCICOLO FOREIGN KEY (FASCICOLO, STRUMENTO) REFERENCES FASCICOLO (SEQUENZIALE, STRUMENTO)
ALTER TABLE PROVE.FASCICOLO ADD CONSTRAINT FK_FASCICOLO_STRUMENTO FOREIGN KEY (STRUMENTO) REFERENCES STRUMENTO (ID)
ALTER TABLE PROVE.ESITO_PROVA ADD CONSTRAINT FK_ESITO_PROVA_ALUNNO FOREIGN KEY (ALUNNO) REFERENCES ALUNNO (ID)
ALTER TABLE PROVE.ESITO_PROVA ADD CONSTRAINT FK_ESITO_PROVA_STRUMENTO FOREIGN KEY (STRUMENTO) REFERENCES STRUMENTO (ID)
ALTER TABLE PROVE.ESITO_PROVA ADD CONSTRAINT FK_ESITO_PROVA_TEMPO_AGGIUNTIVO FOREIGN KEY (TEMPO_AGGIUNTIVO) REFERENCES TEMPO_AGGIUNTIVO (ID)
ALTER TABLE PROVE.RANGE ADD CONSTRAINT FK_RANGE_STRUMENTO FOREIGN KEY (STRUMENTO) REFERENCES STRUMENTO (ID)
ALTER TABLE PROVE.RANGE ADD CONSTRAINT FK_RANGE_BLOCCO FOREIGN KEY (BLOCCO) REFERENCES BLOCCO (ETICHETTA)
ALTER TABLE PROVE.CLASSE ADD CONSTRAINT FK_CLASSE_CORSO_DI_STUDIO FOREIGN KEY (CORSO_DI_STUDIO) REFERENCES CORSO_DI_STUDIO (ID)
ALTER TABLE PROVE.CONTESTO_ESAME ADD CONSTRAINT FK_CONTESTO_ESAME_AMMESSO FOREIGN KEY (AMMESSO) REFERENCES AMMESSO (ID)
ALTER TABLE PROVE.CONTESTO_ESAME ADD CONSTRAINT FK_CONTESTO_ESAME_TIPO_CANDIDATO FOREIGN KEY (TIPO_CANDIDATO) REFERENCES TIPO_CANDIDATO (ID)
ALTER TABLE PROVE.CONTESTO_ESAME ADD CONSTRAINT FK_CONTESTO_ESAME_VOTO_AMMISSIONE FOREIGN KEY (VOTO_AMMISSIONE) REFERENCES VOTO_AMMISSIONE (ID)
ALTER TABLE PROVE.STRUMENTO ADD CONSTRAINT FK_STRUMENTO_TIPO FOREIGN KEY (TIPO) REFERENCES TIPO_STRUMENTO (NOME)
ALTER TABLE PROVE.STRUMENTO ADD CONSTRAINT FK_STRUMENTO_PROGETTO FOREIGN KEY (PROGETTO) REFERENCES PROGETTO (NOME)
ALTER TABLE PROVE.STRUMENTO ADD CONSTRAINT FK_STRUMENTO_MATERIA FOREIGN KEY (MATERIA) REFERENCES MATERIA (CODICE)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_SCRITTO_MAT FOREIGN KEY (SCRITTO_MAT) REFERENCES VOTO (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_DISABILITA FOREIGN KEY (DISABILITA) REFERENCES DISABILITA (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_SCRITTO_ITA FOREIGN KEY (SCRITTO_ITA) REFERENCES VOTO (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_MESE_NASCITA FOREIGN KEY (MESE_NASCITA) REFERENCES MESE_NASCITA (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_SESSO FOREIGN KEY (SESSO) REFERENCES SESSO (CODICE)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_GENITORE_2 FOREIGN KEY (GENITORE_2) REFERENCES GENITORE (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ORE_MAT FOREIGN KEY (ORE_MAT) REFERENCES ORE_MATERIA (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_GENITORE_1 FOREIGN KEY (GENITORE_1) REFERENCES GENITORE (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ORE_SETTIMANALI FOREIGN KEY (ORE_SETTIMANALI) REFERENCES ORE_SETTIMANALI (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ORALE_MAT FOREIGN KEY (ORALE_MAT) REFERENCES VOTO (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_STATO FOREIGN KEY (STATO) REFERENCES STATO_ALUNNO (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ARRIVO_ITALIA FOREIGN KEY (ARRIVO_ITALIA) REFERENCES ARRIVO_ITALIA (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ORALE_ITA FOREIGN KEY (ORALE_ITA) REFERENCES VOTO (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ALUNNO FOREIGN KEY (ALUNNO) REFERENCES ALUNNO (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_LUOGO_NASCITA FOREIGN KEY (LUOGO_NASCITA) REFERENCES LUOGO_NASCITA (ID)
ALTER TABLE PROVE.CONTESTO ADD CONSTRAINT FK_CONTESTO_ORE_ITA FOREIGN KEY (ORE_ITA) REFERENCES ORE_MATERIA (ID)
ALTER TABLE PROVE.ITEM ADD CONSTRAINT FK_ITEM_TIPO_DOMANDA FOREIGN KEY (TIPO_DOMANDA) REFERENCES TIPO_DOMANDA (CODICE)
ALTER TABLE PROVE.ITEM ADD CONSTRAINT FK_ITEM_FASCICOLO FOREIGN KEY (FASCICOLO, STRUMENTO) REFERENCES FASCICOLO (SEQUENZIALE, STRUMENTO)
ALTER TABLE PROVE.PLESSO ADD CONSTRAINT FK_PLESSO_FORMAZIONE FOREIGN KEY (FORMAZIONE) REFERENCES FORMAZIONE (ID)
ALTER TABLE PROVE.SVOLGE_PROVA ADD CONSTRAINT FK_SVOLGE_PROVA_ALUNNO FOREIGN KEY (ALUNNO) REFERENCES ALUNNO (ID)
ALTER TABLE PROVE.SVOLGE_PROVA ADD CONSTRAINT FK_SVOLGE_PROVA_FASCICOLO FOREIGN KEY (FASCICOLO, STRUMENTO) REFERENCES FASCICOLO (SEQUENZIALE, STRUMENTO)
ALTER TABLE PROVE.GRUPPO ADD CONSTRAINT FK_GRUPPO_BLOCCO FOREIGN KEY (BLOCCO) REFERENCES BLOCCO (ETICHETTA)
ALTER TABLE PROVE.GRUPPO ADD CONSTRAINT FK_GRUPPO_METODO_DI_CORREZIONE FOREIGN KEY (METODO_DI_CORREZIONE) REFERENCES METODO_DI_CORREZIONE (ID)
ALTER TABLE PROVE.ALUNNO ADD CONSTRAINT FK_ALUNNO_CLASSE FOREIGN KEY (CLASSE) REFERENCES CLASSE (ID)
ALTER TABLE PROVE.SETTORE ADD CONSTRAINT FK_SETTORE_PERCORSO FOREIGN KEY (PERCORSO) REFERENCES PERCORSO (ID)
ALTER TABLE PROVE.ESAME_ALUNNO ADD CONSTRAINT FK_ESAME_ALUNNO_VOTO_ESAME_ITALIANO FOREIGN KEY (VOTO_ESAME_ITALIANO) REFERENCES VOTO_ESAME (ID)
ALTER TABLE PROVE.ESAME_ALUNNO ADD CONSTRAINT FK_ESAME_ALUNNO_VOTO_INVALSI FOREIGN KEY (VOTO_INVALSI) REFERENCES VOTO_ESAME (ID)
ALTER TABLE PROVE.ESAME_ALUNNO ADD CONSTRAINT FK_ESAME_ALUNNO_VOTO_ESAME_MATEMATICA FOREIGN KEY (VOTO_ESAME_MATEMATICA) REFERENCES VOTO_ESAME (ID)
ALTER TABLE PROVE.ESAME_ALUNNO ADD CONSTRAINT FK_ESAME_ALUNNO_VOTO_ESAME_LINGUA FOREIGN KEY (VOTO_ESAME_LINGUA) REFERENCES VOTO_ESAME (ID)
ALTER TABLE PROVE.ESAME_ALUNNO ADD CONSTRAINT FK_ESAME_ALUNNO_ALUNNO FOREIGN KEY (ALUNNO) REFERENCES ALUNNO (ID)
