/*
 * Decompiled with CFR 0.152.
 */
package invalsi.utils;

import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import invalsi.utils.PasswordValidator_2014;
import invalsi.utils.PasswordValidator_2015;
import invalsi.utils.db.ConnectionMgr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordValidator_2016 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        List<String> istituti = null;
        File istitutiFile = null;
        File utilsFolder = null;
        PrintWriter writer = null;
        String result = null;
        StringBuilder stringBuilder = null;
        try {
            istituti = ScuoleMgr.getIstance().getAllIstituti();
            utilsFolder = new File("utils");
            istitutiFile = new File(utilsFolder.getPath() + File.separator + "istituti_pn" + "_2016.csv");
            writer = new PrintWriter(istitutiFile);
            stringBuilder = new StringBuilder("ISTITUTO;PASSWORD\n");
            for (String istituto : istituti) {
                result = PasswordValidator_2016.generaPassword_PN(istituto);
                stringBuilder.append(istituto).append(";").append(result).append("\n");
            }
            writer.println(stringBuilder);
            writer.flush();
            writer.close();
            ConnectionMgr.getIstance().closeConnection();
            System.exit(0);
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex.getMessage());
        }
        finally {
            try {
                writer.close();
                ConnectionMgr.getIstance().resetConnection();
                System.exit(0);
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    public static boolean veridicaPassword(String istituto, String password) throws ScuoleMgtException {
        String resutlt = PasswordValidator_2016.generaPassword_PN(istituto);
        return resutlt.equals(password);
    }

    public static String generaPassword(String istituto) throws ScuoleMgtException {
        String result = null;
        String result_2015 = null;
        String result_2014 = null;
        int back_pos_2015 = 0;
        int back_pos_2014 = 0;
        char[] resultArray = new char[]{};
        Object resul = null;
        int lunghezza = 10;
        result_2015 = PasswordValidator_2015.generaPassword(istituto);
        result_2014 = PasswordValidator_2014.generaPassword(istituto);
        if (!result_2015.equals("skipme")) {
            resultArray = new char[lunghezza];
            back_pos_2015 = result_2015.length() - 1;
            back_pos_2014 = result_2014.length() - 1;
            int i = 0;
            int j = 0;
            while (i < lunghezza && j < lunghezza) {
                resultArray[i++] = result_2015.charAt(back_pos_2015--);
                if (i >= lunghezza || j >= back_pos_2014) break;
                resultArray[i++] = result_2014.charAt(j);
                if (i >= lunghezza || j >= back_pos_2014) break;
                resultArray[i++] = result_2015.charAt(j++);
                if (i >= lunghezza || j >= back_pos_2014) break;
                resultArray[i++] = result_2014.charAt(back_pos_2014--);
            }
            result = new String(resultArray);
        } else {
            result = "skipme";
        }
        return result;
    }

    private static String generaPassword_PN_old(String istituto) throws ScuoleMgtException {
        String result = PasswordValidator_2016.generaPassword(istituto);
        int j = 0;
        String newResult = "";
        for (int i = 0; i < result.length(); ++i) {
            int ascii = result.charAt(i) - 48;
            ascii += j % 10000;
            newResult = (ascii %= 75) >= 10 && ascii <= 16 || ascii >= 43 && ascii <= 48 ? newResult + Integer.toString(ascii + 48) : newResult + (char)(ascii + 48);
            ++j;
        }
        return newResult.substring(newResult.length() - 10, newResult.length());
    }

    private static String generaPassword_PN(String istituto) throws ScuoleMgtException {
        String result = PasswordValidator_2016.generaPassword(istituto);
        int j = 0;
        boolean resto = false;
        String newResult = "";
        for (int i = 0; i < result.length(); ++i) {
            int ascii = result.charAt(i) - 48;
            if ((ascii += j + 10) >= 75) {
                ascii -= 75;
            }
            newResult = ascii >= 10 && ascii <= 16 || ascii >= 43 && ascii <= 48 ? newResult.concat(new String(Integer.toString(ascii + 48))) : newResult + (char)(ascii + 48);
            ++j;
        }
        return newResult.substring(newResult.length() - 10, newResult.length());
    }
}

