/*
 * Decompiled with CFR 0.152.
 */
package invalsi.utils;

import invalsi.beans.scuole.Classe;
import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import invalsi.utils.db.ConnectionMgr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordValidator_2015 {
    private static final String[] CONS = new String[]{"", "Uw", "Vu", "Rs", "Av", "Wd", "Yf", "Kh", "Ps", "Kq", "Yd", "As", "Ws", "Sg", "Yr", "Wf", "Ag", "Zd", "Vm", "Tn", "Sv", "Rd", "Qf", "Pt", "Np", "Mq", "Lv", "Ht", "Gs", "Fg", "Dr", "Cf", "Bg"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        List<String> istituti = null;
        File istitutiFile = null;
        File utilsFolder = null;
        PrintWriter writer = null;
        String result = null;
        StringBuffer stringBuffer = null;
        try {
            istituti = ScuoleMgr.getIstance().getAllIstituti();
            utilsFolder = new File("utils");
            istitutiFile = new File(utilsFolder.getPath() + File.separator + "istituti_2015.csv");
            writer = new PrintWriter(istitutiFile);
            stringBuffer = new StringBuffer("ISTITUTO;PASSWORD\n");
            int i = 0;
            for (String istituto : istituti) {
                result = PasswordValidator_2015.generaPassword(istituto);
                stringBuffer.append(istituto).append(";").append(result).append("\n");
                System.out.println(istituto);
                ++i;
            }
            System.out.println(stringBuffer.toString());
            writer.println(stringBuffer);
            writer.flush();
            writer.close();
            ConnectionMgr.getIstance().resetConnection();
            System.exit(0);
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                writer.close();
                ConnectionMgr.getIstance().resetConnection();
                System.exit(0);
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(PasswordValidator_2015.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    public static String generaPassword(String istituto) throws ScuoleMgtException {
        Classe unaClasse = null;
        String cod_cla = null;
        String calcolata = null;
        String ottavo_cod_cla = null;
        String settimo_cod_cla = null;
        String sesto_cod_cla = null;
        String quinto_cod_cla = null;
        String ultimo_istituto = null;
        String primo_istituto = null;
        String secondo_e_terzo_cod_cla = null;
        String primo_cod_cla = null;
        int index_cons = -1;
        String prime_tre_cifre_ris = null;
        String quarta_risultato = null;
        String quinta_risultato = null;
        String sesto_risultato = null;
        String settimo_risultato = null;
        int ottavo_penultimo_int = -1;
        String ottavo_penultimo = null;
        String ultimo_risultato = null;
        unaClasse = ScuoleMgr.getIstance().getUnaClasseByIstituto(istituto);
        if (null == unaClasse) {
            return "skipme";
        }
        cod_cla = unaClasse.getCodice();
        ottavo_cod_cla = cod_cla.substring(7, 8);
        settimo_cod_cla = cod_cla.substring(6, 7);
        sesto_cod_cla = cod_cla.substring(5, 6);
        quinto_cod_cla = cod_cla.substring(4, 5);
        ultimo_istituto = istituto.substring(istituto.length() - 1);
        primo_istituto = istituto.substring(0, 1);
        secondo_e_terzo_cod_cla = cod_cla.substring(1, 3);
        primo_cod_cla = cod_cla.substring(0, 1);
        index_cons = Integer.parseInt(ottavo_cod_cla) + Integer.parseInt(settimo_cod_cla) + Integer.parseInt(primo_cod_cla) + 1;
        prime_tre_cifre_ris = CONS[index_cons] + settimo_cod_cla;
        quarta_risultato = ottavo_cod_cla;
        quinta_risultato = ultimo_istituto.toLowerCase();
        sesto_risultato = prime_tre_cifre_ris.substring(0, 1);
        settimo_risultato = primo_istituto.toLowerCase();
        ottavo_penultimo_int = Integer.parseInt(ottavo_cod_cla) + Integer.parseInt(settimo_cod_cla) + Integer.parseInt(primo_cod_cla) + Integer.parseInt(secondo_e_terzo_cod_cla) + 100;
        ottavo_penultimo = "" + ottavo_penultimo_int;
        ultimo_risultato = index_cons - Integer.parseInt(primo_cod_cla) <= Integer.parseInt(sesto_cod_cla) - Integer.parseInt(quinto_cod_cla) ? CONS[index_cons - Integer.parseInt(primo_cod_cla) + Integer.parseInt(sesto_cod_cla) - Integer.parseInt(quinto_cod_cla)] : CONS[index_cons - Integer.parseInt(primo_cod_cla) - Integer.parseInt(sesto_cod_cla) + Integer.parseInt(quinto_cod_cla)];
        calcolata = prime_tre_cifre_ris + quarta_risultato + quinta_risultato + sesto_risultato + settimo_risultato + ottavo_penultimo + ultimo_risultato;
        return calcolata;
    }
}

