/*
 * Decompiled with CFR 0.152.
 */
package invalsi.utils;

import invalsi.beans.alunni.AlunnoEsaminato;
import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.prove.FascicoloCompilato;
import invalsi.beans.prove.Item;
import invalsi.beans.prove.ItemRisposto;
import invalsi.beans.scuole.Classe;
import invalsi.business.alunni.IAlunniMgt;
import invalsi.business.alunni.impl.AlunniMgr;
import invalsi.business.prove.IProveMgt;
import invalsi.business.prove.impl.ProveMgr;
import invalsi.business.scuole.IScuoleMgt;
import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.eccezioni.business.alunni.AlunniMgtException;
import invalsi.eccezioni.business.prove.ProveMgtException;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import invalsi.gui.MainForm;
import invalsi.utils.db.ConnectionMgr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerazioneFiles {
    IScuoleMgt scuoleMgr = null;
    IAlunniMgt alunniMgr = null;
    IProveMgt proveMgr = null;
    Collection<Classe> classi;
    boolean datiMancantiPerLaClasse = false;
    List<FascicoloCompilato> fascicoli = null;
    String stringaAlunno = null;
    String stringaVotiAlunno = null;
    String domandaFascicoloIta = null;
    String domandaFascicoloMat = null;
    String codiceFascicoloIta = null;
    String codiceFascicoloMat = null;
    String rispostaScelta = null;
    File classeFile = null;
    File votiClasseFile = null;
    File cartella = null;
    File cartellaVoti = null;
    PrintWriter writer = null;
    PrintWriter votiWriter = null;
    List<AlunnoValutato> alunni = null;
    Map<Integer, Map<String, List<Item>>> itemLivelloMaps;
    Map<String, List<Item>> itemStrumentoLivelloMap;
    List<Item> itemsStrumento;
    String svolge = null;
    String svolgeIta = null;
    String svolgeMat = null;
    FascicoloCompilato fascio = null;
    List<ItemRisposto> itemsConRisposte = null;
    String classeString;
    String votiClasseString;
    int generati = 0;
    int lastLivello = 0;
    MainForm feedbackForm = null;
    List<AlunnoValutato> alunniMancanti;

    public void generaFiles(String istituto, MainForm myFeedbackForm) throws FileNotFoundException, UnsupportedEncodingException {
        try {
            this.feedbackForm = myFeedbackForm;
            this.scuoleMgr = ScuoleMgr.getIstance();
            this.alunniMgr = AlunniMgr.getIstance();
            this.proveMgr = ProveMgr.getIstance();
            this.classi = this.scuoleMgr.getClassiBySvolgimentoProveAndIstituto(istituto);
            if (this.classi.isEmpty()) {
                this.feedbackForm.avvisaDatiNonInseriti();
                return;
            }
            this.cartella = new File("." + File.separator + "generati");
            this.cartellaVoti = new File(this.cartella.getPath() + File.separator + "voti");
            if (this.cartella.exists()) {
                if (this.cartellaVoti.exists()) {
                    if (this.cartellaVoti.isFile()) {
                        this.cartellaVoti.delete();
                        this.cartellaVoti.mkdir();
                    }
                } else {
                    this.cartellaVoti.mkdir();
                }
                if (this.cartella.isFile()) {
                    this.cartella.delete();
                    this.cartella.mkdir();
                    this.cartellaVoti.mkdir();
                }
            } else {
                this.cartella.mkdir();
                this.cartellaVoti.mkdir();
            }
            this.itemLivelloMaps = new HashMap<Integer, Map<String, List<Item>>>();
            for (Classe classe : this.classi) {
                this.gestioneClasse(classe);
            }
            ConnectionMgr.getIstance().resetConnection();
            this.feedbackForm.avvisaFileCreati(this.generati, this.classi.size());
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            this.feedbackForm.exceptionCallBack(ex.getMessage());
        }
        catch (AlunniMgtException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            this.feedbackForm.exceptionCallBack(ex.getMessage());
        }
        catch (ProveMgtException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            this.feedbackForm.exceptionCallBack(ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            this.feedbackForm.exceptionCallBack(ex.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            this.feedbackForm.exceptionCallBack(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GenerazioneFiles.class.getName()).log(Level.SEVERE, null, ex);
            this.feedbackForm.exceptionCallBack(ex.getMessage());
        }
    }

    private void gestioneClasse(Classe classe) throws ProveMgtException, AlunniMgtException, FileNotFoundException, UnsupportedEncodingException {
        this.alunniMancanti = new LinkedList<AlunnoValutato>();
        if (this.lastLivello != classe.getLivello()) {
            this.lastLivello = classe.getLivello();
            if (this.itemLivelloMaps.get(this.lastLivello) == null) {
                this.itemStrumentoLivelloMap = new HashMap<String, List<Item>>();
                this.itemsStrumento = this.proveMgr.getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(this.lastLivello, "Italiano", "NORMALE", 1);
                this.itemStrumentoLivelloMap.put("Italiano", this.itemsStrumento);
                this.itemLivelloMaps.put(this.lastLivello, this.itemStrumentoLivelloMap);
                this.itemsStrumento = this.proveMgr.getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(this.lastLivello, "Matematica", "NORMALE", 1);
                this.itemStrumentoLivelloMap.put("Matematica", this.itemsStrumento);
                this.itemLivelloMaps.put(this.lastLivello, this.itemStrumentoLivelloMap);
                if (this.lastLivello == 2) {
                    this.itemsStrumento = this.proveMgr.getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(this.lastLivello, "Prova preliminare di lettura", "PRE_LETTURA", 1);
                    this.itemStrumentoLivelloMap.put("PRE_LETTURA", this.itemsStrumento);
                    this.itemLivelloMaps.put(this.lastLivello, this.itemStrumentoLivelloMap);
                } else if (this.lastLivello != 8) {
                    this.itemsStrumento = this.proveMgr.getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(this.lastLivello, "Non Applicabile", "QST_ALU", 1);
                    this.itemStrumentoLivelloMap.put("QST_ALU", this.itemsStrumento);
                    this.itemLivelloMaps.put(this.lastLivello, this.itemStrumentoLivelloMap);
                }
            }
        }
        this.datiMancantiPerLaClasse = false;
        this.alunni = this.alunniMgr.getAlunniValutatiByClasse(classe);
        this.classeString = "";
        this.classeString = this.classeString + "cod_fornitore;meccanografico;meccanografico plesso;codice classe;sezione;progressivo studente;codice studente;codice SIDI;";
        if (this.lastLivello == 8) {
            this.classeString = this.classeString + "Punteggio Prova di Italiano;Punteggio Prova di Matematica;Punteggio Totale;VOTO;tipo candidato;tipo disabilita o DES;prova personalizzata;stato studente;ammesso all'esame;voto ammissione;voto_prova_esame_italiano;voto_prova_esame_matematica;";
            this.votiClasseString = "progressivo studente;codice SIDI;Cognome;Nome;stato studente;ammesso all'esame;voto ammissione;Punteggio Prova di Italiano;Punteggio Prova di Matematica;Punteggio Totale;Voto prova invalsi\n";
        } else {
            this.classeString = this.classeString + "tipo disabilita o DES;stato studente;";
        }
        this.classeString = this.classeString + "voto scritto di italiano;voto orale o unico di italiano;voto scritto di matematica;voto orale o unico di matematica;";
        if (this.lastLivello == 2) {
            this.classeString = this.classeString + "svolge la prova preliminare di lettura;";
        }
        this.classeString = this.classeString + "svolge la prova di italiano;";
        this.classeString = this.classeString + "svolge la prova di matematica;";
        if (this.lastLivello != 2 && this.lastLivello != 8) {
            this.classeString = this.classeString + "compila il questionario;";
        }
        if (this.lastLivello == 2) {
            for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("PRE_LETTURA")) {
                this.classeString = this.classeString + item.getEtichetta() + ";";
            }
        }
        for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("Italiano")) {
            this.classeString = this.classeString + item.getEtichetta() + ";";
        }
        for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("Matematica")) {
            this.classeString = this.classeString + item.getEtichetta() + ";";
        }
        if (this.lastLivello != 2 && this.lastLivello != 8) {
            for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("QST_ALU")) {
                this.classeString = this.classeString + item.getEtichetta() + ";";
            }
        }
        this.classeString = this.classeString + "domanda_ita;cod_fascicolo_ita;domanda_mat;cod_fascicolo_mat;ordine_ita;tempo_ita;ordine_mat;tempo_mat;\n";
        GregorianCalendar calendar = new GregorianCalendar();
        String extension = "";
        if (this.lastLivello == 8) {
            extension = extension + ".ES_";
            this.votiClasseFile = new File(this.cartellaVoti.getPath() + File.separator + classe.getCodice() + "_VOTO_INVALSI.csv");
        } else {
            extension = extension + ".RN_";
        }
        extension = extension + calendar.get(1);
        this.classeFile = new File(this.cartella.getPath() + File.separator + classe.getCodice() + extension);
        this.writer = new PrintWriter(this.classeFile, "windows-1252");
        this.writer.append(this.classeString);
        if (this.lastLivello == 8) {
            this.votiWriter = new PrintWriter(this.votiClasseFile, "windows-1252");
            this.votiWriter.append(this.votiClasseString);
        }
        for (AlunnoValutato alunno : this.alunni) {
            this.gestisciAlunno(alunno, classe);
        }
        this.writer.flush();
        this.writer.close();
        if (this.lastLivello == 8) {
            this.votiWriter.flush();
            this.votiWriter.close();
        }
        if (this.datiMancantiPerLaClasse) {
            this.classeFile.delete();
            if (this.lastLivello == 8) {
                this.votiClasseFile.delete();
            }
            this.feedbackForm.avvisaAlunnoConDatiMancanti(classe, this.alunniMancanti);
        } else {
            ++this.generati;
        }
    }

    private void gestisciAlunno(AlunnoValutato alunno, Classe classe) throws ProveMgtException, AlunniMgtException {
        AlunnoEsaminato esaminato = null;
        this.fascicoli = this.proveMgr.getFascicoliByAlunnoValutato(alunno);
        alunno.setFascicoliCompilati(this.fascicoli);
        String codiceAlunno = null;
        String progressivo = null;
        if (alunno.getSequenziale() < 10) {
            codiceAlunno = classe.getCodice() + "0" + new Integer(alunno.getSequenziale()).toString();
            progressivo = "0" + new Integer(alunno.getSequenziale()).toString();
        } else {
            codiceAlunno = classe.getCodice() + new Integer(alunno.getSequenziale()).toString();
            progressivo = new Integer(alunno.getSequenziale()).toString();
        }
        this.stringaAlunno = "JAVA;" + classe.getCorsoDiStudio().getPlesso().getIstituto() + ";" + classe.getCorsoDiStudio().getPlesso().getMeccanografico() + ";" + classe.getCodice() + ";";
        this.stringaAlunno = classe.getLivello() <= 8 ? this.stringaAlunno + classe.getCorsoDiStudio().getSezione() + " - " + classe.getCorsoDiStudio().getIndirizzo() + ";" : this.stringaAlunno + classe.getCorsoDiStudio().getSezione() + " - " + classe.getCorsoDiStudio().getPercorso() + " " + classe.getCorsoDiStudio().getIndirizzo() + ";";
        this.stringaAlunno = this.stringaAlunno + progressivo + ";" + codiceAlunno + ";" + alunno.getSidi() + ";";
        if (this.lastLivello == 8) {
            esaminato = (AlunnoEsaminato)alunno;
            int punteggioIta = 0;
            int punteggioMat = 0;
            if (esaminato.getPunteggioItaliano() > 0) {
                punteggioIta = esaminato.getPunteggioItaliano();
            }
            if (esaminato.getPunteggioMatematica() > 0) {
                punteggioMat = esaminato.getPunteggioMatematica();
            }
            this.stringaAlunno = this.stringaAlunno + punteggioIta + ";" + punteggioMat + ";" + (punteggioIta + punteggioMat) + ";" + esaminato.getVotoInvalsi() + ";" + esaminato.getTipoCandidato() + ";" + ";" + ";";
            this.stringaAlunno = this.stringaAlunno + esaminato.getStato() + ";" + esaminato.getAmmesso() + ";" + esaminato.getVotoAmmissione() + ";" + esaminato.getVotoProvaEsameItaliano() + ";" + esaminato.getVotoProvaEsameMatematica() + ";";
            this.stringaVotiAlunno = "" + esaminato.getSequenziale() + ";" + esaminato.getSidi() + ";" + esaminato.getCognome() + ";" + esaminato.getNome() + ";" + esaminato.getStato() + ";" + esaminato.getAmmesso() + ";" + esaminato.getVotoAmmissione() + ";" + punteggioIta + ";" + punteggioMat + ";" + (punteggioIta + punteggioMat) + ";" + esaminato.getVotoInvalsi() + "\n";
            this.votiWriter.append(this.stringaVotiAlunno);
        } else {
            this.stringaAlunno = this.stringaAlunno + ";" + alunno.getStato() + ";";
        }
        this.stringaAlunno = this.stringaAlunno + alunno.getVotoScrittoItaliano() + ";" + alunno.getVotoOraleItaliano() + ";" + alunno.getVotoScrittoMatematica() + ";" + alunno.getVotoOraleMatematica() + ";";
        this.domandaFascicoloIta = null;
        this.codiceFascicoloIta = null;
        this.domandaFascicoloMat = null;
        this.codiceFascicoloMat = null;
        boolean ok = this.gestisciSvolgitureProvaPerAlunno(alunno, classe);
        if (ok) {
            this.gestisciRisposte(alunno, classe);
        }
        if (this.domandaFascicoloIta != null && !this.domandaFascicoloIta.equals("Non applicabile")) {
            this.stringaAlunno = this.stringaAlunno + this.domandaFascicoloIta + ";";
        } else if (this.domandaFascicoloIta != null && this.domandaFascicoloIta.equals("Non applicabile")) {
            this.codiceFascicoloIta = null;
            this.stringaAlunno = this.stringaAlunno + ";";
        } else {
            this.stringaAlunno = this.stringaAlunno + ";";
        }
        this.stringaAlunno = this.codiceFascicoloIta != null ? this.stringaAlunno + this.codiceFascicoloIta + ";" : this.stringaAlunno + ";";
        if (this.domandaFascicoloMat != null && !this.domandaFascicoloMat.equals("Non applicabile")) {
            this.stringaAlunno = this.stringaAlunno + this.domandaFascicoloMat + ";";
        } else if (this.domandaFascicoloMat != null && this.domandaFascicoloMat.equals("Non applicabile")) {
            this.codiceFascicoloMat = null;
            this.stringaAlunno = this.stringaAlunno + ";";
        } else {
            this.stringaAlunno = this.stringaAlunno + ";";
        }
        this.stringaAlunno = this.codiceFascicoloMat != null ? this.stringaAlunno + this.codiceFascicoloMat + ";" : this.stringaAlunno + ";";
        this.stringaAlunno = this.stringaAlunno + ";;;";
        this.stringaAlunno = this.stringaAlunno + "\n";
        this.writer.append(this.stringaAlunno);
    }

    private boolean gestisciSvolgitureProvaPerAlunno(AlunnoValutato alunno, Classe classe) throws AlunniMgtException {
        if (classe.getLivello() == 2) {
            this.svolge = null;
            this.svolge = this.alunniMgr.getSvolgeProva(alunno, "PRE_LETTURA", "Prova preliminare di lettura");
            if (this.svolge != null) {
                this.stringaAlunno = this.stringaAlunno + this.svolge + ";";
            } else {
                this.datiMancantiPerLaClasse = true;
                if (!this.alunniMancanti.contains(alunno)) {
                    this.alunniMancanti.add(alunno);
                }
                return false;
            }
        }
        this.svolge = null;
        this.svolge = this.alunniMgr.getSvolgeProva(alunno, "NORMALE", "Italiano");
        if (this.svolge != null) {
            if (this.lastLivello == 8) {
                this.svolgeIta = this.svolge;
            }
        } else {
            this.datiMancantiPerLaClasse = true;
            if (!this.alunniMancanti.contains(alunno)) {
                this.alunniMancanti.add(alunno);
            }
            return false;
        }
        this.stringaAlunno = this.stringaAlunno + this.svolge + ";";
        this.svolge = null;
        this.svolge = this.alunniMgr.getSvolgeProva(alunno, "NORMALE", "Matematica");
        if (this.svolge != null) {
            if (this.lastLivello == 8) {
                this.svolgeMat = this.svolge;
            }
        } else {
            this.datiMancantiPerLaClasse = true;
            if (!this.alunniMancanti.contains(alunno)) {
                this.alunniMancanti.add(alunno);
            }
            return false;
        }
        this.stringaAlunno = this.stringaAlunno + this.svolge + ";";
        if (this.lastLivello != 2 && this.lastLivello != 8) {
            this.svolge = null;
            this.svolge = this.alunniMgr.getSvolgeProva(alunno, "QST_ALU", "Non Applicabile");
            if (this.svolge != null) {
                this.stringaAlunno = this.stringaAlunno + this.svolge + ";";
            } else {
                this.datiMancantiPerLaClasse = true;
                if (!this.alunniMancanti.contains(alunno)) {
                    this.alunniMancanti.add(alunno);
                }
                return false;
            }
        }
        return true;
    }

    private void gestisciRisposte(AlunnoValutato alunno, Classe classe) {
        block33: {
            if (classe.getLivello() == 2) {
                this.fascio = null;
                for (FascicoloCompilato fascicoloCompilato : alunno.getFascicoliCompilati()) {
                    if (!fascicoloCompilato.getStrumento().getTipo().equals("PRE_LETTURA")) continue;
                    this.fascio = fascicoloCompilato;
                    break;
                }
                this.itemsConRisposte = null;
                if (this.fascio != null) {
                    this.itemsConRisposte = this.fascio.getItemsConRisposte();
                    if (this.itemsConRisposte != null && !this.itemsConRisposte.isEmpty()) {
                        for (Item item : this.itemsConRisposte) {
                            this.rispostaScelta = item.getTipoDomanda().equals("Risposta articolata") || item.getTipoDomanda().equals("Cloze") ? ((ItemRisposto)item).getRispostaScelta().toUpperCase() : ((ItemRisposto)item).getRispostaScelta();
                            this.stringaAlunno = this.stringaAlunno + this.rispostaScelta + ";";
                        }
                    } else {
                        for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("PRE_LETTURA")) {
                            this.stringaAlunno = this.stringaAlunno + ";";
                        }
                    }
                } else {
                    for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("PRE_LETTURA")) {
                        this.stringaAlunno = this.stringaAlunno + ";";
                    }
                }
            }
            this.fascio = null;
            for (FascicoloCompilato fascicoloCompilato : alunno.getFascicoliCompilati()) {
                if (!fascicoloCompilato.getStrumento().getTipo().equals("NORMALE") || !fascicoloCompilato.getStrumento().getMateria().equals("Italiano")) continue;
                this.fascio = fascicoloCompilato;
                this.domandaFascicoloIta = fascicoloCompilato.getDomanda();
                this.codiceFascicoloIta = fascicoloCompilato.getCodice();
                break;
            }
            this.itemsConRisposte = null;
            if (this.fascio != null) {
                this.itemsConRisposte = this.fascio.getItemsConRisposte();
                if (this.itemsConRisposte != null && !this.itemsConRisposte.isEmpty()) {
                    for (Item item : this.itemsConRisposte) {
                        this.rispostaScelta = item.getTipoDomanda().equals("Risposta articolata") || item.getTipoDomanda().equals("Cloze") ? ((ItemRisposto)item).getRispostaScelta().toUpperCase() : ((ItemRisposto)item).getRispostaScelta();
                        this.stringaAlunno = this.stringaAlunno + this.rispostaScelta + ";";
                    }
                } else {
                    for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("Italiano")) {
                        this.stringaAlunno = this.stringaAlunno + ";";
                    }
                }
            } else {
                for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("Italiano")) {
                    this.stringaAlunno = this.stringaAlunno + ";";
                }
            }
            this.fascio = null;
            for (FascicoloCompilato fascicoloCompilato : alunno.getFascicoliCompilati()) {
                if (!fascicoloCompilato.getStrumento().getTipo().equals("NORMALE") || !fascicoloCompilato.getStrumento().getMateria().equals("Matematica")) continue;
                this.fascio = fascicoloCompilato;
                this.domandaFascicoloMat = fascicoloCompilato.getDomanda();
                this.codiceFascicoloMat = fascicoloCompilato.getCodice();
                break;
            }
            this.itemsConRisposte = null;
            if (this.fascio != null) {
                this.itemsConRisposte = this.fascio.getItemsConRisposte();
                if (this.itemsConRisposte != null && !this.itemsConRisposte.isEmpty()) {
                    for (ItemRisposto itemRisposto : this.itemsConRisposte) {
                        this.rispostaScelta = itemRisposto.getTipoDomanda().equals("Risposta articolata") || itemRisposto.getTipoDomanda().equals("Cloze") ? itemRisposto.getRispostaScelta().toUpperCase() : itemRisposto.getRispostaScelta();
                        this.stringaAlunno = this.stringaAlunno + this.rispostaScelta + ";";
                    }
                } else {
                    for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("Matematica")) {
                        this.stringaAlunno = this.stringaAlunno + ";";
                    }
                }
            } else {
                for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("Matematica")) {
                    this.stringaAlunno = this.stringaAlunno + ";";
                }
            }
            if (this.lastLivello == 2 || this.lastLivello == 8) break block33;
            this.fascio = null;
            for (FascicoloCompilato fascicoloCompilato : alunno.getFascicoliCompilati()) {
                if (!fascicoloCompilato.getStrumento().getTipo().equals("QST_ALU")) continue;
                this.fascio = fascicoloCompilato;
                break;
            }
            this.itemsConRisposte = null;
            if (this.fascio != null) {
                this.itemsConRisposte = this.fascio.getItemsConRisposte();
                if (this.itemsConRisposte != null && !this.itemsConRisposte.isEmpty()) {
                    for (Item item : this.itemsConRisposte) {
                        this.rispostaScelta = item.getTipoDomanda().equals("Risposta articolata") || item.getTipoDomanda().equals("Cloze") ? ((ItemRisposto)item).getRispostaScelta().toUpperCase() : ((ItemRisposto)item).getRispostaScelta();
                        this.stringaAlunno = this.stringaAlunno + this.rispostaScelta + ";";
                    }
                } else {
                    for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("QST_ALU")) {
                        this.stringaAlunno = this.stringaAlunno + ";";
                    }
                }
            } else {
                for (Item item : this.itemLivelloMaps.get(this.lastLivello).get("QST_ALU")) {
                    this.stringaAlunno = this.stringaAlunno + ";";
                }
            }
        }
    }
}

