/*
 * Decompiled with CFR 0.152.
 */
package invalsi.gui;

import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.Plesso;
import invalsi.business.scuole.IScuoleMgt;
import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import invalsi.gui.ProvaForm;
import invalsi.gui.dialogs.ErrorDialog;
import invalsi.utils.GenerazioneFiles;
import invalsi.utils.PasswordValidator_2016;
import invalsi.utils.db.ConnectionMgr;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;

public class MainForm
extends JFrame {
    private IScuoleMgt scuoleMgr;
    private ProvaForm provaForm;
    private String istitutoScelto;
    private List<Plesso> plessi;
    private JButton copiaInvalsiButton;
    private JButton datiStudenteButton;
    private JButton esciButton;
    private JTextField istitutoTextField;
    private JDialog jDialog1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JButton loginButton;
    private JButton logoutButton;
    private JLabel passwordLabel;
    private JPasswordField passwordTextField;
    private JButton proveButton;

    public MainForm() {
        this.initComponents();
        try {
            this.scuoleMgr = ScuoleMgr.getIstance();
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
            ErrorDialog.alert("Errore Interno:", "Manca il driver: " + ex.getMessage() + " (\u00e8 nella cartella 'lib')", "PER RISOLVERE:", "Leggere il file ReadMe.doc nella cartela 'doc' e seguirlo alla lettera.");
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.plessi = new LinkedList<Plesso>();
        this.setTitle("INVALSI - Recupero Dati Prove");
        this.addWindowListener(new MainFormListener());
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jPanel4 = new JPanel();
        this.istitutoTextField = new JTextField();
        this.loginButton = new JButton();
        this.jLabel1 = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.logoutButton = new JButton();
        this.passwordLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.esciButton = new JButton();
        this.copiaInvalsiButton = new JButton();
        this.datiStudenteButton = new JButton();
        this.proveButton = new JButton();
        this.jPanel7 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel8 = new JLabel();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.jLabel7.setFont(new Font("Tahoma", 1, 16));
        this.jLabel7.setText("Effettua l'accesso");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addContainerGap()));
        this.istitutoTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainForm.this.istitutoTextFieldFocusLost(evt);
            }
        });
        this.istitutoTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.istitutoTextFieldActionPerformed(evt);
            }
        });
        this.loginButton.setFont(new Font("Tahoma", 1, 11));
        this.loginButton.setText("Login");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.loginButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setText("  Mecc. Istituto ");
        this.passwordTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.passwordTextFieldActionPerformed(evt);
            }
        });
        this.logoutButton.setFont(new Font("Tahoma", 1, 11));
        this.logoutButton.setText("Logout");
        this.logoutButton.setEnabled(false);
        this.logoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.logoutButtonActionPerformed(evt);
            }
        });
        this.passwordLabel.setFont(new Font("Tahoma", 0, 12));
        this.passwordLabel.setText(" Codice attivazione");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.istitutoTextField, -2, 98, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.passwordLabel, -1, -1, Short.MAX_VALUE).addComponent(this.passwordTextField, -2, 110, -2)).addGap(18, 18, 18).addComponent(this.loginButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logoutButton).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginButton).addComponent(this.logoutButton)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.istitutoTextField, -2, -1, -2).addComponent(this.passwordTextField, -1, -1, -2)))).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel3).addGap(693, 693, 693)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(new SoftBevelBorder(0));
        this.esciButton.setFont(new Font("Tahoma", 1, 12));
        this.esciButton.setText("Esci");
        this.esciButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.esciButtonActionPerformed(evt);
            }
        });
        this.copiaInvalsiButton.setFont(new Font("Tahoma", 1, 12));
        this.copiaInvalsiButton.setText("Crea Copia Invalsi e File voti");
        this.copiaInvalsiButton.setEnabled(false);
        this.copiaInvalsiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.copiaInvalsiButtonActionPerformed(evt);
            }
        });
        this.datiStudenteButton.setFont(new Font("Tahoma", 1, 12));
        this.datiStudenteButton.setText("Dati Studente");
        this.datiStudenteButton.setEnabled(false);
        this.proveButton.setFont(new Font("Tahoma", 1, 12));
        this.proveButton.setText("Prove");
        this.proveButton.setEnabled(false);
        this.proveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.proveButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("leonardo.villani@");
        this.jLabel9.setFont(new Font("Tahoma", 1, 18));
        this.jLabel9.setText("INVALSI");
        this.jLabel4.setText(".it");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(5, 5, 5)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel2).addComponent(this.jLabel4)).addContainerGap()));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.copiaInvalsiButton, -1, -1, Short.MAX_VALUE).addComponent(this.proveButton, -1, -1, Short.MAX_VALUE)).addGap(18, 18, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.esciButton, -2, 190, -2).addComponent(this.datiStudenteButton, GroupLayout.Alignment.TRAILING, -2, 190, -2)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.datiStudenteButton, -1, -1, Short.MAX_VALUE).addComponent(this.proveButton, -2, 57, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.esciButton, -2, 57, -2).addComponent(this.copiaInvalsiButton, -2, 57, -2)).addGap(50, 50, 50).addComponent(this.jPanel7, -2, -1, -2)));
        this.jLabel8.setFont(new Font("Tahoma", 1, 16));
        this.jLabel8.setText("Seleziona una prova da compilare o altra operazione");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel8).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel6, -2, -1, -2).addGap(50, 50, 50).addComponent(this.jPanel5, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void esciButtonActionPerformed(ActionEvent evt) {
        System.exit(this.esci());
    }

    private int esci() {
        try {
            ConnectionMgr.getIstance().closeConnection();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 3;
    }

    private void proveButtonActionPerformed(ActionEvent evt) {
        this.provaForm = new ProvaForm(this, this.plessi);
        this.provaForm.setVisible(true);
        this.setVisible(false);
    }

    private void istitutoTextFieldFocusLost(FocusEvent evt) {
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        block10: {
            String istituto = this.istitutoTextField.getText().toUpperCase();
            if ((istituto = istituto.trim()) != null && istituto.length() == 10) {
                if (this.istitutoScelto == null || !this.istitutoScelto.equals(istituto)) {
                    char[] password_char = this.passwordTextField.getPassword();
                    String password = "";
                    for (char password_c : password_char) {
                        password = password + password_c;
                    }
                    if (password != null && password.length() < 1) {
                        ErrorDialog.alert("Attenzione:", "", "Inserire una Password");
                        return;
                    }
                    password = password.trim();
                    try {
                        this.plessi = this.scuoleMgr.getPlessiByIstituto(istituto);
                        if (this.plessi == null || this.plessi.isEmpty()) {
                            ErrorDialog.alert("Attenzione:", "", "Il meccanografico inserito non \u00e8 corretto");
                            this.istitutoTextField.requestFocus();
                            this.istitutoTextField.setEditable(true);
                            this.passwordTextField.setEditable(true);
                            this.loginButton.setEnabled(true);
                            this.logoutButton.setEnabled(false);
                            break block10;
                        }
                        if (PasswordValidator_2016.veridicaPassword(istituto, password)) {
                            this.istitutoScelto = istituto;
                            this.proveButton.setEnabled(true);
                            this.copiaInvalsiButton.setEnabled(true);
                            this.istitutoTextField.setEditable(false);
                            this.passwordTextField.setEditable(false);
                            this.loginButton.setEnabled(false);
                            this.logoutButton.setEnabled(true);
                            break block10;
                        }
                        if (null != password) {
                            this.passwordTextField.setText("");
                            this.passwordTextField.requestFocus();
                            ErrorDialog.alert("Attenzione:", "", "Password Errata");
                            break block10;
                        }
                        this.istitutoTextField.setText("");
                        this.passwordTextField.setText("");
                        ErrorDialog.alert("Errore Interno:", "", "Istrututo non cataloagato");
                    }
                    catch (ScuoleMgtException ex) {
                        Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
                        ErrorDialog.alert("Errore Interno:", "", ex.getMessage());
                        this.setVisible(false);
                        new MainForm().setVisible(true);
                    }
                }
            } else {
                ErrorDialog.alert("Attenzione:", "", "Il mecconografico di istituto ha 10 caratteri");
                this.istitutoTextField.requestFocus();
            }
        }
    }

    private void copiaInvalsiButtonActionPerformed(ActionEvent evt) {
        try {
            new GenerazioneFiles().generaFiles(this.istitutoScelto, this);
        }
        catch (FileNotFoundException ex) {
            ErrorDialog.alert("Errore Interno:", "", ex.getMessage());
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            ErrorDialog.alert("Errore Interno:", "", ex.getMessage());
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void logoutButtonActionPerformed(ActionEvent evt) {
        this.logoutButton.setEnabled(false);
        this.istitutoScelto = null;
        this.istitutoTextField.setText("");
        this.passwordTextField.setText("");
        this.istitutoTextField.setEditable(true);
        this.passwordTextField.setEditable(true);
        this.copiaInvalsiButton.setEnabled(false);
        this.proveButton.setEnabled(false);
        this.loginButton.setEnabled(true);
        try {
            ConnectionMgr.getIstance().closeConnection();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void passwordTextFieldActionPerformed(ActionEvent evt) {
    }

    private void istitutoTextFieldActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainForm().setVisible(true);
            }
        });
    }

    public void avvisaAlunnoConDatiMancanti(Classe classe, List<AlunnoValutato> alunni) {
        String seq = "";
        for (AlunnoValutato alunno : alunni) {
            seq = seq + alunno.getSequenziale() + ",";
        }
        seq = seq.substring(0, seq.length() - 1);
        ErrorDialog.alert("Attenzione:", "Copia Invalsi NON generata per la classe: ", "" + classe.getCorsoDiStudio().getPlesso().getMeccanografico() + ", " + classe.getCorsoDiStudio().getIndirizzo() + ", " + classe.getCorsoDiStudio().getSezione() + ", anno:" + classe.getAnnoDiCorso(), "Dati incompleti per alunni n. : " + seq);
    }

    public void avvisaAlunnoConDatiIncoerenti(Classe classe, AlunnoValutato alunno) {
        ErrorDialog.alert("Attenzione:", "Copia Invalsi NON generata per la classe:", "" + classe.getCorsoDiStudio().getPlesso().getMeccanografico() + ", " + classe.getCorsoDiStudio().getIndirizzo() + ", " + classe.getCorsoDiStudio().getSezione() + ", anno:" + classe.getAnnoDiCorso() + ", alunno:" + alunno.getSequenziale() + ". Svolge le prove?");
    }

    public void avvisaFileCreati(int generati, int classiLavorate) {
        ErrorDialog.alert("Informazione:", "Creati " + generati + " files su un totale di " + classiLavorate + " classi lavorate nella cartella 'generati'.", "SOLO NEL CASO DI LIV. 8:", "creati anche files dei voti nella cartella genarati/voti");
    }

    public void avvisaDatiNonInseriti() {
        ErrorDialog.alert("Informazione:", "", "Nessun file creato, sono stati inseriti i dati?");
    }

    public void exceptionCallBack(String message) {
        ErrorDialog.alert("Errore Interno:", "", message);
    }

    class MainFormListener
    implements WindowListener {
        MainFormListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(MainForm.this.esci());
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

