/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.remote.alunni;

import invalsi.beans.alunni.Alunno;
import invalsi.beans.alunni.AlunnoEsaminato;
import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.alunni.Genitore;
import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.StoricoClasse;
import invalsi.dao.interfaces.alunni.IAlunnoDao;
import invalsi.dao.remote.alunni.AbstractRemoteDao;
import invalsi.eccezioni.dao.alunni.AlunnoDaoException;
import invalsi.utils.net.SSLCertificationTruster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlunnoRemoteDao
extends AbstractRemoteDao
implements IAlunnoDao {
    @Override
    public List<Alunno> getAlunniByCodiceClasse(String codice, boolean conContesto) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Alunno> getAlunniByClasse(Classe classe, boolean conContesto) throws AlunnoDaoException {
        LinkedList<Alunno> alunni = new LinkedList<Alunno>();
        try {
            SSLCertificationTruster.doTrustToCertificates();
            URL url = new URL("https://invalsi-areaprove.cineca.it/contesto/ws_dati_contesto_2016.php?token=5027f944bba7d9c80cb9ea8db33b52c4&cod_cla=" + classe.getCodice());
            HttpURLConnection connection = null;
            BufferedReader read = null;
            InputStream is = null;
            InputStreamReader isr = null;
            connection = (HttpURLConnection)url.openConnection();
            if (null == connection) {
                System.out.println("Errore (Connection) nel recupero degli alunni, verranno creati senza contesto");
                AlunnoDaoException f = new AlunnoDaoException("Errore (Connection) nel recupero degli alunni, verranno creati senza contesto");
                Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, f);
                throw f;
            }
            try {
                is = connection.getInputStream();
                if (null == is) {
                    System.out.println("Errore (InputStream:null) nel recupero degli alunni. No internet connection.");
                    AlunnoDaoException f = new AlunnoDaoException("Errore (InputStream) nel recupero degli alunni. No internet connection.");
                    Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, f);
                    throw f;
                }
            }
            catch (ConnectException f) {
                System.out.println("Errore (InputStream:ConnectionException) nel recupero degli alunni. No internet connection.");
                Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, f);
                throw new AlunnoDaoException("Errore (InputStream:ConnectionException) nel recupero degli alunni. No internet connection.");
            }
            catch (UnknownHostException f) {
                System.out.println("Errore (InputStream:UnknownHostException) nel recupero degli alunni, verranno creati senza contesto");
                Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, f);
                throw new AlunnoDaoException("Errore (InputStream:UnknownHostException) nel recupero degli alunni. No internet connection.");
            }
            isr = new InputStreamReader(is);
            if (null == isr) {
                System.out.println("Errore (InputStreamReader) nel recupero degli alunni. No internet connection.");
                AlunnoDaoException f = new AlunnoDaoException("Errore (InputStreamReader) nel recupero degli alunni. No internet connection.");
                Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, f);
                throw f;
            }
            read = new BufferedReader(isr);
            if (null == read) {
                System.out.println("Errore nel recupero degli alunni, dati non trovati (BufferedReader)");
                AlunnoDaoException f = new AlunnoDaoException("Errore nel recupero degli alunni, dati non trovati (BufferedReader)");
                Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, f);
                throw f;
            }
            String responce = new String();
            String line = null;
            while ((line = read.readLine()) != null) {
                responce = responce + line;
            }
            responce = responce.replace(";;;;;;;;;;", ";_;_;_;_;_;_;_;_;_;");
            responce = responce.replace(";;;;;;;;;", ";_;_;_;_;_;_;_;_;");
            responce = responce.replace(";;;;;;;;", ";_;_;_;_;_;_;_;");
            responce = responce.replace(";;;;;;;", ";_;_;_;_;_;_;");
            responce = responce.replace(";;;;;;", ";_;_;_;_;_;");
            responce = responce.replace(";;;;;", ";_;_;_;_;");
            responce = responce.replace(";;;;", ";_;_;_;");
            responce = responce.replace(";;;", ";_;_;");
            responce = responce.replace(";;", ";_;");
            String nonDisponibile = "Non disponibile";
            String sidiNonDisponibile = "NON DISPONIBILE";
            String nonDisponibileIstr = "7. Non disponibile";
            String nonDisponibileProf = "10. Non disponibile";
            String[] datiAlunno = responce.split("\\;");
            int numeroStudenti = datiAlunno.length / 25;
            if (responce.contains("chiamata fallita, parametri non validi")) {
                System.out.println("Verifica accesso ad internet...OK. Internal Server Error - " + responce.substring(2));
                throw new AlunnoDaoException("chiamata fallita, parametri non validi");
            }
            if (responce.contains("classe non trovata")) {
                System.out.println("Verifica accesso ad internet...OK. Internal Server Error - " + responce.substring(2));
                throw new AlunnoDaoException("classe non trovata");
            }
            Alunno alunno = null;
            for (int i = 0; i < numeroStudenti; ++i) {
                String titoloMadre;
                String luogoMadre;
                String profPadre;
                String titoloPadre;
                String luogoPadre;
                LinkedList<Genitore> genitori;
                int pos;
                block83: {
                    block82: {
                        block81: {
                            block80: {
                                block79: {
                                    block78: {
                                        pos = i * 25;
                                        String sidi = datiAlunno[pos++].length() < 1 ? sidiNonDisponibile : datiAlunno[pos - 1];
                                        int sequenziale = datiAlunno[++pos].length() < 1 ? 1 + i : new Integer(datiAlunno[++pos - 1]);
                                        alunno = classe.getLivello() == 8 ? new AlunnoEsaminato(0, sequenziale, sidi) : new Alunno(0, sequenziale, sidi);
                                        if (datiAlunno[pos++].length() > 0) {
                                            alunno.setStato(datiAlunno[pos - 1]);
                                        } else {
                                            alunno.setStato("Altro");
                                        }
                                        if (datiAlunno[pos++].length() > 0) {
                                            alunno.setSesso(datiAlunno[pos - 1]);
                                        } else {
                                            alunno.setSesso("X");
                                        }
                                        if (datiAlunno[pos++].length() > 0) {
                                            alunno.setMeseNascita(datiAlunno[pos - 1]);
                                        } else {
                                            alunno.setMeseNascita(nonDisponibile);
                                        }
                                        if (datiAlunno[pos++].length() > 0) {
                                            alunno.setAnnoNascita(datiAlunno[pos - 1]);
                                        } else {
                                            alunno.setAnnoNascita(nonDisponibile);
                                        }
                                        if (datiAlunno[pos++].length() > 0) {
                                            alunno.setLuogoNascita(datiAlunno[pos - 1]);
                                        } else {
                                            alunno.setLuogoNascita(nonDisponibile);
                                        }
                                        if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                                            try {
                                                if (datiAlunno[pos - 1].substring(0, 11).equals("9 anni o pi")) {
                                                    alunno.setArrivoItalia("9 anni o piu");
                                                    break block78;
                                                }
                                                if (datiAlunno[pos - 1].substring(0, 12).equals("10 anni o pi")) {
                                                    alunno.setArrivoItalia("10 anni o piu");
                                                    break block78;
                                                }
                                                if (datiAlunno[pos - 1].substring(0, 12).equals("16 anni o pi")) {
                                                    alunno.setArrivoItalia("16 anni o piu");
                                                    break block78;
                                                }
                                                alunno.setArrivoItalia(datiAlunno[pos - 1]);
                                            }
                                            catch (IndexOutOfBoundsException eo) {
                                                alunno.setArrivoItalia(datiAlunno[pos - 1]);
                                            }
                                        } else {
                                            alunno.setArrivoItalia(nonDisponibile);
                                        }
                                    }
                                    if (datiAlunno[pos++].length() > 0) {
                                        if (datiAlunno[pos - 1].equals("0") || datiAlunno[pos - 1].equals("Non disponibile")) {
                                            alunno.setGiornoNascita("Non disponibile");
                                        } else {
                                            alunno.setGiornoNascita(datiAlunno[pos - 1]);
                                        }
                                    } else {
                                        alunno.setGiornoNascita("Non disponibile");
                                    }
                                    alunno.setDisabilita("");
                                    if (datiAlunno[pos++].length() > 0) {
                                        alunno.setVotoScrittoItaliano(datiAlunno[pos - 1]);
                                    } else {
                                        alunno.setVotoScrittoItaliano(nonDisponibile);
                                    }
                                    if (datiAlunno[pos++].length() > 0) {
                                        alunno.setVotoOraleItaliano(datiAlunno[pos - 1]);
                                    } else {
                                        alunno.setVotoOraleItaliano(nonDisponibile);
                                    }
                                    if (datiAlunno[pos++].length() > 0) {
                                        alunno.setVotoScrittoMatematica(datiAlunno[pos - 1]);
                                    } else {
                                        alunno.setVotoScrittoMatematica(nonDisponibile);
                                    }
                                    if (datiAlunno[pos++].length() > 0) {
                                        alunno.setVotoOraleMatematica(datiAlunno[pos - 1]);
                                    } else {
                                        alunno.setVotoOraleMatematica(nonDisponibile);
                                    }
                                    if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                                        try {
                                            if (datiAlunno[pos - 1].substring(0, 11).equals("40 ore o pi")) {
                                                alunno.setOreLerzione("40 ore o piu");
                                                break block79;
                                            }
                                            alunno.setOreLerzione(datiAlunno[pos - 1]);
                                        }
                                        catch (IndexOutOfBoundsException eo) {
                                            alunno.setOreLerzione(datiAlunno[pos - 1]);
                                        }
                                    } else {
                                        alunno.setOreLerzione(nonDisponibile);
                                    }
                                }
                                if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                                    try {
                                        if (datiAlunno[pos - 1].substring(0, 11).equals("10 ore o pi")) {
                                            alunno.setOreItaliano("10 ore o piu");
                                            break block80;
                                        }
                                        alunno.setOreItaliano(datiAlunno[pos - 1]);
                                    }
                                    catch (IndexOutOfBoundsException eo) {
                                        alunno.setOreItaliano(datiAlunno[pos - 1]);
                                    }
                                } else {
                                    alunno.setOreItaliano(nonDisponibile);
                                }
                            }
                            if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                                try {
                                    if (datiAlunno[pos - 1].substring(0, 11).equals("10 ore o pi")) {
                                        alunno.setOreMatematica("10 ore o piu");
                                        break block81;
                                    }
                                    alunno.setOreMatematica(datiAlunno[pos - 1]);
                                }
                                catch (IndexOutOfBoundsException eo) {
                                    alunno.setOreMatematica(datiAlunno[pos - 1]);
                                }
                            } else {
                                alunno.setOreMatematica(nonDisponibile);
                            }
                        }
                        if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                            if (datiAlunno[pos - 1].substring(0, 1).equals("S\u00ec".substring(0, 1))) {
                                alunno.setNido("Si");
                            } else {
                                alunno.setNido(datiAlunno[pos - 1]);
                            }
                        } else {
                            alunno.setNido(nonDisponibile);
                        }
                        if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                            if (datiAlunno[pos - 1].substring(0, 1).equals("S\u00ec".substring(0, 1))) {
                                alunno.setMaterna("Si");
                            } else {
                                alunno.setMaterna(datiAlunno[pos - 1]);
                            }
                        } else {
                            alunno.setMaterna(nonDisponibile);
                        }
                        genitori = new LinkedList<Genitore>();
                        luogoPadre = datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_") ? datiAlunno[pos - 1] : nonDisponibile;
                        if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                            try {
                                if (datiAlunno[pos - 1].substring(0, 21).equals("4. Diploma di maturit")) {
                                    titoloPadre = "4. Diploma di maturita";
                                    break block82;
                                }
                                titoloPadre = datiAlunno[pos - 1];
                            }
                            catch (IndexOutOfBoundsException eo) {
                                titoloPadre = datiAlunno[pos - 1];
                            }
                        } else {
                            titoloPadre = nonDisponibileIstr;
                        }
                    }
                    profPadre = datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_") ? datiAlunno[pos - 1] : nonDisponibileProf;
                    luogoMadre = datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_") ? datiAlunno[pos - 1] : nonDisponibile;
                    if (datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_")) {
                        try {
                            if (datiAlunno[pos - 1].substring(0, 21).equals("4. Diploma di maturit")) {
                                titoloMadre = "4. Diploma di maturita";
                                break block83;
                            }
                            titoloMadre = datiAlunno[pos - 1];
                        }
                        catch (IndexOutOfBoundsException eo) {
                            titoloMadre = datiAlunno[pos - 1];
                        }
                    } else {
                        titoloMadre = nonDisponibileIstr;
                    }
                }
                String profMadre = datiAlunno[pos++].length() > 0 && !datiAlunno[pos - 1].equals("_") ? datiAlunno[pos - 1] : nonDisponibileProf;
                genitori.add(new Genitore("M", luogoPadre, titoloPadre, profPadre));
                genitori.add(new Genitore("F", luogoMadre, titoloMadre, profMadre));
                alunno.setGenitori(genitori);
                alunni.add(alunno);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(AlunnoRemoteDao.class.getName()).log(Level.SEVERE, null, ex);
        }
        return alunni;
    }

    @Override
    public void creaAlunniDellaClasse(int classeId, int livello) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<Integer, String> getOpzioniContestoPossibili(String infromazioniDesiderate) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateContestoAlunno(int idAlunno, String scrittoItaliano, String oraleItaliano, String scrittoMatematica, String oraleMatematica, String disabilita, String statoAlunno) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<AlunnoValutato> getAlunniValutatiByClasse(Classe classe) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSvolgeProva(int id, String tipoProva, String materia) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void salvaAlunniDellaClasse(Classe classe, List<Alunno> alunni) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Alunno getAlunnoByIdClasseAndSequenziale(int idClasse, int Sequenziale) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AlunnoValutato aggiungiAlunnoAllaClasse(StoricoClasse classe) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSidiAlunno(int idAlunno, String sidi) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, String> getInfoOnProveAndQuestionari(int idAlunno, int livello) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateContestoEsameAlunno(int idAlunno, String cognome, String nome, String tipoCandidato, String ammesso, String votoAmmissione, String votoEsameItalino, String votoEsameMatematica, String votoEsameLingua, String votoEsameInvalsi) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AlunnoEsaminato getAlunnoEsaminato(int idAlunno) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cleanAlunniDelleClasse(int CLasseId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean ciSonoRisposteDellAlunno(int idAlunno) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAlunniEsaminatiEsterni(int idClasse) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

