/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.scuole;

import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.CorsoDiStudio;
import invalsi.dao.interfaces.scuole.ICorsoDiStudioDao;
import invalsi.dao.local.scuole.AbstractLocalDao;
import invalsi.eccezioni.dao.prove.CorsoDiStudioDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorsoDiStudioLocalDao
extends AbstractLocalDao
implements ICorsoDiStudioDao {
    public CorsoDiStudioLocalDao() throws CorsoDiStudioDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new CorsoDiStudioDaoException(ex.getMessage());
        }
    }

    @Override
    public List<CorsoDiStudio> getCorsiByPlesso(String plesso) throws CorsoDiStudioDaoException {
        LinkedList<CorsoDiStudio> corsi = new LinkedList<CorsoDiStudio>();
        CorsoDiStudio nextCorso = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("SELECT DISTINCT CDS.ID, CDS.SEZIONE, IND.NOME, SET.NOME, PER.NOME, CDS.INDIRIZZO FROM CORSO_DI_STUDIO AS CDS LEFT OUTER JOIN INDIRIZZO AS IND ON CDS.INDIRIZZO=IND.ID LEFT OUTER JOIN SETTORE AS SET ON IND.SETTORE=SET.ID LEFT OUTER JOIN PERCORSO AS PER ON SET.PERCORSO = PER.ID WHERE PLESSO = ? ORDER BY CDS.INDIRIZZO, CDS.SEZIONE;");
            stat.setString(1, plesso);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                nextCorso = new CorsoDiStudio(result.getInt(1), result.getString(2), result.getString(3), result.getString(4), result.getString(5));
                corsi.add(nextCorso);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new CorsoDiStudioDaoException("Errore nel recuperare i corsi di studio dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new CorsoDiStudioDaoException(ex.getMessage());
        }
        return corsi;
    }

    @Override
    public CorsoDiStudio getCosoById(int id) throws CorsoDiStudioDaoException {
        CorsoDiStudio corso = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("SELECT ID, SEZIONE,INDIRIZZO LEFT OUTER JOIN \n\tINDIRIZZO ON CORSO_DI_STUDIO.INDIRIZZO = INDIRIZZO.ID\n\tWHERE CORSO_DI_STUDIO.ID=?");
            stat.setInt(1, id);
            stat.execute();
            result = stat.getResultSet();
            if (result.next()) {
                corso = new CorsoDiStudio(result.getInt(1), result.getString(2), result.getString(3));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new CorsoDiStudioDaoException("Errore nel recuperare i corsi di studio dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new CorsoDiStudioDaoException(ex.getMessage());
        }
        return corso;
    }

    @Override
    public Collection<CorsoDiStudio> getCorsiPopolatiConClassiByClassi(Collection<Classe> classi) throws CorsoDiStudioDaoException {
        HashMap<Integer, CorsoDiStudio> corsi = null;
        corsi = new HashMap<Integer, CorsoDiStudio>();
        Connection conn = null;
        LinkedList<Classe> classiPerCorso = null;
        try {
            conn = this.connMgr.getConnection();
            PreparedStatement stat = conn.prepareStatement("select distinct CORSO_DI_STUDIO.ID, CORSO_DI_STUDIO.SEZIONE, INDIRIZZO.NOME, CORSO_DI_STUDIO.PLESSO, CLASSE.ID\n\tfrom CORSO_DI_STUDIO \n\tjoin CLASSE on CLASSE.CORSO_DI_STUDIO = CORSO_DI_STUDIO.ID\n  join INDIRIZZO on INDIRIZZO.ID = CORSO_DI_STUDIO.INDIRIZZO\n where CLASSE.ID=?\norder by CORSO_DI_STUDIO.ID, CLASSE.ID;");
            for (Classe classe : classi) {
                stat.setInt(1, classe.getId());
                stat.execute();
                ResultSet result = stat.getResultSet();
                CorsoDiStudio corsoDiStudio = null;
                while (result.next()) {
                    if (corsi.get(result.getInt("CORSO_DI_STUDIO.ID")) == null) {
                        corsoDiStudio = new CorsoDiStudio(result.getInt("CORSO_DI_STUDIO.ID"), result.getString("CORSO_DI_STUDIO.SEZIONE"), result.getString("INDIRIZZO.NOME"));
                        classiPerCorso = new LinkedList<Classe>();
                        corsi.put(result.getInt("CORSO_DI_STUDIO.ID"), corsoDiStudio);
                    }
                    classiPerCorso.add(classe);
                    classe.setCorsoDiStudio(corsoDiStudio);
                }
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new CorsoDiStudioDaoException("Errore nel recuperare i corsi di studio dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(CorsoDiStudioLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new CorsoDiStudioDaoException(ex.getMessage());
        }
        return corsi.values();
    }
}

