/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.scuole;

import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.CorsoDiStudio;
import invalsi.beans.scuole.Plesso;
import invalsi.dao.interfaces.scuole.IClasseDao;
import invalsi.dao.local.scuole.AbstractLocalDao;
import invalsi.eccezioni.dao.scuole.ClasseDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClasseLocalDao
extends AbstractLocalDao
implements IClasseDao {
    public ClasseLocalDao() throws ClasseDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
    }

    @Override
    public List<Classe> getClassiByCorso(int corsoId) throws ClasseDaoException {
        LinkedList<Classe> classi = new LinkedList<Classe>();
        Connection conn = null;
        try {
            conn = this.connMgr.getConnection();
            PreparedStatement stat = conn.prepareStatement("SELECT DISTINCT CLASSE.ID, CLASSE.CODICE, CLASSE.ANNO_DI_CORSO, CLASSE.LIVELLO, CLASSE.N_ALUNNI\nFROM CLASSE\nWHERE \tCORSO_DI_STUDIO = ?\nORDER BY ANNO_DI_CORSO;");
            stat.setInt(1, corsoId);
            stat.execute();
            ResultSet result = stat.getResultSet();
            Classe nextClasse = null;
            while (result.next()) {
                nextClasse = new Classe(result.getInt(1), result.getString(2), result.getInt(3), result.getInt(4));
                classi.add(nextClasse);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recuperare le Classi dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return classi;
    }

    @Override
    public int getNumeroAlluniClasse(int classeId) throws ClasseDaoException {
        int numeroAlunni = -1;
        Connection conn = null;
        try {
            conn = this.connMgr.getConnection();
            PreparedStatement stat = conn.prepareStatement("SELECT N_ALUNNI FROM CLASSE WHERE CLASSE.ID = ?;");
            stat.setInt(1, classeId);
            stat.execute();
            ResultSet result = stat.getResultSet();
            Object nextClasse = null;
            if (result.next()) {
                numeroAlunni = result.getInt("N_ALUNNI");
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recuperare il numero degli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return numeroAlunni;
    }

    @Override
    public Map<Integer, String> getOreDiLezioneOptions() throws ClasseDaoException {
        HashMap<Integer, String> resultingMap = new HashMap<Integer, String>();
        Connection conn = null;
        Statement stat = null;
        ResultSet result = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.createStatement();
            stat.execute("SELECT ID,VALORE FROM ORE_SETTIMANALI ORDER BY ID;");
            result = stat.getResultSet();
            while (result.next()) {
                int key = result.getInt(1);
                String value = result.getString(2);
                resultingMap.put(new Integer(key), value);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recuperare il numero degli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return resultingMap;
    }

    @Override
    public List<Classe> getClassiBySvolgimentoProveAndIstituto(String istituto) throws ClasseDaoException {
        LinkedList<CorsoDiStudio> corsiPerPlesso = null;
        LinkedList<Classe> classi = new LinkedList<Classe>();
        LinkedList<Classe> classiPerCorso = null;
        Connection conn = null;
        Plesso plesso = null;
        CorsoDiStudio corso = null;
        try {
            conn = this.connMgr.getConnection();
            PreparedStatement stat = conn.prepareStatement("select distinct CLASSE.ID, CLASSE.CODICE, CLASSE.ANNO_DI_CORSO, CLASSE.LIVELLO, CLASSE.N_ALUNNI, \n\t\t\t CORSO_DI_STUDIO.ID, CORSO_DI_STUDIO.SEZIONE, INDIRIZZO.NOME, SETTORE.NOME, PERCORSO.NOME,\n\t\t\t PLESSO.MECCANOGRAFICO, PLESSO.FORMAZIONE, PLESSO.ISTITUTO\n                        \tFROM CLASSE\n                        \t     join ALUNNO on ALUNNO.CLASSE = CLASSE.ID\n                              join CORSO_DI_STUDIO on CORSO_DI_STUDIO.ID=CLASSE.CORSO_DI_STUDIO\n                              join INDIRIZZO on INDIRIZZO.ID=CORSO_DI_STUDIO.INDIRIZZO\n                              join SETTORE on SETTORE.ID=INDIRIZZO.SETTORE\n                              join PERCORSO on PERCORSO.ID=SETTORE.PERCORSO\n                              join PLESSO on PLESSO.MECCANOGRAFICO=CORSO_DI_STUDIO.PLESSO\n                        where (ALUNNO.ID IN (SELECT SVOLGE_PROVA.ALUNNO FROM SVOLGE_PROVA)\n                        \tor ALUNNO.ID IN (SELECT COMPILA_QUESTIONARIO.ALUNNO FROM COMPILA_QUESTIONARIO))\n     \tand PLESSO.ISTITUTO=?\n     order by PLESSO.MECCANOGRAFICO, CORSO_DI_STUDIO.ID, CLASSE.livello");
            stat.setString(1, istituto);
            stat.execute();
            ResultSet result = stat.getResultSet();
            Classe nextClasse = null;
            String MeccanograficoPlesso = "";
            int idCorso = 0;
            while (result.next()) {
                if (idCorso != result.getInt("CORSO_DI_STUDIO.ID")) {
                    if (!MeccanograficoPlesso.equals(result.getString("PLESSO.MECCANOGRAFICO"))) {
                        MeccanograficoPlesso = result.getString("PLESSO.MECCANOGRAFICO");
                        corsiPerPlesso = new LinkedList<CorsoDiStudio>();
                        plesso = new Plesso(MeccanograficoPlesso, istituto, result.getInt("PLESSO.FORMAZIONE"), corsiPerPlesso);
                    }
                    idCorso = result.getInt("CORSO_DI_STUDIO.ID");
                    classiPerCorso = new LinkedList<Classe>();
                    corso = new CorsoDiStudio(idCorso, result.getString("INDIRIZZO.NOME"), result.getString("CORSO_DI_STUDIO.SEZIONE"), classi);
                    corso.setSettore(result.getString("SETTORE.NOME"));
                    corso.setPercorso(result.getString("PERCORSO.NOME"));
                    corso.setPlesso(plesso);
                    corsiPerPlesso.add(corso);
                }
                nextClasse = new Classe(result.getInt("CLASSE.ID"), result.getString("CLASSE.CODICE"), result.getInt("CLASSE.ANNO_DI_CORSO"), result.getInt("CLASSE.LIVELLO"));
                nextClasse.setCorsoDiStudio(corso);
                classiPerCorso.add(nextClasse);
                classi.add(nextClasse);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recuperare le Classi dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return classi;
    }

    @Override
    public void setNumeroAlunniDellaClasse(Classe classe, int numeroAlunni) throws ClasseDaoException {
        Connection conn = null;
        try {
            conn = this.connMgr.getConnection();
            PreparedStatement stat = conn.prepareStatement("update CLASSE set CLASSE.N_ALUNNI=? where CLASSE.ID=?;");
            stat.setInt(2, classe.getId());
            stat.setInt(1, numeroAlunni);
            stat.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel aggiornare il numero degli alunni nel DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
    }

    @Override
    public int getNextSequenzialeAlunno(int idClasse) throws ClasseDaoException {
        Connection conn = null;
        Object stat_alunno = null;
        Object stat_contesto = null;
        PreparedStatement stat_seq_alunno = null;
        ResultSet result = null;
        int sequenzialeAlunno = 0;
        try {
            conn = this.connMgr.getConnection();
            stat_seq_alunno = conn.prepareStatement("select max(cast(ALUNNO.SEQUENZIALE as int)) +1 from ALUNNO where ALUNNO.CLASSE=?;");
            stat_seq_alunno.execute();
            result = stat_seq_alunno.getResultSet();
            if (result.next()) {
                sequenzialeAlunno = result.getInt(1);
            }
            if (sequenzialeAlunno == 0) {
                sequenzialeAlunno = 1;
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseDaoException.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recupero dati dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseDaoException.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return sequenzialeAlunno;
    }

    @Override
    public Classe getPrimaClasseConProveMancanti(Collection<Classe> classi) throws ClasseDaoException {
        Connection conn = null;
        PreparedStatement stat_prove_per_classe = null;
        PreparedStatement stat_questionari_per_classe = null;
        Object stat_seq_alunno = null;
        int numeroAlunni = 0;
        ResultSet result = null;
        HashMap<Integer, Integer> proveCalsse = new HashMap<Integer, Integer>();
        try {
            conn = this.connMgr.getConnection();
            stat_prove_per_classe = conn.prepareStatement("select count(1), ALUNNO.CLASSE  from SVOLGE_PROVA \n\t\tjoin ALUNNO on SVOLGE_PROVA.ALUNNO=ALUNNO.ID\n\t\tgroup by ALUNNO.CLASSE;");
            stat_prove_per_classe.execute();
            result = stat_prove_per_classe.getResultSet();
            while (result.next()) {
                proveCalsse.put(result.getInt(2), result.getInt(1));
            }
            stat_questionari_per_classe = conn.prepareStatement("select count(1), ALUNNO.CLASSE from COMPILA_QUESTIONARIO\n\t\tjoin ALUNNO on COMPILA_QUESTIONARIO.ALUNNO=ALUNNO.ID\n\t\tgroup by ALUNNO.CLASSE;");
            stat_questionari_per_classe.execute();
            result = stat_questionari_per_classe.getResultSet();
            while (result.next()) {
                Integer valoreProve = (Integer)proveCalsse.get(result.getInt(2));
                if (valoreProve != null) {
                    proveCalsse.put(result.getInt(2), result.getInt(1) + valoreProve);
                    continue;
                }
                proveCalsse.put(result.getInt(2), result.getInt(1));
            }
            for (Classe classe : classi) {
                numeroAlunni = this.getNumeroAlluniClasse(classe.getId());
                if ((Integer)proveCalsse.get(classe.getId()) >= numeroAlunni * 3) continue;
                return classe;
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseDaoException.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recupero dati dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseDaoException.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return null;
    }

    @Override
    public Classe getUnaClasseByIstituto(String istituto) throws ClasseDaoException {
        Classe unaClasse = null;
        Connection conn = null;
        PreparedStatement stat_classe = null;
        ResultSet result = null;
        try {
            conn = this.connMgr.getConnection();
            stat_classe = conn.prepareStatement("select top(1) CLASSE.ID, CLASSE.CODICE, CLASSE.ANNO_DI_CORSO, CLASSE.LIVELLO, CLASSE.N_ALUNNI \n\tfrom CLASSE \n\t\tjoin CORSO_DI_STUDIO on CLASSE.CORSO_DI_STUDIO = CORSO_DI_STUDIO.ID\n\t\tjoin PLESSO on  CORSO_DI_STUDIO.PLESSO = PLESSO.MECCANOGRAFICO \nwhere PLESSO.ISTITUTO=?;");
            stat_classe.setString(1, istituto);
            stat_classe.execute();
            result = stat_classe.getResultSet();
            if (result.next()) {
                unaClasse = new Classe(result.getInt("CLASSE.ID"), result.getString("CLASSE.CODICE"), result.getInt("CLASSE.ANNO_DI_CORSO"), result.getInt("CLASSE.LIVELLO"));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ClasseDaoException.class.getName()).log(Level.SEVERE, null, e);
            throw new ClasseDaoException("Errore nel recupero dati dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ClasseDaoException.class.getName()).log(Level.SEVERE, null, ex);
            throw new ClasseDaoException(ex.getMessage());
        }
        return unaClasse;
    }
}

