/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.prove.correzione;

import invalsi.beans.prove.ItemRisposto;
import invalsi.beans.prove.correzione.BloccoDiCorrezione;
import invalsi.beans.prove.correzione.Gruppo;
import invalsi.beans.prove.correzione.Range;
import invalsi.dao.interfaces.prove.correzione.IBloccoDiCorrezioneDao;
import invalsi.dao.local.prove.correzione.AbstractLocalDao;
import invalsi.eccezioni.prove.correzione.BloccoDiCorrezioneDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BloccoDiCorrezioneLocalDao
extends AbstractLocalDao
implements IBloccoDiCorrezioneDao {
    public BloccoDiCorrezioneLocalDao() throws BloccoDiCorrezioneDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BloccoDiCorrezioneLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new BloccoDiCorrezioneDaoException(ex.getMessage());
        }
    }

    @Override
    public List<BloccoDiCorrezione> getBlocchiDiItemConRisposte(int idAlunno, int idProva, int sequenzialeFascicolo) throws BloccoDiCorrezioneDaoException {
        LinkedList<ItemRisposto> items = null;
        LinkedList<String> listaRispostePossibiliItem = null;
        LinkedList<Gruppo> gruppi = null;
        LinkedList<BloccoDiCorrezione> blocchi = null;
        Connection conn = null;
        PreparedStatement stat_blocco = null;
        PreparedStatement stat_range = null;
        ResultSet result_blocco = null;
        ResultSet result_range = null;
        try {
            conn = ConnectionMgr.getIstance().getConnection();
            stat_range = conn.prepareStatement("select RANGE.BLOCCO, RANGE.STRUMENTO, RANGE.RISPOSTE_MIN, RANGE.RISPOSTE_MAX, RANGE.PUNTEGGIO\nfrom RANGE \nwhere RANGE.BLOCCO=? and RANGE.STRUMENTO=?\norder by RANGE.RISPOSTE_MIN;");
            stat_blocco = conn.prepareStatement("select distinct RISPOSTA_ITEM.ALUNNO,ITEM.STRUMENTO, ITEM.FASCICOLO,BLOCCO.ETICHETTA, BLOCCO.DIFFICOLTA,\n                       GRUPPO.ID, METODO_DI_CORREZIONE.FATTORE_DI_CORREZIONE,\n                       ITEM.ID, ITEM.POSIZIONE, ITEM.ETICHETTA, ITEM.CODICE_FORTE, TIPO_DOMANDA.NOME, \n                       ITEM.ALTERNATIVE_DI_RISPOSTA, ITEM.RISPOSTA_CORRETTA, RISPOSTA_ITEM.RISPOSTA\n              from ITEM\n            \tjoin RISPOSTA_ITEM ON RISPOSTA_ITEM.ITEM=ITEM.ID\n            \tjoin GRUPPO on ITEM.GRUPPO = GRUPPO.ID\n            \tjoin BLOCCO on GRUPPO.BLOCCO = BLOCCO.ETICHETTA\n            \tjoin METODO_DI_CORREZIONE on METODO_DI_CORREZIONE.ID = GRUPPO.METODO_DI_CORREZIONE\n                join TIPO_DOMANDA on ITEM.TIPO_DOMANDA=TIPO_DOMANDA.CODICE\nwhere RISPOSTA_ITEM.ALUNNO = ? and ITEM.STRUMENTO = ? and ITEM.FASCICOLO = ? \norder by BLOCCO.ETICHETTA, GRUPPO.ID, ITEM.POSIZIONE ;");
            stat_blocco.setInt(1, idAlunno);
            stat_blocco.setInt(2, idProva);
            stat_blocco.setInt(3, sequenzialeFascicolo);
            stat_blocco.execute();
            result_blocco = stat_blocco.getResultSet();
            String etichettaBlocco = "";
            int idGruppo = -1;
            blocchi = new LinkedList<BloccoDiCorrezione>();
            while (result_blocco.next()) {
                if (idGruppo != result_blocco.getInt("GRUPPO.ID")) {
                    idGruppo = result_blocco.getInt("GRUPPO.ID");
                    if (!etichettaBlocco.equals(result_blocco.getString("BLOCCO.ETICHETTA"))) {
                        etichettaBlocco = result_blocco.getString("BLOCCO.ETICHETTA");
                        gruppi = new LinkedList<Gruppo>();
                        LinkedList<Range> ranges = new LinkedList<Range>();
                        stat_range.setString(1, etichettaBlocco);
                        stat_range.setInt(2, idProva);
                        stat_range.execute();
                        result_range = stat_range.getResultSet();
                        while (result_range.next()) {
                            Range range = new Range(result_range.getInt("RANGE.RISPOSTE_MIN"), result_range.getInt("RANGE.RISPOSTE_MAX"), result_range.getInt("RANGE.PUNTEGGIO"));
                            ranges.add(range);
                        }
                        BloccoDiCorrezione blocco = new BloccoDiCorrezione(etichettaBlocco, result_blocco.getString("BLOCCO.DIFFICOLTA"), gruppi, ranges);
                        blocchi.add(blocco);
                    }
                    items = new LinkedList<ItemRisposto>();
                    Gruppo gruppo = new Gruppo(idGruppo, result_blocco.getFloat("METODO_DI_CORREZIONE.FATTORE_DI_CORREZIONE"), items);
                    gruppi.add(gruppo);
                }
                listaRispostePossibiliItem = new LinkedList<String>();
                int idItem = result_blocco.getInt("ITEM.ID");
                int posizioneItem = result_blocco.getInt("ITEM.POSIZIONE");
                String etichettaItem = result_blocco.getString("ITEM.ETICHETTA");
                String codiceForte = result_blocco.getString("ITEM.CODICE_FORTE");
                String stringRisposte = result_blocco.getString("ITEM.ALTERNATIVE_DI_RISPOSTA");
                listaRispostePossibiliItem.addAll(Arrays.asList(stringRisposte.split("\\;")));
                String rispostaCorretta = result_blocco.getString("ITEM.RISPOSTA_CORRETTA");
                String rispostaScelta = result_blocco.getString("RISPOSTA_ITEM.RISPOSTA");
                String tipoDomanda = result_blocco.getString("TIPO_DOMANDA.NOME");
                ItemRisposto item = new ItemRisposto(idItem, posizioneItem, etichettaItem, codiceForte, listaRispostePossibiliItem, rispostaCorretta, rispostaScelta, idGruppo, tipoDomanda);
                items.add(item);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(BloccoDiCorrezioneLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new BloccoDiCorrezioneDaoException("Errore nel recuperare i blocchi di correzione (SQLException)");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BloccoDiCorrezioneLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new BloccoDiCorrezioneDaoException("Errore nel recuperare i blocchi di correzione (ClassNotFoundException)");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(BloccoDiCorrezioneLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new BloccoDiCorrezioneDaoException("Errore nel recuperare i blocchi di correzione (ConnectionException)");
        }
        return blocchi;
    }
}

