/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.alunni;

import invalsi.beans.alunni.Alunno;
import invalsi.beans.alunni.AlunnoEsaminato;
import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.alunni.Genitore;
import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.StoricoClasse;
import invalsi.dao.interfaces.alunni.IAlunnoDao;
import invalsi.dao.local.alunni.AbstractLocalDao;
import invalsi.eccezioni.dao.alunni.AlunnoDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlunnoLocalDao
extends AbstractLocalDao
implements IAlunnoDao {
    private static boolean loopChecker = false;

    public AlunnoLocalDao() throws AlunnoDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
    }

    @Override
    public List<Alunno> getAlunniByCodiceClasse(String codice, boolean conContesto) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Alunno> getAlunniByClasse(Classe classe, boolean conContesto) throws AlunnoDaoException {
        LinkedList<Alunno> alunni = new LinkedList<Alunno>();
        Alunno nextAlunno = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Connection conn = null;
        try {
            conn = this.connMgr.getConnection();
            if (!conContesto) {
                stat = conn.prepareStatement("SELECT ALUNNO.ID, ALUNNO.SEQUENZIALE, ALUNNO.SIDI FROM ALUNNO WHERE ALUNNO.CLASSE=?;");
                stat.setInt(1, classe.getId());
                stat.execute();
                result = stat.getResultSet();
                if (classe.getLivello() == 8) {
                    while (result.next()) {
                        nextAlunno = classe.getLivello() == 8 ? new AlunnoEsaminato(result.getInt("ALUNNO.ID"), result.getInt("ALUNNO.SEQUENZIALE"), result.getString("ALUNNO.SIDI")) : new Alunno(result.getInt("ALUNNO.ID"), result.getInt("ALUNNO.SEQUENZIALE"), result.getString("ALUNNO.SIDI"));
                        alunni.add(nextAlunno);
                    }
                }
            } else {
                stat = classe.getLivello() == 8 ? conn.prepareStatement("SELECT  ALUNNO.ID,\n                                                 ALUNNO.SEQUENZIALE,\n                                                 ALUNNO.SIDI,\n                                    \t\t/* CONTESTO */\n                                    \t\tCONTESTO.ANNO,\n                                    \t\tGIORNO_NASCITA.VALORE,\n                                    \t\tMESE_NASCITA.NOME,\n                                    \t\tCONTESTO.ANNO_NASCITA,\n                                    \t\tLUOGO_NASCITA.VALORE,\n                                    \t\tARRIVO_ITALIA.VALORE,\n                                    \t\tCONTESTO.NIDO,\n                                    \t\tCONTESTO.MATERNA,\n                                    \t\tCONTESTO.SESSO,\n                                    \t\tDISABILITA.VALORE,\n                                    \t\tSTATO.VALORE,\n                                    \t\tSCRITTO_ITALIANO.VALORE,\n                                    \t\tORALE_ITALIANO.VALORE,\n                                    \t\tSCRITTO_MATEMATICA.VALORE,\n                                    \t\tORALE_MATEMATICA.VALORE,\n                                    \t\tORE_ITALIANO.VALORE,\n                                    \t\tORE_MATEMATICA.VALORE,\n                                    \t\tGENITORE_01.SESSO,\n                                    \t\tNASCITA_GENITORE_1.VALORE,\n                                    \t\tISTRUZIONE_GENITORE_1.VALORE,\n                                    \t\tOCCUPAZIONE_GENITORE_1.VALORE,\n                                    \t\tGENITORE_02.SESSO,\n                                    \t\tNASCITA_GENITORE_2.VALORE,\n                                    \t\tISTRUZIONE_GENITORE_2.VALORE,\n                                    \t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                                   ORE_SETTIMANALI.VALORE,\n                                                   /* CONTESTO_ESAME */\n                                                   CONTESTO_ESAME.COGNOME,\n                                                   CONTESTO_ESAME.NOME,\n                                                   TIPO_CANDIDATO.VALORE,\n                                                   AMMESSO.VALORE,\n                                                   VOTO_AMMISSIONE.VALORE,\n                                                   /* ESAME */\n                                                 VOTO_INVALSI.VALORE,\n                                                 /* PUNTEGGI PROVE */\n                                                ESITO_PROVA_ITA.VALORE,\n                                                ESITO_PROVA_MAT.VALORE,\n                                                TEMPO_AGGIUNTIVO_ITA.VALORE,\n                                                TEMPO_AGGIUNTIVO_MAT.VALORE,\n                                                VOTO_PROVA_ESAME_ITALIANO.VALORE,\n                                                VOTO_PROVA_ESAME_MATEMATICA.VALORE,\n                                                VOTO_PROVA_ESAME_LINGUA.VALORE\n                                    \tFROM ALUNNO \n                                    \t\t/* CONTESTO */\n                                    \t\tLEFT OUTER JOIN CONTESTO ON ALUNNO.ID = CONTESTO.ALUNNO\n                                    \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n                                    \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n                                    \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n                                    \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n                                    \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n                                    \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n                                    \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n                                    \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                                                 LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID\n                                          /* CONTESTO_ESAME*/\n                                          LEFT OUTER JOIN CONTESTO_ESAME ON CONTESTO_ESAME.ALUNNO = ALUNNO.ID\n                                          LEFT OUTER JOIN TIPO_CANDIDATO ON TIPO_CANDIDATO.ID = CONTESTO_ESAME.TIPO_CANDIDATO\n                                          LEFT OUTER JOIN VOTO_AMMISSIONE  ON VOTO_AMMISSIONE.ID = CONTESTO_ESAME.VOTO_AMMISSIONE   \n                                          LEFT OUTER JOIN AMMESSO  ON AMMESSO.ID = CONTESTO_ESAME.AMMESSO   \n                                                             /* ESAME_ALUNNO */\n                                         LEFT OUTER JOIN ESAME_ALUNNO  ON ESAME_ALUNNO.ALUNNO = ALUNNO.ID\n                                         LEFT OUTER JOIN VOTO_ESAME AS VOTO_INVALSI ON VOTO_INVALSI.ID = ESAME_ALUNNO.VOTO_INVALSI\n                                             /* PUNTEGGI PROVE */\n                                         LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_ITA on ESITO_PROVA_ITA.ALUNNO = ALUNNO.ID  \n                                         LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_MAT on ESITO_PROVA_MAT.ALUNNO = ALUNNO.ID  \n                                         LEFT OUTER JOIN STRUMENTO as PROVA_ITA ON PROVA_ITA.ID = ESITO_PROVA_ITA.STRUMENTO \n                                         LEFT OUTER JOIN STRUMENTO as PROVA_MAT ON PROVA_MAT.ID = ESITO_PROVA_MAT.STRUMENTO \n                                         left outer join TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_ITA on TEMPO_AGGIUNTIVO_ITA.ID  = ESITO_PROVA_ITA.TEMPO_AGGIUNTIVO\n                                         left outer join TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_MAT on TEMPO_AGGIUNTIVO_MAT.ID  = ESITO_PROVA_MAT.TEMPO_AGGIUNTIVO\n                                        LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_ITALIANO ON VOTO_PROVA_ESAME_ITALIANO.ID = ESAME_ALUNNO.VOTO_ESAME_ITALIANO\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_MATEMATICA ON VOTO_PROVA_ESAME_MATEMATICA.ID = ESAME_ALUNNO.VOTO_ESAME_MATEMATICA\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_LINGUA ON VOTO_PROVA_ESAME_LINGUA.ID = ESAME_ALUNNO.VOTO_ESAME_LINGUA\n                        \t\tWHERE ALUNNO.CLASSE= ? and  PROVA_ITA.MATERIA='ITA' and PROVA_MAT.MATERIA='MAT'\n                                         ORDER BY CONTESTO.ANNO,ALUNNO.SEQUENZIALE;") : conn.prepareStatement("              SELECT           ALUNNO.ID,\n            \t\t\tALUNNO.SEQUENZIALE,\n            \t\t\tALUNNO.SIDI,\n            \t\t\tCONTESTO.ANNO,\n            \t\t\tGIORNO_NASCITA.VALORE,\n            \t\t\tMESE_NASCITA.NOME,\n            \t\t\tCONTESTO.ANNO_NASCITA,\n            \t\t\tLUOGO_NASCITA.VALORE,\n            \t\t\tARRIVO_ITALIA.VALORE,\n            \t\t\tCONTESTO.NIDO,\n            \t\t\tCONTESTO.MATERNA,\n            \t\t\tCONTESTO.SESSO,\n            \t\t\tDISABILITA.VALORE,\n            \t\t\tSTATO.VALORE,\n            \t\t\tSCRITTO_ITALIANO.VALORE,\n            \t\t\tORALE_ITALIANO.VALORE,\n            \t\t\tSCRITTO_MATEMATICA.VALORE,\n            \t\t\tORALE_MATEMATICA.VALORE,\n            \t\t\tORE_ITALIANO.VALORE,\n            \t\t\tORE_MATEMATICA.VALORE,\n            \t\t\tGENITORE_01.SESSO,\n            \t\t\tNASCITA_GENITORE_1.VALORE,\n            \t\t\tISTRUZIONE_GENITORE_1.VALORE,\n            \t\t\tOCCUPAZIONE_GENITORE_1.VALORE,\n            \t\t\tGENITORE_02.SESSO,\n            \t\t\tNASCITA_GENITORE_2.VALORE,\n            \t\t\tISTRUZIONE_GENITORE_2.VALORE,\n            \t\t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                 ORE_SETTIMANALI.VALORE\n            \tFROM ALUNNO \n            \t\tLEFT OUTER JOIN CONTESTO ON CONTESTO.ALUNNO = ALUNNO.ID\n            \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n            \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n            \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n            \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n            \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n            \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n            \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n            \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n            \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n            \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n            \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n            \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n            \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n            \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                         LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID \n            \tWHERE ALUNNO.CLASSE= ?\n            \tORDER BY CONTESTO.ANNO,ALUNNO.SEQUENZIALE;");
                stat.setInt(1, classe.getId());
                stat.execute();
                result = stat.getResultSet();
                while (result.next()) {
                    int i = 1;
                    nextAlunno = classe.getLivello() == 8 ? new AlunnoEsaminato(result.getInt(i++), result.getInt(i++), result.getString(i++)) : new Alunno(result.getInt(i++), result.getInt(i++), result.getString(i++));
                    int n = ++i;
                    nextAlunno.setGiornoNascita(result.getString(n));
                    int n2 = ++i;
                    nextAlunno.setMeseNascita(result.getString(n2));
                    int n3 = ++i;
                    nextAlunno.setAnnoNascita(result.getString(n3));
                    int n4 = ++i;
                    nextAlunno.setLuogoNascita(result.getString(n4));
                    int n5 = ++i;
                    nextAlunno.setArrivoItalia(result.getString(n5));
                    int n6 = ++i;
                    nextAlunno.setNido(result.getString(n6));
                    int n7 = ++i;
                    nextAlunno.setMaterna(result.getString(n7));
                    int n8 = ++i;
                    nextAlunno.setSesso(result.getString(n8));
                    int n9 = ++i;
                    nextAlunno.setDisabilita(result.getString(n9));
                    int n10 = ++i;
                    nextAlunno.setStato(result.getString(n10));
                    int n11 = ++i;
                    nextAlunno.setVotoScrittoItaliano(result.getString(n11));
                    int n12 = ++i;
                    nextAlunno.setVotoOraleItaliano(result.getString(n12));
                    int n13 = ++i;
                    nextAlunno.setVotoScrittoMatematica(result.getString(n13));
                    int n14 = ++i;
                    nextAlunno.setVotoOraleMatematica(result.getString(n14));
                    int n15 = ++i;
                    nextAlunno.setOreItaliano(result.getString(n15));
                    int n16 = ++i;
                    nextAlunno.setOreMatematica(result.getString(n16));
                    LinkedList<Genitore> genitori = new LinkedList<Genitore>();
                    int n17 = ++i;
                    int n18 = ++i;
                    int n19 = ++i;
                    int n20 = ++i;
                    Genitore genitore = new Genitore(result.getString(n17), result.getString(n18), result.getString(n19), result.getString(n20));
                    genitori.add(genitore);
                    int n21 = ++i;
                    int n22 = ++i;
                    int n23 = ++i;
                    int n24 = ++i;
                    genitore = new Genitore(result.getString(n21), result.getString(n22), result.getString(n23), result.getString(n24));
                    genitori.add(genitore);
                    nextAlunno.setGenitori(genitori);
                    int n25 = ++i;
                    ++i;
                    nextAlunno.setOreLerzione(result.getString(n25));
                    if (classe.getLivello() == 8) {
                        ((AlunnoEsaminato)nextAlunno).setCognome(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setNome(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setTipoCandidato(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setAmmesso(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setVotoAmmissione(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setVotoInvalsi(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setPunteggioItaliano(result.getInt(i++));
                        ((AlunnoEsaminato)nextAlunno).setPunteggioMatematica(result.getInt(i++));
                        ((AlunnoEsaminato)nextAlunno).setTempoAggiuntivoItaliano(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setTempoAggiuntivoMatematica(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setVotoProvaEsameItaliano(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setVotoProvaEsameMatematica(result.getString(i++));
                        ((AlunnoEsaminato)nextAlunno).setVotoProvaEsameLingua(result.getString(i++));
                    }
                    alunni.add(nextAlunno);
                }
            }
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        return alunni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void creaAlunniDellaClasse(int classeId, int livello) throws AlunnoDaoException {
        PreparedStatement stat_numeroAlunni = null;
        PreparedStatement stat_alunno = null;
        PreparedStatement stat_contesto = null;
        CallableStatement stat_contesto_esame = null;
        CallableStatement stat_voto_esame = null;
        CallableStatement stat_esito_prova_ita = null;
        CallableStatement stat_esito_prova_mat = null;
        Connection conn = null;
        ResultSet result = null;
        try {
            conn = this.connMgr.getConnection();
            conn.setAutoCommit(false);
            stat_numeroAlunni = conn.prepareStatement("SELECT IFNULL(N_ALUNNI,0) FROM CLASSE WHERE CLASSE.ID = ?;");
            stat_alunno = conn.prepareStatement("INSERT INTO ALUNNO (CLASSE, SEQUENZIALE) VALUES (?, ?);");
            stat_contesto = conn.prepareStatement("insert into contesto(ALUNNO) values (SELECT ALUNNO.ID FROM ALUNNO WHERE ALUNNO.CLASSE=? AND ALUNNO.SEQUENZIALE=?);");
            stat_contesto_esame = conn.prepareCall("insert into CONTESTO_ESAME (ALUNNO) VALUES (SELECT ALUNNO.ID FROM ALUNNO WHERE ALUNNO.CLASSE=? AND ALUNNO.SEQUENZIALE=?);");
            stat_esito_prova_ita = conn.prepareCall("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?,select STRUMENTO.ID from STRUMENTO where STRUMENTO.MATERIA='ITA' and STRUMENTO.LIVELLO=8);");
            stat_esito_prova_mat = conn.prepareCall("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?,select STRUMENTO.ID from STRUMENTO where STRUMENTO.MATERIA='MAT' and STRUMENTO.LIVELLO=8);");
            stat_voto_esame = conn.prepareCall("insert into ESAME_ALUNNO (ALUNNO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?);");
            stat_numeroAlunni.setInt(1, classeId);
            stat_numeroAlunni.execute();
            int numeroAlunni = 0;
            result = stat_numeroAlunni.getResultSet();
            result.next();
            numeroAlunni = result.getInt(1);
            if (numeroAlunni == 0) {
                ++numeroAlunni;
            }
            for (int i = 0; i < numeroAlunni; ++i) {
                stat_alunno.setInt(1, classeId);
                stat_alunno.setInt(2, i + 1);
                stat_alunno.execute();
                stat_contesto.setInt(1, classeId);
                stat_contesto.setInt(2, i + 1);
                stat_contesto.execute();
                if (livello != 8) continue;
                stat_contesto_esame.setInt(1, classeId);
                stat_contesto_esame.setInt(2, i + 1);
                stat_contesto_esame.execute();
                stat_esito_prova_ita.setInt(1, classeId);
                stat_esito_prova_ita.setInt(2, i + 1);
                stat_esito_prova_ita.execute();
                stat_esito_prova_mat.setInt(1, classeId);
                stat_esito_prova_mat.setInt(2, i + 1);
                stat_esito_prova_mat.execute();
                stat_voto_esame.setInt(1, classeId);
                stat_voto_esame.setInt(2, i + 1);
                stat_voto_esame.execute();
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            this.connMgr.rollBack(conn);
            try {
                conn.setAutoCommit(true);
            }
            catch (Exception ec) {
                Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ec);
            }
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
    }

    @Override
    public Map<Integer, String> getOpzioniContestoPossibili(String infromazioniDesiderate) throws AlunnoDaoException {
        HashMap<Integer, String> resultingMap;
        block53: {
            resultingMap = new HashMap<Integer, String>();
            Connection conn = null;
            Statement stat = null;
            ResultSet result = null;
            try {
                conn = this.connMgr.getConnection();
                stat = conn.createStatement();
                if (infromazioniDesiderate.equals("LUOGHO_NASCITA")) {
                    stat.execute("SELECT ID, VALORE FROM LUOGO_NASCITA ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("MSSE_NASCITA")) {
                    stat.execute("SELECT ID, NOME FROM MESE_NASCITA ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("GIORNO_NASCITA")) {
                    stat.execute("SELECT ID, VALORE FROM GIORNO_NASCITA ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ARRIVO_ITALIA_2")) {
                    stat.execute("SELECT ID, VALORE FROM ARRIVO_ITALIA where LIVELLO in (0,2) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ARRIVO_ITALIA_5")) {
                    stat.execute("SELECT ID, VALORE FROM ARRIVO_ITALIA where LIVELLO in (0,5) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ARRIVO_ITALIA_6")) {
                    stat.execute("SELECT ID, VALORE FROM ARRIVO_ITALIA where LIVELLO in (0,6) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ARRIVO_ITALIA_8")) {
                    stat.execute("SELECT ID, VALORE FROM ARRIVO_ITALIA where LIVELLO in (0,8) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ARRIVO_ITALIA_10")) {
                    stat.execute("SELECT ID, VALORE FROM ARRIVO_ITALIA where LIVELLO in (0,10) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ORE_LEZIONE_2")) {
                    stat.execute("SELECT ID, VALORE FROM ORE_SETTIMANALI where LIVELLO in (0,2) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ORE_LEZIONE_5")) {
                    stat.execute("SELECT ID, VALORE FROM ORE_SETTIMANALI where LIVELLO in (0,5) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ORE_LEZIONE_6")) {
                    stat.execute("SELECT ID, VALORE FROM ORE_SETTIMANALI where LIVELLO in (0,6) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ORE_LEZIONE_8")) {
                    stat.execute("SELECT ID, VALORE FROM ORE_SETTIMANALI where LIVELLO in (0,8) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ORE_LEZIONE_10")) {
                    stat.execute("SELECT ID, VALORE FROM ORE_SETTIMANALI where LIVELLO in (0,10) ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ORE_MATERIA")) {
                    stat.execute("SELECT ID, VALORE FROM ORE_MATERIA ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("VOTI")) {
                    stat.execute("SELECT ID,VALORE FROM VOTO  WHERE ID >-1 ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("ISTRUZIONE")) {
                    stat.execute("SELECT ID,VALORE FROM ISTRUZIONE ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("OCCUPAZIONE")) {
                    stat.execute("SELECT ID, VALORE FROM OCCUPAZIONE ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("STATI_ALUNNO")) {
                    stat.execute("SELECT ID, VALORE FROM STATO_ALUNNO ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("DISABILITA")) {
                    stat.execute("SELECT ID, VALORE FROM DISABILITA ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("TIPI_CANDIDATO_ESAME")) {
                    stat.execute("SELECT ID, VALORE FROM TIPO_CANDIDATO where id >0 ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("VOTI_AMMISSIONE")) {
                    stat.execute("SELECT ID, VALORE FROM VOTO_AMMISSIONE where ID > -1 ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("VOTI_ESAME")) {
                    stat.execute("SELECT ID, VALORE FROM VOTO_ESAME ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("AMMESSO")) {
                    stat.execute("SELECT ID, VALORE FROM AMMESSO WHERE ID >=0 ORDER BY ID;");
                } else if (infromazioniDesiderate.equals("TEMPI_AGGIUNTIVI")) {
                    stat.execute("SELECT ID, VALORE FROM TEMPO_AGGIUNTIVO ORDER BY ID;");
                } else {
                    throw new AlunnoDaoException("Campo richiesto non presente.");
                }
                result = stat.getResultSet();
                if (result != null) {
                    while (result.next()) {
                        int key = result.getInt(1);
                        String value = result.getString(2);
                        resultingMap.put(new Integer(key), value);
                    }
                    break block53;
                }
                throw new AlunnoDaoException("Campo richiesto non presente.");
            }
            catch (SQLException e) {
                Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
                throw new AlunnoDaoException("Errore nel recuperare leopzioni dicintesto richieste");
            }
            catch (ConnectionException ex) {
                Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
                throw new AlunnoDaoException(ex.getMessage());
            }
        }
        return resultingMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void salvaAlunniDellaClasse(Classe classe, List<Alunno> alunni) throws AlunnoDaoException {
        PreparedStatement stat_alunno = null;
        PreparedStatement stat_alunno_sidi = null;
        PreparedStatement stat_contesto = null;
        PreparedStatement stat_contesto_esame = null;
        PreparedStatement stat_select_genitore = null;
        PreparedStatement stat_create_genitore = null;
        PreparedStatement stat_voto_esame = null;
        CallableStatement stat_esito_prova_ita = null;
        CallableStatement stat_esito_prova_mat = null;
        ResultSet result = null;
        Connection conn = null;
        int idGenitore_1 = 0;
        int idGenitore_2 = 0;
        String nascitaGenitore_1 = null;
        String occupazioneGenitore_1 = null;
        String istruzioneGenitore_1 = null;
        String sessoGenitore_1 = null;
        try {
            conn = this.connMgr.getConnection();
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(8);
            stat_alunno = conn.prepareStatement("INSERT INTO ALUNNO (CLASSE, SEQUENZIALE) VALUES (?, ?);");
            stat_alunno_sidi = conn.prepareStatement("INSERT INTO ALUNNO (CLASSE, SEQUENZIALE, SIDI) VALUES (?,?,?);");
            stat_contesto = conn.prepareStatement("insert into CONTESTO \n\t\t\t(\n\t\t\t\tALUNNO, \n\t\t\t\tANNO_NASCITA, \n\t\t\t\tMESE_NASCITA, \n\t\t\t\tGIORNO_NASCITA, \n\t\t\t\tLUOGO_NASCITA, \n\t\t\t\tARRIVO_ITALIA, \n\t\t\t\tNIDO, \n                         MATERNA, \n                         SESSO, \n\t\t\t\tDISABILITA,\n\t\t\t\tSTATO, \n\t\t\t\tSCRITTO_ITA, \n\t\t\t\tORALE_ITA, \n\t\t\t\tSCRITTO_MAT, \n\t\t\t\tORALE_MAT,\n\t\t\t\tORE_ITA,\n\t\t\t\tORE_MAT,\n\t\t\t\tGENITORE_1, \n                         GENITORE_2, \n                         ORE_SETTIMANALI \n\t\t\t)\n\tvalues \n\t(\n\t\t(SELECT ALUNNO.ID FROM ALUNNO WHERE ALUNNO.CLASSE=? AND ALUNNO.SEQUENZIALE=? ),\n\t\t?,\n\t\t(select ID from MESE_NASCITA where MESE_NASCITA.NOME=?),\n\t\t(select ID from GIORNO_NASCITA where GIORNO_NASCITA.VALORE=?),\n\t\t(select ID from LUOGO_NASCITA where LUOGO_NASCITA.VALORE=?),\n\t\t(select ID from ARRIVO_ITALIA where ARRIVO_ITALIA.VALORE=? and ARRIVO_ITALIA.LIVELLO in (?,0)),\n\t\t?,?,?,\n\t\t(select ID from DISABILITA where DISABILITA.VALORE=?),\n\t\t(select ID from STATO_ALUNNO where STATO_ALUNNO.VALORE=?),\n\t\t(select ID from VOTO where VOTO.VALORE=?),\n\t\t(select ID from VOTO where VOTO.VALORE=?),\n\t\t(select ID from VOTO where VOTO.VALORE=?),\n\t\t(select ID from VOTO where VOTO.VALORE=?),\n\t\t(select ID from ORE_MATERIA where ORE_MATERIA.VALORE=?),\n\t\t(select ID from ORE_MATERIA where ORE_MATERIA.VALORE=?),\n\t\t?,?,\n         (select ID from ORE_SETTIMANALI where ORE_SETTIMANALI.VALORE=? and ORE_SETTIMANALI.LIVELLO in (?,0))\n\t);");
            stat_select_genitore = conn.prepareStatement("select TOP(1) ID from GENITORE \nwhere SESSO=?\nand LUOGO_NASCITA=(SELECT ID FROM LUOGO_NASCITA where LUOGO_NASCITA.VALORE=?) \nand ISTRUZIONE=(SELECT ID FROM ISTRUZIONE where ISTRUZIONE.VALORE=?) \nand OCCUPAZIONE=(SELECT ID FROM OCCUPAZIONE WHERE OCCUPAZIONE.VALORE=?)\norder by ID ;");
            stat_create_genitore = conn.prepareStatement("insert into GENITORE (SESSO, LUOGO_NASCITA, ISTRUZIONE, OCCUPAZIONE)\n\tvalues \n\t(\n\t\t?,\n\t\t(SELECT ID from LUOGO_NASCITA where LUOGO_NASCITA.VALORE=?),\n\t\t(SELECT ID from ISTRUZIONE where ISTRUZIONE.VALORE=?),\n\t\t(SELECT ID from OCCUPAZIONE where OCCUPAZIONE.VALORE=?)\t\n\t);");
            stat_esito_prova_ita = conn.prepareCall("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?,select STRUMENTO.ID from STRUMENTO where STRUMENTO.MATERIA='ITA' and STRUMENTO.LIVELLO=8);");
            stat_esito_prova_mat = conn.prepareCall("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?,select STRUMENTO.ID from STRUMENTO where STRUMENTO.MATERIA='MAT' and STRUMENTO.LIVELLO=8);");
            for (Alunno alunno : alunni) {
                int sequeiziale = alunno.getSequenziale();
                String sidi = alunno.getSidi();
                String sesso = alunno.getSesso();
                String nido = alunno.getNido();
                String materna = alunno.getMaterna();
                String arrivo = alunno.getArrivoItalia();
                String meseNascita = alunno.getMeseNascita();
                String giornoNascita = alunno.getGiornoNascita();
                String annoNascita = alunno.getAnnoNascita();
                String luogoNascita = alunno.getLuogoNascita();
                String disabilita = alunno.getDisabilita();
                String stato = alunno.getStato();
                String oraleItaliano = alunno.getVotoOraleItaliano();
                String oraleMatematica = alunno.getVotoOraleMatematica();
                String scrittoItaliano = alunno.getVotoScrittoItaliano();
                String scrittoMatematica = alunno.getVotoScrittoMatematica();
                String oreItaliano = alunno.getOreItaliano();
                String oreMatematica = alunno.getOreMatematica();
                if (alunno.getGenitori() != null && !alunno.getGenitori().isEmpty()) {
                    sessoGenitore_1 = alunno.getGenitori().get(0).getSesso();
                    nascitaGenitore_1 = alunno.getGenitori().get(0).getLuogoDiNascita();
                    istruzioneGenitore_1 = alunno.getGenitori().get(0).getLivelloIstruzione();
                    occupazioneGenitore_1 = alunno.getGenitori().get(0).getOccupazione();
                    stat_select_genitore.setString(1, sessoGenitore_1);
                    stat_select_genitore.setString(2, nascitaGenitore_1);
                    stat_select_genitore.setString(3, istruzioneGenitore_1);
                    stat_select_genitore.setString(4, occupazioneGenitore_1);
                    stat_select_genitore.execute();
                    result = stat_select_genitore.getResultSet();
                    if (result.next()) {
                        idGenitore_1 = result.getInt("ID");
                    } else {
                        stat_create_genitore.setString(1, sessoGenitore_1);
                        stat_create_genitore.setString(2, nascitaGenitore_1);
                        stat_create_genitore.setString(3, istruzioneGenitore_1);
                        stat_create_genitore.setString(4, occupazioneGenitore_1);
                        stat_create_genitore.execute();
                        stat_select_genitore.execute();
                        result = stat_select_genitore.getResultSet();
                        if (result.next()) {
                            idGenitore_1 = result.getInt("ID");
                        }
                    }
                    if (alunno.getGenitori().size() > 1) {
                        String sessoGenitore_2 = alunno.getGenitori().get(1).getSesso();
                        String nascitaGenitore_2 = alunno.getGenitori().get(1).getLuogoDiNascita();
                        String istruzioneGenitore_2 = alunno.getGenitori().get(1).getLivelloIstruzione();
                        String occupazioneGenitore_2 = alunno.getGenitori().get(1).getOccupazione();
                        stat_select_genitore.setString(1, sessoGenitore_2);
                        stat_select_genitore.setString(2, nascitaGenitore_2);
                        stat_select_genitore.setString(3, istruzioneGenitore_2);
                        stat_select_genitore.setString(4, occupazioneGenitore_2);
                        stat_select_genitore.execute();
                        result = stat_select_genitore.getResultSet();
                        if (result.next()) {
                            idGenitore_2 = result.getInt("ID");
                        } else {
                            stat_create_genitore.setString(1, sessoGenitore_2);
                            stat_create_genitore.setString(2, nascitaGenitore_2);
                            stat_create_genitore.setString(3, istruzioneGenitore_2);
                            stat_create_genitore.setString(4, occupazioneGenitore_2);
                            stat_create_genitore.execute();
                            stat_select_genitore.execute();
                            result = stat_select_genitore.getResultSet();
                            if (result.next()) {
                                idGenitore_2 = result.getInt("ID");
                            }
                        }
                    } else {
                        idGenitore_2 = idGenitore_1 == 1 ? 2 : (idGenitore_1 == 2 ? 1 : (sessoGenitore_1.equals("M") ? 2 : 1));
                    }
                }
                String oreLezione = alunno.getOreLezione();
                if (sidi == null) {
                    stat_alunno.setInt(1, classe.getId());
                    stat_alunno.setInt(2, sequeiziale);
                    stat_alunno.execute();
                } else {
                    stat_alunno_sidi.setInt(1, classe.getId());
                    stat_alunno_sidi.setInt(2, sequeiziale);
                    stat_alunno_sidi.setString(3, sidi);
                    stat_alunno_sidi.execute();
                }
                int i = 1;
                stat_contesto.setInt(i++, classe.getId());
                stat_contesto.setInt(i++, sequeiziale);
                stat_contesto.setString(i++, annoNascita);
                stat_contesto.setString(i++, meseNascita);
                stat_contesto.setString(i++, giornoNascita);
                stat_contesto.setString(i++, luogoNascita);
                stat_contesto.setString(i++, arrivo);
                stat_contesto.setInt(i++, classe.getLivello());
                stat_contesto.setString(i++, nido);
                stat_contesto.setString(i++, materna);
                stat_contesto.setString(i++, sesso);
                stat_contesto.setString(i++, disabilita);
                stat_contesto.setString(i++, stato);
                stat_contesto.setString(i++, scrittoItaliano);
                stat_contesto.setString(i++, oraleItaliano);
                stat_contesto.setString(i++, scrittoMatematica);
                stat_contesto.setString(i++, oraleMatematica);
                stat_contesto.setString(i++, oreItaliano);
                stat_contesto.setString(i++, oreMatematica);
                stat_contesto.setInt(i++, idGenitore_1);
                stat_contesto.setInt(i++, idGenitore_2);
                stat_contesto.setString(i++, oreLezione);
                stat_contesto.setInt(i++, classe.getLivello());
                stat_contesto.execute();
                if (classe.getLivello() == 8) {
                    stat_contesto_esame = conn.prepareStatement("insert into CONTESTO_ESAME (ALUNNO) VALUES (SELECT ALUNNO.ID FROM ALUNNO WHERE ALUNNO.CLASSE=? AND ALUNNO.SEQUENZIALE=?);");
                    stat_voto_esame = conn.prepareStatement("insert into ESAME_ALUNNO (ALUNNO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?);");
                    stat_contesto_esame.setInt(1, classe.getId());
                    stat_contesto_esame.setInt(2, sequeiziale);
                    stat_voto_esame.setInt(1, classe.getId());
                    stat_voto_esame.setInt(2, sequeiziale);
                    stat_contesto_esame.execute();
                    stat_voto_esame.execute();
                    stat_esito_prova_ita.setInt(1, classe.getId());
                    stat_esito_prova_ita.setInt(2, sequeiziale);
                    try {
                        stat_esito_prova_ita.execute();
                    }
                    catch (SQLException ep) {
                        this.connMgr.rollBack(conn);
                        conn.setAutoCommit(true);
                        conn.setTransactionIsolation(2);
                        Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ep);
                        throw new AlunnoDaoException("Non si pu\u00f2 continuare, non sono presenti strumenti per il livello selezionato");
                    }
                    stat_esito_prova_mat.setInt(1, classe.getId());
                    stat_esito_prova_mat.setInt(2, sequeiziale);
                    stat_esito_prova_mat.execute();
                }
                int numeroDialunni = alunni.size();
                PreparedStatement stat_numeroALunni = null;
                stat_numeroALunni = conn.prepareStatement("update CLASSE SET CLASSE.N_ALUNNI = ? where CLASSE.ID= ? ");
                stat_numeroALunni.setInt(1, numeroDialunni);
                stat_numeroALunni.setInt(2, classe.getId());
                stat_numeroALunni.execute();
            }
            conn.commit();
            conn.setAutoCommit(true);
            conn.setTransactionIsolation(2);
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            this.connMgr.rollBack(conn);
            try {
                conn.setAutoCommit(true);
                conn.setTransactionIsolation(2);
            }
            catch (Exception ec) {
                Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ec);
            }
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
    }

    @Override
    public void updateContestoAlunno(int idAlunno, String scrittoItaliano, String oraleItaliano, String scrittoMatematica, String oraleMatematica, String disabilita, String statoAlunno) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat_contesto = null;
        try {
            conn = this.connMgr.getConnection();
            stat_contesto = conn.prepareStatement("       update CONTESTO set \n\t\t\tCONTESTO.SCRITTO_ITA = (select ID from VOTO where VALORE = ?),\n\t\t\tCONTESTO.ORALE_ITA = (select ID from VOTO where VALORE = ?),\n\t\t\tCONTESTO.SCRITTO_MAT = (select ID from VOTO where VALORE = ?),\n\t\t\tCONTESTO.ORALE_MAT = (select ID from VOTO where VALORE = ?),\n\t\t\tCONTESTO.DISABILITA = (select ID from DISABILITA where VALORE = ?),\n\t\t\tCONTESTO.STATO = (select ID from STATO_ALUNNO where VALORE = ?)\n           where CONTESTO.ALUNNO=?;");
            stat_contesto.setString(1, scrittoItaliano);
            stat_contesto.setString(2, oraleItaliano);
            stat_contesto.setString(3, scrittoMatematica);
            stat_contesto.setString(4, oraleMatematica);
            stat_contesto.setString(5, disabilita);
            stat_contesto.setString(6, statoAlunno);
            stat_contesto.setInt(7, idAlunno);
            stat_contesto.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nell'aggiornare i dei dati di contesto nel DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
    }

    @Override
    public List<AlunnoValutato> getAlunniValutatiByClasse(Classe classe) throws AlunnoDaoException {
        LinkedList<AlunnoValutato> alunni = new LinkedList<AlunnoValutato>();
        AlunnoValutato nextAlunno = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        int idClasse = classe.getId();
        int livello = classe.getLivello();
        try {
            conn = this.connMgr.getConnection();
            stat = classe.getLivello() != 8 ? conn.prepareStatement("              SELECT           ALUNNO.ID,\n            \t\t\tALUNNO.SEQUENZIALE,\n            \t\t\tALUNNO.SIDI,\n            \t\t\tCONTESTO.ANNO,\n            \t\t\tGIORNO_NASCITA.VALORE,\n            \t\t\tMESE_NASCITA.NOME,\n            \t\t\tCONTESTO.ANNO_NASCITA,\n            \t\t\tLUOGO_NASCITA.VALORE,\n            \t\t\tARRIVO_ITALIA.VALORE,\n            \t\t\tCONTESTO.NIDO,\n            \t\t\tCONTESTO.MATERNA,\n            \t\t\tCONTESTO.SESSO,\n            \t\t\tDISABILITA.VALORE,\n            \t\t\tSTATO.VALORE,\n            \t\t\tSCRITTO_ITALIANO.VALORE,\n            \t\t\tORALE_ITALIANO.VALORE,\n            \t\t\tSCRITTO_MATEMATICA.VALORE,\n            \t\t\tORALE_MATEMATICA.VALORE,\n            \t\t\tORE_ITALIANO.VALORE,\n            \t\t\tORE_MATEMATICA.VALORE,\n            \t\t\tGENITORE_01.SESSO,\n            \t\t\tNASCITA_GENITORE_1.VALORE,\n            \t\t\tISTRUZIONE_GENITORE_1.VALORE,\n            \t\t\tOCCUPAZIONE_GENITORE_1.VALORE,\n            \t\t\tGENITORE_02.SESSO,\n            \t\t\tNASCITA_GENITORE_2.VALORE,\n            \t\t\tISTRUZIONE_GENITORE_2.VALORE,\n            \t\t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                 ORE_SETTIMANALI.VALORE\n            \tFROM ALUNNO \n            \t\tLEFT OUTER JOIN CONTESTO ON CONTESTO.ALUNNO = ALUNNO.ID\n            \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n            \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n            \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n            \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n            \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n            \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n            \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n            \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n            \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n            \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n            \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n            \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n            \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n            \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                         LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID \n            \tWHERE ALUNNO.CLASSE= ?\n            \tORDER BY CONTESTO.ANNO,ALUNNO.SEQUENZIALE;") : conn.prepareStatement("SELECT  ALUNNO.ID,\n                                                 ALUNNO.SEQUENZIALE,\n                                                 ALUNNO.SIDI,\n                                    \t\t/* CONTESTO */\n                                    \t\tCONTESTO.ANNO,\n                                    \t\tGIORNO_NASCITA.VALORE,\n                                    \t\tMESE_NASCITA.NOME,\n                                    \t\tCONTESTO.ANNO_NASCITA,\n                                    \t\tLUOGO_NASCITA.VALORE,\n                                    \t\tARRIVO_ITALIA.VALORE,\n                                    \t\tCONTESTO.NIDO,\n                                    \t\tCONTESTO.MATERNA,\n                                    \t\tCONTESTO.SESSO,\n                                    \t\tDISABILITA.VALORE,\n                                    \t\tSTATO.VALORE,\n                                    \t\tSCRITTO_ITALIANO.VALORE,\n                                    \t\tORALE_ITALIANO.VALORE,\n                                    \t\tSCRITTO_MATEMATICA.VALORE,\n                                    \t\tORALE_MATEMATICA.VALORE,\n                                    \t\tORE_ITALIANO.VALORE,\n                                    \t\tORE_MATEMATICA.VALORE,\n                                    \t\tGENITORE_01.SESSO,\n                                    \t\tNASCITA_GENITORE_1.VALORE,\n                                    \t\tISTRUZIONE_GENITORE_1.VALORE,\n                                    \t\tOCCUPAZIONE_GENITORE_1.VALORE,\n                                    \t\tGENITORE_02.SESSO,\n                                    \t\tNASCITA_GENITORE_2.VALORE,\n                                    \t\tISTRUZIONE_GENITORE_2.VALORE,\n                                    \t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                                   ORE_SETTIMANALI.VALORE,\n                                                   /* CONTESTO_ESAME */\n                                                   CONTESTO_ESAME.COGNOME,\n                                                   CONTESTO_ESAME.NOME,\n                                                   TIPO_CANDIDATO.VALORE,\n                                                   AMMESSO.VALORE,\n                                                   VOTO_AMMISSIONE.VALORE,\n                                                   /* ESAME */\n                                                 VOTO_INVALSI.VALORE,\n                                                 /* PUNTEGGI PROVE */\n                                                ESITO_PROVA_ITA.VALORE,\n                                                ESITO_PROVA_MAT.VALORE,\n                                                TEMPO_AGGIUNTIVO_ITA.VALORE,\n                                                TEMPO_AGGIUNTIVO_MAT.VALORE,\n                                                VOTO_PROVA_ESAME_ITALIANO.VALORE,\n                                                VOTO_PROVA_ESAME_MATEMATICA.VALORE,\n                                                VOTO_PROVA_ESAME_LINGUA.VALORE\n                                    \tFROM ALUNNO \n                                    \t\t/* CONTESTO */\n                                    \t\tLEFT OUTER JOIN CONTESTO ON ALUNNO.ID = CONTESTO.ALUNNO\n                                    \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n                                    \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n                                    \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n                                    \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n                                    \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n                                    \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n                                    \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n                                    \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                                                 LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID\n                                          /* CONTESTO_ESAME*/\n                                          LEFT OUTER JOIN CONTESTO_ESAME ON CONTESTO_ESAME.ALUNNO = ALUNNO.ID\n                                          LEFT OUTER JOIN TIPO_CANDIDATO ON TIPO_CANDIDATO.ID = CONTESTO_ESAME.TIPO_CANDIDATO\n                                          LEFT OUTER JOIN VOTO_AMMISSIONE  ON VOTO_AMMISSIONE.ID = CONTESTO_ESAME.VOTO_AMMISSIONE   \n                                          LEFT OUTER JOIN AMMESSO  ON AMMESSO.ID = CONTESTO_ESAME.AMMESSO   \n                                                             /* ESAME_ALUNNO */\n                                         LEFT OUTER JOIN ESAME_ALUNNO  ON ESAME_ALUNNO.ALUNNO = ALUNNO.ID\n                                         LEFT OUTER JOIN VOTO_ESAME AS VOTO_INVALSI ON VOTO_INVALSI.ID = ESAME_ALUNNO.VOTO_INVALSI\n                                             /* PUNTEGGI PROVE */\n                                         LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_ITA on ESITO_PROVA_ITA.ALUNNO = ALUNNO.ID  \n                                         LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_MAT on ESITO_PROVA_MAT.ALUNNO = ALUNNO.ID  \n                                         LEFT OUTER JOIN STRUMENTO as PROVA_ITA ON PROVA_ITA.ID = ESITO_PROVA_ITA.STRUMENTO \n                                         LEFT OUTER JOIN STRUMENTO as PROVA_MAT ON PROVA_MAT.ID = ESITO_PROVA_MAT.STRUMENTO \n                                         left outer join TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_ITA on TEMPO_AGGIUNTIVO_ITA.ID  = ESITO_PROVA_ITA.TEMPO_AGGIUNTIVO\n                                         left outer join TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_MAT on TEMPO_AGGIUNTIVO_MAT.ID  = ESITO_PROVA_MAT.TEMPO_AGGIUNTIVO\n                                        LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_ITALIANO ON VOTO_PROVA_ESAME_ITALIANO.ID = ESAME_ALUNNO.VOTO_ESAME_ITALIANO\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_MATEMATICA ON VOTO_PROVA_ESAME_MATEMATICA.ID = ESAME_ALUNNO.VOTO_ESAME_MATEMATICA\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_LINGUA ON VOTO_PROVA_ESAME_LINGUA.ID = ESAME_ALUNNO.VOTO_ESAME_LINGUA\n                        \t\tWHERE ALUNNO.CLASSE= ? and  PROVA_ITA.MATERIA='ITA' and PROVA_MAT.MATERIA='MAT'\n                                         ORDER BY CONTESTO.ANNO,ALUNNO.SEQUENZIALE;");
            stat.setInt(1, idClasse);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                int i = 1;
                nextAlunno = livello == 8 ? new AlunnoEsaminato(result.getInt(i++), result.getInt(i++), result.getString(i++)) : new AlunnoValutato(result.getInt(i++), result.getInt(i++), result.getString(i++));
                int n = ++i;
                nextAlunno.setGiornoNascita(result.getString(n));
                int n2 = ++i;
                nextAlunno.setMeseNascita(result.getString(n2));
                int n3 = ++i;
                nextAlunno.setAnnoNascita(result.getString(n3));
                int n4 = ++i;
                nextAlunno.setLuogoNascita(result.getString(n4));
                int n5 = ++i;
                nextAlunno.setArrivoItalia(result.getString(n5));
                int n6 = ++i;
                nextAlunno.setNido(result.getString(n6));
                int n7 = ++i;
                nextAlunno.setMaterna(result.getString(n7));
                int n8 = ++i;
                nextAlunno.setSesso(result.getString(n8));
                int n9 = ++i;
                nextAlunno.setDisabilita(result.getString(n9));
                int n10 = ++i;
                nextAlunno.setStato(result.getString(n10));
                int n11 = ++i;
                nextAlunno.setVotoScrittoItaliano(result.getString(n11));
                int n12 = ++i;
                nextAlunno.setVotoOraleItaliano(result.getString(n12));
                int n13 = ++i;
                nextAlunno.setVotoScrittoMatematica(result.getString(n13));
                int n14 = ++i;
                nextAlunno.setVotoOraleMatematica(result.getString(n14));
                int n15 = ++i;
                nextAlunno.setOreItaliano(result.getString(n15));
                int n16 = ++i;
                nextAlunno.setOreMatematica(result.getString(n16));
                LinkedList<Genitore> genitori = new LinkedList<Genitore>();
                int n17 = ++i;
                int n18 = ++i;
                int n19 = ++i;
                int n20 = ++i;
                Genitore genitore = new Genitore(result.getString(n17), result.getString(n18), result.getString(n19), result.getString(n20));
                genitori.add(genitore);
                int n21 = ++i;
                int n22 = ++i;
                int n23 = ++i;
                int n24 = ++i;
                genitore = new Genitore(result.getString(n21), result.getString(n22), result.getString(n23), result.getString(n24));
                genitori.add(genitore);
                nextAlunno.setGenitori(genitori);
                int n25 = ++i;
                ++i;
                nextAlunno.setOreLerzione(result.getString(n25));
                if (classe.getLivello() == 8) {
                    ((AlunnoEsaminato)nextAlunno).setCognome(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setNome(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setTipoCandidato(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setAmmesso(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setVotoAmmissione(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setVotoInvalsi(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setPunteggioItaliano(result.getInt(i++));
                    ((AlunnoEsaminato)nextAlunno).setPunteggioMatematica(result.getInt(i++));
                    ((AlunnoEsaminato)nextAlunno).setTempoAggiuntivoItaliano(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setTempoAggiuntivoMatematica(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setVotoProvaEsameItaliano(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setVotoProvaEsameMatematica(result.getString(i++));
                    ((AlunnoEsaminato)nextAlunno).setVotoProvaEsameLingua(result.getString(i++));
                }
                alunni.add(nextAlunno);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        return alunni;
    }

    @Override
    public String getSvolgeProva(int idAlunno, String tipoStrumento, String materia) throws AlunnoDaoException {
        String svolgeProvaResult = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select VALORE \nfrom SVOLGE_PROVA\njoin STRUMENTO on SVOLGE_PROVA.STRUMENTO = STRUMENTO.ID\njoin MATERIA on STRUMENTO.MATERIA = MATERIA.CODICE\nwhere SVOLGE_PROVA.ALUNNO=? AND STRUMENTO.TIPO=? AND MATERIA.NOME=? \n union\nselect VALORE \nfrom COMPILA_QUESTIONARIO\njoin STRUMENTO on COMPILA_QUESTIONARIO.STRUMENTO = STRUMENTO.ID\njoin MATERIA on STRUMENTO.MATERIA = MATERIA.CODICE\nwhere COMPILA_QUESTIONARIO.ALUNNO=? AND STRUMENTO.TIPO=? AND MATERIA.NOME=?\n; ");
            stat.setInt(1, idAlunno);
            stat.setString(2, tipoStrumento);
            stat.setString(3, materia);
            stat.setInt(4, idAlunno);
            stat.setString(5, tipoStrumento);
            stat.setString(6, materia);
            stat.execute();
            result = stat.getResultSet();
            if (result.next()) {
                svolgeProvaResult = result.getString("VALORE");
            }
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nell recuperare l'informazione DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        return svolgeProvaResult;
    }

    @Override
    public Alunno getAlunnoByIdClasseAndSequenziale(int idClasse, int sequenzialeAlunno) throws AlunnoDaoException {
        Alunno alunno = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("              SELECT           ALUNNO.ID,\n            \t\t\tALUNNO.SEQUENZIALE,\n            \t\t\tALUNNO.SIDI,\n            \t\t\tCONTESTO.ANNO,\n            \t\t\tGIORNO_NASCITA.VALORE,\n            \t\t\tMESE_NASCITA.NOME,\n            \t\t\tCONTESTO.ANNO_NASCITA,\n            \t\t\tLUOGO_NASCITA.VALORE,\n            \t\t\tARRIVO_ITALIA.VALORE,\n            \t\t\tCONTESTO.NIDO,\n            \t\t\tCONTESTO.MATERNA,\n            \t\t\tCONTESTO.SESSO,\n            \t\t\tDISABILITA.VALORE,\n            \t\t\tSTATO.VALORE,\n            \t\t\tSCRITTO_ITALIANO.VALORE,\n            \t\t\tORALE_ITALIANO.VALORE,\n            \t\t\tSCRITTO_MATEMATICA.VALORE,\n            \t\t\tORALE_MATEMATICA.VALORE,\n            \t\t\tORE_ITALIANO.VALORE,\n            \t\t\tORE_MATEMATICA.VALORE,\n            \t\t\tGENITORE_01.SESSO,\n            \t\t\tNASCITA_GENITORE_1.VALORE,\n            \t\t\tISTRUZIONE_GENITORE_1.VALORE,\n            \t\t\tOCCUPAZIONE_GENITORE_1.VALORE,\n            \t\t\tGENITORE_02.SESSO,\n            \t\t\tNASCITA_GENITORE_2.VALORE,\n            \t\t\tISTRUZIONE_GENITORE_2.VALORE,\n            \t\t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                  ORE_SETTIMANALI.VALORE\n            \tFROM ALUNNO \n            \t\tLEFT OUTER JOIN CONTESTO ON ALUNNO.ID = CONTESTO.ALUNNO\n            \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n                         LEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n            \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n            \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n            \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n            \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n            \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n            \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n            \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n            \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n            \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n            \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n            \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n            \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n            \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n            \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                       LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID \n            \tWHERE ALUNNO.CLASSE= ? and ALUNNO.SEQUENZIALE=?;");
            stat.setInt(1, idClasse);
            stat.setInt(2, sequenzialeAlunno);
            stat.execute();
            result = stat.getResultSet();
            int i = 1;
            if (result.next()) {
                alunno = new Alunno(result.getInt(i++), result.getInt(i++), result.getString(i++));
                int n = ++i;
                alunno.setGiornoNascita(result.getString(n));
                int n2 = ++i;
                alunno.setMeseNascita(result.getString(n2));
                int n3 = ++i;
                alunno.setAnnoNascita(result.getString(n3));
                int n4 = ++i;
                alunno.setLuogoNascita(result.getString(n4));
                int n5 = ++i;
                alunno.setArrivoItalia(result.getString(n5));
                int n6 = ++i;
                alunno.setNido(result.getString(n6));
                int n7 = ++i;
                alunno.setMaterna(result.getString(n7));
                int n8 = ++i;
                alunno.setSesso(result.getString(n8));
                int n9 = ++i;
                alunno.setDisabilita(result.getString(n9));
                int n10 = ++i;
                alunno.setStato(result.getString(n10));
                int n11 = ++i;
                alunno.setVotoScrittoItaliano(result.getString(n11));
                int n12 = ++i;
                alunno.setVotoOraleItaliano(result.getString(n12));
                int n13 = ++i;
                alunno.setVotoScrittoMatematica(result.getString(n13));
                int n14 = ++i;
                alunno.setVotoOraleMatematica(result.getString(n14));
                int n15 = ++i;
                alunno.setOreItaliano(result.getString(n15));
                int n16 = ++i;
                alunno.setOreMatematica(result.getString(n16));
                LinkedList<Genitore> genitori = new LinkedList<Genitore>();
                int n17 = ++i;
                int n18 = ++i;
                int n19 = ++i;
                int n20 = ++i;
                Genitore genitore = new Genitore(result.getString(n17), result.getString(n18), result.getString(n19), result.getString(n20));
                genitori.add(genitore);
                int n21 = ++i;
                int n22 = ++i;
                int n23 = ++i;
                int n24 = ++i;
                genitore = new Genitore(result.getString(n21), result.getString(n22), result.getString(n23), result.getString(n24));
                genitori.add(genitore);
                alunno.setGenitori(genitori);
                int n25 = ++i;
                ++i;
                alunno.setOreLerzione(result.getString(n25));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        return alunno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlunnoValutato aggiungiAlunnoAllaClasse(StoricoClasse classe) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat_aggiungi_alunno = null;
        PreparedStatement stat_contesto = null;
        PreparedStatement stat_get_sequenziale = null;
        PreparedStatement stat_get_alunno = null;
        PreparedStatement stat_contesto_esame = null;
        PreparedStatement stat_voto_esame = null;
        PreparedStatement stat_esito_prova_ita = null;
        PreparedStatement stat_esito_prova_mat = null;
        ResultSet result = null;
        AlunnoValutato alunno = null;
        AlunnoEsaminato esaminato = null;
        try {
            conn = this.connMgr.getConnection();
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(8);
            stat_aggiungi_alunno = conn.prepareStatement("INSERT INTO ALUNNO (CLASSE, SEQUENZIALE) VALUES (?, ?);");
            stat_contesto = conn.prepareStatement("insert into contesto(ALUNNO) values (SELECT ALUNNO.ID FROM ALUNNO WHERE ALUNNO.CLASSE=? AND ALUNNO.SEQUENZIALE=?);");
            stat_contesto_esame = conn.prepareStatement("insert into CONTESTO_ESAME (ALUNNO) VALUES (SELECT ALUNNO.ID FROM ALUNNO WHERE ALUNNO.CLASSE=? AND ALUNNO.SEQUENZIALE=?);");
            stat_get_sequenziale = conn.prepareStatement("SELECT MAX (ALUNNO.SEQUENZIALE) FROM ALUNNO WHERE ALUNNO.CLASSE=?;");
            stat_voto_esame = conn.prepareStatement("insert into ESAME_ALUNNO (ALUNNO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?);");
            stat_esito_prova_ita = conn.prepareStatement("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?,select STRUMENTO.ID from STRUMENTO where STRUMENTO.MATERIA='ITA' and STRUMENTO.LIVELLO=8);");
            stat_esito_prova_mat = conn.prepareStatement("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (select ALUNNO.ID from  ALUNNO where ALUNNO.CLASSE=? and ALUNNO.SEQUENZIALE= ?,select STRUMENTO.ID from STRUMENTO where STRUMENTO.MATERIA='MAT' and STRUMENTO.LIVELLO=8);");
            stat_get_sequenziale.setInt(1, classe.getId());
            stat_get_sequenziale.execute();
            result = stat_get_sequenziale.getResultSet();
            int sequenziale = 1;
            if (result.next()) {
                sequenziale += result.getInt(1);
            }
            stat_aggiungi_alunno.setInt(1, classe.getId());
            stat_aggiungi_alunno.setInt(2, sequenziale);
            stat_contesto.setInt(1, classe.getId());
            stat_contesto.setInt(2, sequenziale);
            if (classe.getLivello() == 8) {
                stat_contesto_esame.setInt(1, classe.getId());
                stat_contesto_esame.setInt(2, sequenziale);
                stat_voto_esame.setInt(1, classe.getId());
                stat_voto_esame.setInt(2, sequenziale);
                stat_esito_prova_ita.setInt(1, classe.getId());
                stat_esito_prova_ita.setInt(2, sequenziale);
                stat_esito_prova_mat.setInt(1, classe.getId());
                stat_esito_prova_mat.setInt(2, sequenziale);
                stat_get_alunno = conn.prepareStatement("SELECT     TOP(1)  ALUNNO.ID,\n                                                \t\t\tALUNNO.SEQUENZIALE,\n                                                \t\t\tALUNNO.SIDI,\n                                                \t\t\tCONTESTO.ANNO,\n                                                \t\t\tGIORNO_NASCITA.VALORE,\n                                                \t\t\tMESE_NASCITA.NOME,\n                                                \t\t\tCONTESTO.ANNO_NASCITA,\n                                                \t\t\tLUOGO_NASCITA.VALORE,\n                                                \t\t\tARRIVO_ITALIA.VALORE,\n                                                \t\t\tCONTESTO.NIDO,\n                                                \t\t\tCONTESTO.MATERNA,\n                                                \t\t\tCONTESTO.SESSO,\n                                                \t\t\tDISABILITA.VALORE,\n                                                \t\t\tSTATO.VALORE,\n                                                \t\t\tSCRITTO_ITALIANO.VALORE,\n                                                \t\t\tORALE_ITALIANO.VALORE,\n                                                \t\t\tSCRITTO_MATEMATICA.VALORE,\n                                                \t\t\tORALE_MATEMATICA.VALORE,\n                                                \t\t\tORE_ITALIANO.VALORE,\n                                                \t\t\tORE_MATEMATICA.VALORE,\n                                                \t\t\tGENITORE_01.SESSO,\n                                                \t\t\tNASCITA_GENITORE_1.VALORE,\n                                                \t\t\tISTRUZIONE_GENITORE_1.VALORE,\n                                                \t\t\tOCCUPAZIONE_GENITORE_1.VALORE,\n                                                \t\t\tGENITORE_02.SESSO,\n                                                \t\t\tNASCITA_GENITORE_2.VALORE,\n                                                \t\t\tISTRUZIONE_GENITORE_2.VALORE,\n                                                \t\t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                                \t\t\tORE_SETTIMANALI.VALORE,\n                                                                      /*CONTESTO_ESAME*/\n                                                                      CONTESTO_ESAME.COGNOME,\n                                                                      CONTESTO_ESAME.NOME,\n                                                                      TIPO_CANDIDATO.VALORE,\n                                                                      AMMESSO.VALORE,\n                                                                      VOTO_AMMISSIONE.VALORE,\n                                                                      /*ESAME_ALUNNO*/\n                                                             VOTO_INVALSI.VALORE,\n                                                             /* PUNTEGGI PROVE */\n                                                            ESITO_PROVA_ITA.VALORE,\n                                                            ESITO_PROVA_MAT.VALORE,\n                                                            /* PERSONALIZZATA */\n                                                             TEMPO_AGGIUNTIVO_ITA.VALORE,\n                                                             TEMPO_AGGIUNTIVO_MAT.VALORE,\n                                                             VOTO_PROVA_ESAME_ITALIANO.VALORE,\n                                                             VOTO_PROVA_ESAME_MATEMATICA.VALORE,\n                                                             VOTO_PROVA_ESAME_LINGUA.VALORE\n                                                         FROM ALUNNO \n                                                \t\tLEFT OUTER JOIN CONTESTO ON ALUNNO.ID = CONTESTO.ALUNNO\n                                                \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n                                                \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n                                                \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n                                                \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n                                                \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n                                                \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n                                                \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n                                                \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n                                                \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n                                                \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n                                                \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n                                                \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n                                                \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n                                                \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n                                                \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n                                                \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                                                      LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID \n                                                             /* CONTESTO_ESAME */\n                                                      LEFT OUTER JOIN CONTESTO_ESAME  ON CONTESTO_ESAME.ALUNNO = ALUNNO.ID\n                                                      LEFT OUTER JOIN TIPO_CANDIDATO  ON CONTESTO_ESAME.TIPO_CANDIDATO = TIPO_CANDIDATO.ID\n                                                      LEFT OUTER JOIN AMMESSO  ON CONTESTO_ESAME.AMMESSO = AMMESSO.ID\n                                                      LEFT OUTER JOIN VOTO_AMMISSIONE  ON CONTESTO_ESAME.VOTO_AMMISSIONE = VOTO_AMMISSIONE.ID\n                                                             /* ESAME_ALUNNO */\n                                                      LEFT OUTER JOIN ESAME_ALUNNO  ON ESAME_ALUNNO.ALUNNO = ALUNNO.ID\n                                                      LEFT OUTER JOIN VOTO_ESAME AS VOTO_INVALSI ON VOTO_INVALSI.ID = ESAME_ALUNNO.VOTO_INVALSI\n                                                                /* PUNTEGGI PROVE */\n                                                       LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_ITA on ESITO_PROVA_ITA.ALUNNO = ALUNNO.ID  \n                                                       LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_MAT on ESITO_PROVA_MAT.ALUNNO = ALUNNO.ID  \n                                                       LEFT OUTER JOIN STRUMENTO as PROVA_ITA ON PROVA_ITA.ID = ESITO_PROVA_ITA.STRUMENTO \n                                                       LEFT OUTER JOIN STRUMENTO as PROVA_MAT ON PROVA_MAT.ID = ESITO_PROVA_MAT.STRUMENTO             \n                                         left outer join TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_ITA on TEMPO_AGGIUNTIVO_ITA.ID  = ESITO_PROVA_ITA.TEMPO_AGGIUNTIVO\n                                         left outer join TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_MAT on TEMPO_AGGIUNTIVO_MAT.ID  = ESITO_PROVA_MAT.TEMPO_AGGIUNTIVO\n                              LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_ITALIANO ON VOTO_PROVA_ESAME_ITALIANO.ID = ESAME_ALUNNO.VOTO_ESAME_ITALIANO\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_MATEMATICA ON VOTO_PROVA_ESAME_MATEMATICA.ID = ESAME_ALUNNO.VOTO_ESAME_MATEMATICA\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_LINGUA ON VOTO_PROVA_ESAME_LINGUA.ID = ESAME_ALUNNO.VOTO_ESAME_LINGUA\n                        \t\t\t\tWHERE ALUNNO.CLASSE= ? and PROVA_ITA.MATERIA='ITA' and PROVA_MAT.MATERIA='MAT' \n\t\t\t\t\t\t\t\torder by  ALUNNO.SEQUENZIALE DESC;");
            } else {
                stat_get_alunno = conn.prepareStatement("SELECT     TOP(1)  ALUNNO.ID,\n                                                \t\t\tALUNNO.SEQUENZIALE,\n                                                \t\t\tALUNNO.SIDI,\n                                                \t\t\tCONTESTO.ANNO,\n                                                \t\t\tGIORNO_NASCITA.VALORE,\n                                                \t\t\tMESE_NASCITA.NOME,\n                                                \t\t\tCONTESTO.ANNO_NASCITA,\n                                                \t\t\tLUOGO_NASCITA.VALORE,\n                                                \t\t\tARRIVO_ITALIA.VALORE,\n                                                \t\t\tCONTESTO.NIDO,\n                                                \t\t\tCONTESTO.MATERNA,\n                                                \t\t\tCONTESTO.SESSO,\n                                                \t\t\tDISABILITA.VALORE,\n                                                \t\t\tSTATO.VALORE,\n                                                \t\t\tSCRITTO_ITALIANO.VALORE,\n                                                \t\t\tORALE_ITALIANO.VALORE,\n                                                \t\t\tSCRITTO_MATEMATICA.VALORE,\n                                                \t\t\tORALE_MATEMATICA.VALORE,\n                                                \t\t\tORE_ITALIANO.VALORE,\n                                                \t\t\tORE_MATEMATICA.VALORE,\n                                                \t\t\tGENITORE_01.SESSO,\n                                                \t\t\tNASCITA_GENITORE_1.VALORE,\n                                                \t\t\tISTRUZIONE_GENITORE_1.VALORE,\n                                                \t\t\tOCCUPAZIONE_GENITORE_1.VALORE,\n                                                \t\t\tGENITORE_02.SESSO,\n                                                \t\t\tNASCITA_GENITORE_2.VALORE,\n                                                \t\t\tISTRUZIONE_GENITORE_2.VALORE,\n                                                \t\t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                                \t\t\tORE_SETTIMANALI.VALORE\n                                                         FROM ALUNNO \n                                                \t\tLEFT OUTER JOIN CONTESTO ON ALUNNO.ID = CONTESTO.ALUNNO\n                                                \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n                                                \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n                                                \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n                                                \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n                                                \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n                                                \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n                                                \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n                                                \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n                                                \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n                                                \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n                                                \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n                                                \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n                                                \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n                                                \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n                                                \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n                                                \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n                                                \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                                                      LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID \n                        \t\t\t\tWHERE ALUNNO.CLASSE= ? \n\t\t\t\t\t\t\t\torder by  ALUNNO.SEQUENZIALE DESC;");
            }
            stat_get_alunno.setInt(1, classe.getId());
            stat_aggiungi_alunno.execute();
            stat_contesto.execute();
            if (classe.getLivello() == 8) {
                stat_contesto_esame.execute();
                stat_voto_esame.execute();
                stat_esito_prova_ita.execute();
                stat_esito_prova_mat.execute();
            }
            stat_get_alunno.execute();
            result = stat_get_alunno.getResultSet();
            if (result.next()) {
                int i = 1;
                alunno = classe.getLivello() != 8 ? new AlunnoValutato(result.getInt(i++), result.getInt(i++), result.getString(i++)) : new AlunnoEsaminato(result.getInt(i++), result.getInt(i++), result.getString(i++));
                int n = ++i;
                alunno.setGiornoNascita(result.getString(n));
                int n2 = ++i;
                alunno.setMeseNascita(result.getString(n2));
                int n3 = ++i;
                alunno.setAnnoNascita(result.getString(n3));
                int n4 = ++i;
                alunno.setLuogoNascita(result.getString(n4));
                int n5 = ++i;
                alunno.setArrivoItalia(result.getString(n5));
                int n6 = ++i;
                alunno.setNido(result.getString(n6));
                int n7 = ++i;
                alunno.setMaterna(result.getString(n7));
                int n8 = ++i;
                alunno.setSesso(result.getString(n8));
                int n9 = ++i;
                alunno.setDisabilita(result.getString(n9));
                int n10 = ++i;
                alunno.setStato(result.getString(n10));
                int n11 = ++i;
                alunno.setVotoScrittoItaliano(result.getString(n11));
                int n12 = ++i;
                alunno.setVotoOraleItaliano(result.getString(n12));
                int n13 = ++i;
                alunno.setVotoScrittoMatematica(result.getString(n13));
                int n14 = ++i;
                alunno.setVotoOraleMatematica(result.getString(n14));
                int n15 = ++i;
                alunno.setOreItaliano(result.getString(n15));
                int n16 = ++i;
                alunno.setOreMatematica(result.getString(n16));
                LinkedList<Genitore> genitori = new LinkedList<Genitore>();
                int n17 = ++i;
                int n18 = ++i;
                int n19 = ++i;
                int n20 = ++i;
                Genitore genitore = new Genitore(result.getString(n17), result.getString(n18), result.getString(n19), result.getString(n20));
                genitori.add(genitore);
                int n21 = ++i;
                int n22 = ++i;
                int n23 = ++i;
                int n24 = ++i;
                genitore = new Genitore(result.getString(n21), result.getString(n22), result.getString(n23), result.getString(n24));
                genitori.add(genitore);
                alunno.setGenitori(genitori);
                int n25 = ++i;
                ++i;
                alunno.setOreLerzione(result.getString(n25));
                if (classe.getLivello() == 8) {
                    esaminato = (AlunnoEsaminato)alunno;
                    esaminato.setCognome(result.getString(i++));
                    esaminato.setNome(result.getString(i++));
                    esaminato.setTipoCandidato(result.getString(i++));
                    esaminato.setAmmesso(result.getString(i++));
                    esaminato.setVotoAmmissione(result.getString(i++));
                    esaminato.setVotoInvalsi(result.getString(i++));
                    esaminato.setPunteggioItaliano(result.getInt(i++));
                    esaminato.setPunteggioMatematica(result.getInt(i++));
                    esaminato.setTempoAggiuntivoItaliano(result.getString(i++));
                    esaminato.setTempoAggiuntivoMatematica(result.getString(i++));
                    esaminato.setVotoProvaEsameItaliano(result.getString(i++));
                    esaminato.setVotoProvaEsameMatematica(result.getString(i++));
                    esaminato.setVotoProvaEsameLingua(result.getString(i++));
                }
            }
            PreparedStatement stat_numeroALunni = null;
            stat_numeroALunni = conn.prepareStatement("update CLASSE set N_ALUNNI=(select count (ALUNNO.ID) from ALUNNO where ALUNNO.CLASSE= ? ) where CLASSE.ID =?;");
            stat_numeroALunni.setInt(1, classe.getId());
            stat_numeroALunni.setInt(2, classe.getId());
            stat_numeroALunni.execute();
            conn.commit();
            conn.setAutoCommit(true);
            conn.setTransactionIsolation(2);
            return alunno;
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            this.connMgr.rollBack(conn);
            try {
                conn.setAutoCommit(true);
                conn.setTransactionIsolation(2);
            }
            catch (Exception ec) {
                Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ec);
            }
            throw new AlunnoDaoException("Errore nel creare l'alunno nel DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            this.connMgr.rollBack(conn);
            throw new AlunnoDaoException("Errore nel creare l'alunno nel DB");
        }
    }

    @Override
    public void updateSidiAlunno(int idAlunno, String sidi) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("update ALUNNO set ALUNNO.SIDI=? where ALUNNO.ID=?");
            stat.setString(1, sidi);
            stat.setInt(2, idAlunno);
            stat.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nell'aggiornare il sidi dell'alunno nel DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
    }

    @Override
    public Map<String, String> getInfoOnProveAndQuestionari(int idAlunno, int livello) throws AlunnoDaoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateContestoEsameAlunno(int idAlunno, String cognome, String nome, String tipoCandidato, String ammesso, String votoAmmissione, String votoEsameItaliano, String votoEsameMatematica, String votoEsameLingua, String votoEsameInvalsi) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat_contesto_esame = null;
        PreparedStatement stat_delete_esame_alunno = null;
        PreparedStatement stat_esame_alunno = null;
        try {
            conn = this.connMgr.getConnection();
            stat_contesto_esame = conn.prepareStatement("update CONTESTO_ESAME set \n         CONTESTO_ESAME.COGNOME= ?,\n         CONTESTO_ESAME.NOME= ?,\n         CONTESTO_ESAME.TIPO_CANDIDATO = (select TIPO_CANDIDATO.ID from TIPO_CANDIDATO where TIPO_CANDIDATO.VALORE =?),\n         CONTESTO_ESAME.AMMESSO =  (select AMMESSO.ID from AMMESSO where AMMESSO.VALORE =?),\n         CONTESTO_ESAME.VOTO_AMMISSIONE = (select VOTO_AMMISSIONE.ID from VOTO_AMMISSIONE where VOTO_AMMISSIONE.VALORE =?)\nwhere CONTESTO_ESAME.ALUNNO =?;");
            stat_delete_esame_alunno = conn.prepareStatement(" DELETE ESAME_ALUNNO WHERE ALUNNO=?");
            stat_esame_alunno = conn.prepareStatement("insert into ESAME_ALUNNO (ALUNNO, VOTO_INVALSI, VOTO_ESAME_ITALIANO, VOTO_ESAME_MATEMATICA, VOTO_ESAME_LINGUA) values  \n         (              ?,             (select VOTO_ESAME.ID from VOTO_ESAME where VOTO_ESAME.VALORE =?),\n             (select VOTO_ESAME.ID from VOTO_ESAME where VOTO_ESAME.VALORE =?),\n             (select VOTO_ESAME.ID from VOTO_ESAME where VOTO_ESAME.VALORE =?),\n             (select VOTO_ESAME.ID from VOTO_ESAME where VOTO_ESAME.VALORE =?)         );");
            stat_contesto_esame.setString(1, cognome);
            stat_contesto_esame.setString(2, nome);
            stat_contesto_esame.setString(3, tipoCandidato);
            stat_contesto_esame.setString(4, ammesso);
            stat_contesto_esame.setString(5, votoAmmissione);
            stat_contesto_esame.setInt(6, idAlunno);
            stat_delete_esame_alunno.setInt(1, idAlunno);
            stat_esame_alunno.setInt(1, idAlunno);
            stat_esame_alunno.setString(2, votoEsameInvalsi);
            stat_esame_alunno.setString(3, votoEsameItaliano);
            stat_esame_alunno.setString(4, votoEsameMatematica);
            stat_esame_alunno.setString(5, votoEsameLingua);
            stat_contesto_esame.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nell'aggiornare i dati di contesto d'esame per l'alunno (DB error). Stop");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException("Errore nell'aggiornare i dati d'esame per l'alunno (DB connection error). Stop");
        }
        try {
            stat_delete_esame_alunno.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore cancellare il vecchio esame dell'alunno (DB error). Stop");
        }
        try {
            stat_esame_alunno.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore inserire il nuovo esame dell'alunno (DB error). Stop");
        }
    }

    @Override
    public AlunnoEsaminato getAlunnoEsaminato(int idAlunno) throws AlunnoDaoException {
        AlunnoEsaminato alunno = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        PreparedStatement stat_punteggi = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("         SELECT           ALUNNO.ID,\n                                    \t\t\tALUNNO.SEQUENZIALE,\n                                    \t\t\tALUNNO.SIDI,\n                                    \t\t\tCONTESTO.ANNO,\n                                    \t\t\tGIORNO_NASCITA.VALORE,\n                                    \t\t\tMESE_NASCITA.NOME,\n                                    \t\t\tCONTESTO.ANNO_NASCITA,\n                                    \t\t\tLUOGO_NASCITA.VALORE,\n                                    \t\t\tARRIVO_ITALIA.VALORE,\n                                    \t\t\tCONTESTO.NIDO,\n                                    \t\t\tCONTESTO.MATERNA,\n                                    \t\t\tCONTESTO.SESSO,\n                                    \t\t\tDISABILITA.VALORE,\n                                    \t\t\tSTATO.VALORE,\n                                    \t\t\tSCRITTO_ITALIANO.VALORE,\n                                    \t\t\tORALE_ITALIANO.VALORE,\n                                    \t\t\tSCRITTO_MATEMATICA.VALORE,\n                                    \t\t\tORALE_MATEMATICA.VALORE,\n                                    \t\t\tORE_ITALIANO.VALORE,\n                                    \t\t\tORE_MATEMATICA.VALORE,\n                                    \t\t\tGENITORE_01.SESSO,\n                                    \t\t\tNASCITA_GENITORE_1.VALORE,\n                                    \t\t\tISTRUZIONE_GENITORE_1.VALORE,\n                                    \t\t\tOCCUPAZIONE_GENITORE_1.VALORE,\n                                    \t\t\tGENITORE_02.SESSO,\n                                    \t\t\tNASCITA_GENITORE_2.VALORE,\n                                    \t\t\tISTRUZIONE_GENITORE_2.VALORE,\n                                    \t\t\tOCCUPAZIONE_GENITORE_2.VALORE,\n                                                         ORE_SETTIMANALI.VALORE,\n                                                         /*CONTESTO_ESAME*/\n                                                         CONTESTO_ESAME.COGNOME,\n                                                         CONTESTO_ESAME.NOME,\n                                                         TIPO_CANDIDATO.VALORE,\n                                                         AMMESSO.VALORE,\n                                                         VOTO_AMMISSIONE.VALORE,\n                                                         /*ESAME_ALUNNO*/\n                                                 VOTO_INVALSI.VALORE,\n                                                 /* PUNTEGGI PROVE */\n                                                ESITO_PROVA_INVALSI_ITA.VALORE,\n                                                ESITO_PROVA_INVALSI_MAT.VALORE,\n                                                TEMPO_AGGIUNTIVO_ITA.VALORE,\n                                                TEMPO_AGGIUNTIVO_MAT.VALORE,\n                                                /* PERSONALIZZATA */\n                                                VOTO_PROVA_ESAME_ITALIANO.VALORE,\n                                                VOTO_PROVA_ESAME_MATEMATICA.VALORE,\n                                                VOTO_PROVA_ESAME_LINGUA.VALORE\n                                             FROM ALUNNO \n                                    \t\tLEFT OUTER JOIN CONTESTO ON ALUNNO.ID = CONTESTO.ALUNNO\n                                    \t\tLEFT OUTER JOIN GIORNO_NASCITA ON CONTESTO.GIORNO_NASCITA = GIORNO_NASCITA.ID \n                                    \t\tLEFT OUTER JOIN MESE_NASCITA ON CONTESTO.MESE_NASCITA = MESE_NASCITA.ID \n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA ON CONTESTO.LUOGO_NASCITA = LUOGO_NASCITA.ID\n                                    \t\tLEFT OUTER JOIN ARRIVO_ITALIA ON CONTESTO.ARRIVO_ITALIA = ARRIVO_ITALIA.ID\n                                    \t\tLEFT OUTER JOIN DISABILITA  ON CONTESTO.DISABILITA = DISABILITA.ID\n                                    \t\tLEFT OUTER JOIN STATO_ALUNNO AS STATO  ON CONTESTO.STATO = STATO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS SCRITTO_ITALIANO ON CONTESTO.SCRITTO_ITA= SCRITTO_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS ORALE_ITALIANO ON CONTESTO.ORALE_ITA= ORALE_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS SCRITTO_MATEMATICA ON CONTESTO.SCRITTO_MAT= SCRITTO_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN VOTO AS ORALE_MATEMATICA ON CONTESTO.ORALE_MAT= ORALE_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_ITALIANO  ON CONTESTO.ORE_ITA= ORE_ITALIANO.ID\n                                    \t\tLEFT OUTER JOIN ORE_MATERIA AS ORE_MATEMATICA ON CONTESTO.ORE_MAT= ORE_MATEMATICA.ID\n                                    \t\tLEFT OUTER JOIN GENITORE AS GENITORE_01 ON CONTESTO.GENITORE_1 = GENITORE_01.ID \n                                    \t\tLEFT OUTER JOIN GENITORE AS GENITORE_02 ON CONTESTO.GENITORE_2 = GENITORE_02.ID\n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_1 ON  GENITORE_01.LUOGO_NASCITA = NASCITA_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN LUOGO_NASCITA AS NASCITA_GENITORE_2 ON  GENITORE_02.LUOGO_NASCITA = NASCITA_GENITORE_2.ID\n                                    \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_1 ON GENITORE_01.ISTRUZIONE = ISTRUZIONE_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN ISTRUZIONE AS ISTRUZIONE_GENITORE_2 ON GENITORE_02.ISTRUZIONE = ISTRUZIONE_GENITORE_2.ID\n                                    \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_1 ON  GENITORE_01.OCCUPAZIONE = OCCUPAZIONE_GENITORE_1.ID\n                                    \t\tLEFT OUTER JOIN OCCUPAZIONE AS OCCUPAZIONE_GENITORE_2 ON  GENITORE_02.OCCUPAZIONE = OCCUPAZIONE_GENITORE_2.ID\t\n                                          LEFT OUTER JOIN ORE_SETTIMANALI ON CONTESTO.ORE_SETTIMANALI=ORE_SETTIMANALI.ID \n                                                 /* CONTESTO_ESAME */\n                                          LEFT OUTER JOIN CONTESTO_ESAME  ON CONTESTO_ESAME.ALUNNO = ALUNNO.ID\n                                          LEFT OUTER JOIN TIPO_CANDIDATO  ON CONTESTO_ESAME.TIPO_CANDIDATO = TIPO_CANDIDATO.ID\n                                          LEFT OUTER JOIN AMMESSO  ON CONTESTO_ESAME.AMMESSO = AMMESSO.ID\n                                          LEFT OUTER JOIN VOTO_AMMISSIONE  ON CONTESTO_ESAME.VOTO_AMMISSIONE = VOTO_AMMISSIONE.ID\n                                                 /* ESAME_ALUNNO */\n                                          LEFT OUTER JOIN ESAME_ALUNNO  ON ESAME_ALUNNO.ALUNNO = ALUNNO.ID\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_INVALSI ON VOTO_INVALSI.ID = ESAME_ALUNNO.VOTO_INVALSI\n                                                    /* PUNTEGGI PROVE */\n                                          LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_INVALSI_ITA on ESITO_PROVA_INVALSI_ITA.ALUNNO = ALUNNO.ID  \n                                          LEFT OUTER JOIN ESITO_PROVA as ESITO_PROVA_INVALSI_MAT on ESITO_PROVA_INVALSI_MAT.ALUNNO = ALUNNO.ID  \n                                          LEFT OUTER JOIN STRUMENTO as PROVA_INVALSI_ITA ON PROVA_INVALSI_ITA.ID = ESITO_PROVA_INVALSI_ITA.STRUMENTO \n                                          LEFT OUTER JOIN STRUMENTO as PROVA_INVALSI_MAT ON PROVA_INVALSI_MAT.ID = ESITO_PROVA_INVALSI_MAT.STRUMENTO \n                                          LEFT OUTER JOIN TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_ITA on TEMPO_AGGIUNTIVO_ITA.ID  = ESITO_PROVA_INVALSI_ITA.TEMPO_AGGIUNTIVO\n                                          LEFT OUTER JOIN TEMPO_AGGIUNTIVO as TEMPO_AGGIUNTIVO_MAT on TEMPO_AGGIUNTIVO_MAT.ID  = ESITO_PROVA_INVALSI_MAT.TEMPO_AGGIUNTIVO\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_ITALIANO ON VOTO_PROVA_ESAME_ITALIANO.ID = ESAME_ALUNNO.VOTO_ESAME_ITALIANO\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_MATEMATICA ON VOTO_PROVA_ESAME_MATEMATICA.ID = ESAME_ALUNNO.VOTO_ESAME_MATEMATICA\n                                          LEFT OUTER JOIN VOTO_ESAME AS VOTO_PROVA_ESAME_LINGUA ON VOTO_PROVA_ESAME_LINGUA.ID = ESAME_ALUNNO.VOTO_ESAME_LINGUA\n            \t\t\t\tWHERE ALUNNO.ID= ? and PROVA_INVALSI_ITA.MATERIA='ITA' and PROVA_INVALSI_MAT.MATERIA='MAT';");
            stat_punteggi = conn.prepareStatement("select STRUMENTO.ID, STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.ANNO, STRUMENTO.LIVELLO, STRUMENTO.TIPO,\n            \t  ESITO_PROVA.VALORE\n            from STRUMENTO join ESITO_PROVA on STRUMENTO.ID = ESITO_PROVA.STRUMENTO\n            \t\t\tjoin MATERIA on MATERIA.CODICE = STRUMENTO.MATERIA\n            where ESITO_PROVA.ALUNNO = ?\n            order by STRUMENTO.ID;");
            stat.setInt(1, idAlunno);
            stat.execute();
            result = stat.getResultSet();
            int i = 1;
            if (result.next()) {
                alunno = new AlunnoEsaminato(result.getInt(i++), result.getInt(i++), result.getString(i++));
                int n = ++i;
                alunno.setGiornoNascita(result.getString(n));
                int n2 = ++i;
                alunno.setMeseNascita(result.getString(n2));
                int n3 = ++i;
                alunno.setAnnoNascita(result.getString(n3));
                int n4 = ++i;
                alunno.setLuogoNascita(result.getString(n4));
                int n5 = ++i;
                alunno.setArrivoItalia(result.getString(n5));
                int n6 = ++i;
                alunno.setNido(result.getString(n6));
                int n7 = ++i;
                alunno.setMaterna(result.getString(n7));
                int n8 = ++i;
                alunno.setSesso(result.getString(n8));
                int n9 = ++i;
                alunno.setDisabilita(result.getString(n9));
                int n10 = ++i;
                alunno.setStato(result.getString(n10));
                int n11 = ++i;
                alunno.setVotoScrittoItaliano(result.getString(n11));
                int n12 = ++i;
                alunno.setVotoOraleItaliano(result.getString(n12));
                int n13 = ++i;
                alunno.setVotoScrittoMatematica(result.getString(n13));
                int n14 = ++i;
                alunno.setVotoOraleMatematica(result.getString(n14));
                int n15 = ++i;
                alunno.setOreItaliano(result.getString(n15));
                int n16 = ++i;
                alunno.setOreMatematica(result.getString(n16));
                LinkedList<Genitore> genitori = new LinkedList<Genitore>();
                int n17 = ++i;
                int n18 = ++i;
                int n19 = ++i;
                int n20 = ++i;
                Genitore genitore = new Genitore(result.getString(n17), result.getString(n18), result.getString(n19), result.getString(n20));
                genitori.add(genitore);
                int n21 = ++i;
                int n22 = ++i;
                int n23 = ++i;
                int n24 = ++i;
                genitore = new Genitore(result.getString(n21), result.getString(n22), result.getString(n23), result.getString(n24));
                genitori.add(genitore);
                alunno.setGenitori(genitori);
                int n25 = ++i;
                alunno.setOreLerzione(result.getString(n25));
                int n26 = ++i;
                alunno.setCognome(result.getString(n26));
                int n27 = ++i;
                alunno.setNome(result.getString(n27));
                int n28 = ++i;
                alunno.setTipoCandidato(result.getString(n28));
                int n29 = ++i;
                alunno.setAmmesso(result.getString(n29));
                int n30 = ++i;
                alunno.setVotoAmmissione(result.getString(n30));
                int n31 = ++i;
                alunno.setVotoInvalsi(result.getString(n31));
                int n32 = ++i;
                alunno.setPunteggioItaliano(result.getInt(n32));
                int n33 = ++i;
                alunno.setPunteggioMatematica(result.getInt(n33));
                int n34 = ++i;
                alunno.setTempoAggiuntivoItaliano(result.getString(n34));
                int n35 = ++i;
                alunno.setTempoAggiuntivoMatematica(result.getString(n35));
                int n36 = ++i;
                alunno.setVotoProvaEsameItaliano(result.getString(n36));
                int n37 = ++i;
                alunno.setVotoProvaEsameMatematica(result.getString(n37));
                int n38 = ++i;
                ++i;
                alunno.setVotoProvaEsameLingua(result.getString(n38));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Errore nel recuperare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
        return alunno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanAlunniDelleClasse(int ClasseId) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat_alunno = null;
        PreparedStatement stat_contesto = null;
        PreparedStatement stat_contesto_esame = null;
        PreparedStatement stat_voto_esame = null;
        PreparedStatement stat_esito_prova = null;
        try {
            conn = this.connMgr.getConnection();
            stat_esito_prova = conn.prepareStatement("delete from ESITO_PROVA where ESITO_PROVA.ALUNNO in (select ALUNNO.ID from ALUNNO where ALUNNO.CLASSE=?);");
            stat_voto_esame = conn.prepareStatement("delete from ESAME_ALUNNO where ESAME_ALUNNO.ALUNNO in (select ALUNNO.ID from ALUNNO where ALUNNO.CLASSE=?);");
            stat_contesto_esame = conn.prepareStatement("delete from CONTESTO_ESAME where CONTESTO_ESAME.ALUNNO in (select ALUNNO.ID from ALUNNO where ALUNNO.CLASSE=?);");
            stat_contesto = conn.prepareStatement("delete from CONTESTO where CONTESTO.ALUNNO in (select ALUNNO.ID from ALUNNO where ALUNNO.CLASSE=?);");
            stat_alunno = conn.prepareStatement("delete from ALUNNO where ALUNNO.CLASSE=?;");
            stat_esito_prova.setInt(1, ClasseId);
            stat_voto_esame.setInt(1, ClasseId);
            stat_contesto_esame.setInt(1, ClasseId);
            stat_contesto.setInt(1, ClasseId);
            stat_alunno.setInt(1, ClasseId);
            stat_esito_prova.execute();
            stat_voto_esame.execute();
            stat_contesto_esame.execute();
            stat_contesto.execute();
            stat_alunno.execute();
            conn.commit();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            this.connMgr.rollBack(conn);
            try {
                conn.setAutoCommit(true);
                conn.setTransactionIsolation(2);
            }
            catch (Exception ec) {
                Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ec);
            }
            throw new AlunnoDaoException("Errore nel eliminare gli alunni dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            this.connMgr.rollBack(conn);
            throw new AlunnoDaoException("Errore nel eliminare gli alunni dal DB");
        }
    }

    @Override
    public boolean ciSonoRisposteDellAlunno(int idAlunno) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat_alunno = null;
        ResultSet resultSet = null;
        int result = 0;
        try {
            conn = this.connMgr.getConnection();
            stat_alunno = conn.prepareStatement("select count(1) from RISPOSTA_ITEM where ALUNNO=?;");
            stat_alunno.setInt(1, idAlunno);
            stat_alunno.execute();
            resultSet = stat_alunno.getResultSet();
            if (resultSet.next()) {
                result = resultSet.getInt(1);
            }
            return result > 0;
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException("Impossibile eseguire l'perazione");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException("Impossibile eseguire l'perazione");
        }
    }

    @Override
    public void setAlunniEsaminatiEsterni(int idClasse) throws AlunnoDaoException {
        Connection conn = null;
        PreparedStatement stat_alunno = null;
        try {
            conn = this.connMgr.getConnection();
            stat_alunno = conn.prepareStatement("update CONTESTO_ESAME set TIPO_CANDIDATO=2 where ALUNNO in(select ALUNNO.ID from alunno join CLASSE on ALUNNO.CLASSE=CLASSE.ID where CLASSE.ID=?);");
            stat_alunno.setInt(1, idClasse);
            stat_alunno.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new AlunnoDaoException(e.getMessage());
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunnoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunnoDaoException(ex.getMessage());
        }
    }
}

