/*
 * Decompiled with CFR 0.152.
 */
package invalsi.business.scuole.impl;

import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.CorsoDiStudio;
import invalsi.beans.scuole.Plesso;
import invalsi.business.scuole.IScuoleMgt;
import invalsi.dao.interfaces.scuole.IClasseDao;
import invalsi.dao.interfaces.scuole.ICorsoDiStudioDao;
import invalsi.dao.interfaces.scuole.IPlessoDao;
import invalsi.dao.local.scuole.ClasseLocalDao;
import invalsi.dao.local.scuole.CorsoDiStudioLocalDao;
import invalsi.dao.local.scuole.PlessoLocalDao;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import invalsi.eccezioni.dao.prove.CorsoDiStudioDaoException;
import invalsi.eccezioni.dao.scuole.ClasseDaoException;
import invalsi.eccezioni.dao.scuole.PlessoDaoException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScuoleMgr
implements IScuoleMgt {
    public static final String PRIMARIA = "SCUOLA PRIMARIA";
    public static final String SECONDARIA_I = "SCUOLA SECONDARIA I LIVELLO";
    public static final String SECONDARIA_II = "SCUOLA SECONDARIA II LIVELLO";
    public final Map<String, String> formazioni = new HashMap<String, String>();
    private static volatile IScuoleMgt myIstance = null;
    private final IPlessoDao plessoDao;
    private final ICorsoDiStudioDao corsoDao;
    private final IClasseDao classeDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IScuoleMgt getIstance() throws ScuoleMgtException {
        if (myIstance != null) return myIstance;
        Class<ScuoleMgr> clazz = ScuoleMgr.class;
        synchronized (ScuoleMgr.class) {
            if (myIstance != null) return myIstance;
            myIstance = new ScuoleMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myIstance;
        }
    }

    private ScuoleMgr() throws ScuoleMgtException {
        this.formazioni.put(PRIMARIA, new Integer(1).toString());
        this.formazioni.put(SECONDARIA_I, new Integer(2).toString());
        this.formazioni.put(SECONDARIA_II, new Integer(3).toString());
        try {
            this.plessoDao = new PlessoLocalDao();
            this.classeDao = new ClasseLocalDao();
            this.corsoDao = new CorsoDiStudioLocalDao();
        }
        catch (PlessoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        catch (CorsoDiStudioDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }

    @Override
    public List<Plesso> getPlessiByIstituto(String mecconograficoIstituto) throws ScuoleMgtException {
        List<Plesso> plessi = null;
        try {
            plessi = this.plessoDao.getPlessiByIstituto(mecconograficoIstituto);
        }
        catch (PlessoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        return plessi;
    }

    @Override
    public List<CorsoDiStudio> getCorsiByPlesso(String plesso) throws ScuoleMgtException {
        List<CorsoDiStudio> corsi = null;
        try {
            corsi = this.corsoDao.getCorsiByPlesso(plesso);
        }
        catch (CorsoDiStudioDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        return corsi;
    }

    @Override
    public List<Classe> getClassiByCorso(int corsoId) throws ScuoleMgtException {
        try {
            Object corso = null;
            List<Classe> classi = null;
            classi = this.classeDao.getClassiByCorso(corsoId);
            return classi;
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }

    @Override
    public Map<Integer, String> getOreDiLezioneOptions() throws ScuoleMgtException {
        try {
            return this.classeDao.getOreDiLezioneOptions();
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public List<Plesso> getPlessiWithCorsiAndClassiBySvolgituraProve(String istituto) throws ScuoleMgtException {
        try {
            return this.plessoDao.getPlessiWithCorsiAndClassiBySvolgituraProve(istituto);
        }
        catch (PlessoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public List<Classe> getClassiBySvolgimentoProveAndIstituto(String istituto) throws ScuoleMgtException {
        try {
            return this.classeDao.getClassiBySvolgimentoProveAndIstituto(istituto);
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }

    @Override
    public Collection<CorsoDiStudio> getCorsiPopolatiConClassiByClassi(Collection<Classe> classi) throws ScuoleMgtException {
        try {
            return this.corsoDao.getCorsiPopolatiConClassiByClassi(classi);
        }
        catch (CorsoDiStudioDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }

    @Override
    public Collection<Plesso> getPlessiPopolatiConCorsiByIstitutoAndCorsi(String istituto, Collection<CorsoDiStudio> corsi) throws ScuoleMgtException {
        try {
            return this.plessoDao.getPlessiPopolatiConCorsiByIstitutoAndCorsi(istituto, corsi);
        }
        catch (PlessoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }

    @Override
    public void setNumeroAlunniDellaClasse(Classe classe, int numeroLaunni) throws ScuoleMgtException {
        try {
            this.classeDao.setNumeroAlunniDellaClasse(classe, numeroLaunni);
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }

    @Override
    public Classe getPrimaClasseConProveMancanti(Collection<Classe> classi) throws ScuoleMgtException {
        Classe classeConDatiMancanti = null;
        try {
            classeConDatiMancanti = this.classeDao.getPrimaClasseConProveMancanti(classi);
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        return classeConDatiMancanti;
    }

    @Override
    public Classe getUnaClasseByIstituto(String istituto) throws ScuoleMgtException {
        Classe unaClasse = null;
        try {
            unaClasse = this.classeDao.getUnaClasseByIstituto(istituto);
        }
        catch (ClasseDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
        return unaClasse;
    }

    @Override
    public List<String> getAllIstituti() throws ScuoleMgtException {
        try {
            return this.plessoDao.getAllIstituti();
        }
        catch (PlessoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ScuoleMgtException(ex.getMessage());
        }
    }
}

