/*
 * Decompiled with CFR 0.152.
 */
package invalsi.utils;

import invalsi.beans.scuole.Classe;
import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.eccezioni.business.prove.ProveMgtException;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import invalsi.utils.db.ConnectionMgr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordValidator_2014 {
    private static final String[] CONS = new String[]{"Bg", "Cf", "Dr", "Fg", "Gs", "Ht", "Lv", "Mq", "Np", "Pt", "Qf", "Rd", "Sv", "Tn", "Vm", "Zd"};

    public static Boolean valida(String istituto, String password) throws ProveMgtException, ScuoleMgtException {
        boolean validata = false;
        Classe unaClasse = null;
        String cod_cla = null;
        String calcolata = null;
        String ottavo_cod_cla = null;
        String settimo_cod_cla = null;
        String ultimo_istituto = null;
        String primo_istituto = null;
        String secondo_e_terzo_cod_cla = null;
        String primo_cod_cla = null;
        int index_cons = -1;
        int index_risultante = -1;
        String prime_tre_cifre_ris = null;
        String quarta_risultato = null;
        int quinta_o_quinta_e_sesta_risultato = -1;
        String ultima_risultato = null;
        unaClasse = ScuoleMgr.getIstance().getUnaClasseByIstituto(istituto);
        if (null == unaClasse) {
            return null;
        }
        cod_cla = unaClasse.getCodice();
        ottavo_cod_cla = cod_cla.substring(7, 8);
        settimo_cod_cla = cod_cla.substring(6, 7);
        ultimo_istituto = istituto.substring(istituto.length() - 1);
        primo_istituto = istituto.substring(0, 1).toLowerCase();
        secondo_e_terzo_cod_cla = cod_cla.substring(1, 3);
        primo_cod_cla = cod_cla.substring(0, 1);
        index_cons = new Integer(ottavo_cod_cla) + new Integer(settimo_cod_cla) + new Integer(primo_cod_cla);
        prime_tre_cifre_ris = ottavo_cod_cla + settimo_cod_cla + ultimo_istituto.toLowerCase();
        quarta_risultato = primo_istituto;
        quinta_o_quinta_e_sesta_risultato = new Integer(ottavo_cod_cla) + new Integer(settimo_cod_cla) + new Integer(secondo_e_terzo_cod_cla) + 100;
        index_risultante = index_cons % CONS.length;
        index_risultante = index_risultante == 0 ? CONS.length - 1 : --index_risultante;
        ultima_risultato = CONS[index_risultante];
        calcolata = prime_tre_cifre_ris + quarta_risultato + Integer.toString(quinta_o_quinta_e_sesta_risultato) + ultima_risultato;
        if (calcolata.equals(password)) {
            validata = true;
        }
        return validata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            List<String> istituti = ScuoleMgr.getIstance().getAllIstituti();
            File istitutiFile = new File("istituti_2014.txt");
            PrintWriter writer = new PrintWriter(istitutiFile);
            for (String istituto : istituti) {
                String result = PasswordValidator_2014.generaPassword(istituto);
                if (result.equals("skipme")) continue;
                writer.println(istituto + ";" + result);
                writer.flush();
            }
            writer.close();
            ConnectionMgr.getIstance().resetConnection();
            System.exit(0);
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(PasswordValidator_2014.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PasswordValidator_2014.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PasswordValidator_2014.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                ConnectionMgr.getIstance().resetConnection();
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(PasswordValidator_2014.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    public static String generaPassword(String istituto) {
        Classe unaClasse = null;
        String cod_cla = null;
        String calcolata = null;
        String ottavo_cod_cla = null;
        String settimo_cod_cla = null;
        String ultimo_istituto = null;
        String primo_istituto = null;
        String secondo_e_terzo_cod_cla = null;
        String primo_cod_cla = null;
        int index_cons = -1;
        int index_risultante = -1;
        String prime_tre_cifre_ris = null;
        String quarta_risultato = null;
        int quinta_o_quinta_e_sesta_risultato = -1;
        String ultima_risultato = null;
        try {
            unaClasse = ScuoleMgr.getIstance().getUnaClasseByIstituto(istituto);
            try {
                cod_cla = unaClasse.getCodice();
            }
            catch (NullPointerException ec) {
                return "skipme";
            }
            ottavo_cod_cla = cod_cla.substring(7, 8);
            settimo_cod_cla = cod_cla.substring(6, 7);
            ultimo_istituto = istituto.substring(istituto.length() - 1);
            primo_istituto = istituto.substring(0, 1).toLowerCase();
            secondo_e_terzo_cod_cla = cod_cla.substring(1, 3);
            primo_cod_cla = cod_cla.substring(0, 1);
            index_cons = new Integer(ottavo_cod_cla) + new Integer(settimo_cod_cla) + new Integer(primo_cod_cla);
            prime_tre_cifre_ris = ottavo_cod_cla + settimo_cod_cla + ultimo_istituto.toLowerCase();
            quarta_risultato = primo_istituto;
            quinta_o_quinta_e_sesta_risultato = new Integer(ottavo_cod_cla) + new Integer(settimo_cod_cla) + new Integer(secondo_e_terzo_cod_cla) + 100;
            index_risultante = index_cons % CONS.length;
            index_risultante = index_risultante == 0 ? CONS.length - 1 : --index_risultante;
            ultima_risultato = CONS[index_risultante];
            calcolata = prime_tre_cifre_ris + quarta_risultato + Integer.toString(quinta_o_quinta_e_sesta_risultato) + ultima_risultato;
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(PasswordValidator_2014.class.getName()).log(Level.SEVERE, null, ex);
        }
        return calcolata;
    }
}

