/*
 * Decompiled with CFR 0.152.
 */
package invalsi.utils;

import invalsi.beans.alunni.AlunnoEsaminato;
import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.prove.FascicoloCompilato;
import invalsi.beans.prove.ItemRisposto;
import invalsi.beans.prove.correzione.BloccoDiCorrezione;
import invalsi.beans.prove.correzione.Gruppo;
import invalsi.beans.prove.correzione.Range;
import invalsi.beans.scuole.Classe;
import invalsi.business.alunni.IAlunniMgt;
import invalsi.business.alunni.impl.AlunniMgr;
import invalsi.business.prove.IProveMgt;
import invalsi.business.prove.impl.ProveMgr;
import invalsi.business.scuole.IScuoleMgt;
import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.eccezioni.business.alunni.AlunniMgtException;
import invalsi.eccezioni.business.prove.ProveMgtException;
import invalsi.eccezioni.business.scuole.ScuoleMgtException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalcolaPunteggi {
    private static CalcolaPunteggi myIstance = null;
    private IProveMgt proveMgr = null;
    private IScuoleMgt scuoleMgr = null;
    private IAlunniMgt alunniMgr = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalcolaPunteggi getIstance() {
        if (myIstance != null) return myIstance;
        Class<CalcolaPunteggi> clazz = CalcolaPunteggi.class;
        synchronized (CalcolaPunteggi.class) {
            if (myIstance != null) return myIstance;
            myIstance = new CalcolaPunteggi();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myIstance;
        }
    }

    private CalcolaPunteggi() {
        try {
            this.proveMgr = ProveMgr.getIstance();
            this.scuoleMgr = ScuoleMgr.getIstance();
            this.alunniMgr = AlunniMgr.getIstance();
        }
        catch (ProveMgtException ex) {
            Logger.getLogger(CalcolaPunteggi.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(CalcolaPunteggi.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (AlunniMgtException ex) {
            Logger.getLogger(CalcolaPunteggi.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<AlunnoValutato> calcolaTuttiIPunteggi(String istituto) throws ScuoleMgtException, AlunniMgtException, ProveMgtException {
        List<Classe> classi = null;
        LinkedList<AlunnoValutato> alunniEsaminati = new LinkedList<AlunnoValutato>();
        classi = this.scuoleMgr.getClassiBySvolgituraProveAndIstituto(istituto);
        for (Classe nextClasse : classi) {
            alunniEsaminati.addAll(this.calcolaPunteggiClasse(nextClasse));
        }
        return alunniEsaminati;
    }

    private List<AlunnoValutato> calcolaPunteggiClasse(Classe classe) throws AlunniMgtException, ProveMgtException {
        List<AlunnoValutato> alunniEsaminati = this.alunniMgr.getAlunniValutatiByClasse(classe);
        List<FascicoloCompilato> fascicoliCompilati = null;
        AlunnoEsaminato alunnoEsaminato = null;
        for (AlunnoValutato nextALunno : alunniEsaminati) {
            alunnoEsaminato = (AlunnoEsaminato)nextALunno;
            fascicoliCompilati = this.proveMgr.getFascicoliByAlunnoValutato(alunnoEsaminato);
            for (FascicoloCompilato fascicolo : fascicoliCompilati) {
                int punteggioProva = 0;
                int punteggioBlocco = 0;
                int punteggioGruppo = 0;
                int voto = 0;
                int sommaPunteggio = 0;
                List<BloccoDiCorrezione> blocchi = this.proveMgr.getBlocchiDiItemConRisposte(alunnoEsaminato, fascicolo);
                for (BloccoDiCorrezione blocco : blocchi) {
                    for (Gruppo gruppo : blocco.getGruppi()) {
                        float fattoreDiCorrezione = gruppo.getFattoreDiCorrezione();
                        if (fattoreDiCorrezione == 0.0f) {
                            for (ItemRisposto item : gruppo.getItems()) {
                                if (!item.getRispostaCorretta().equals(item.getRispostaScelta())) continue;
                                ++punteggioGruppo;
                            }
                        } else {
                            int risposteCorrettePerGruppo = 0;
                            for (ItemRisposto item : gruppo.getItems()) {
                                if (!item.getRispostaCorretta().equals(item.getRispostaScelta())) continue;
                                ++risposteCorrettePerGruppo;
                            }
                            if ((float)risposteCorrettePerGruppo >= fattoreDiCorrezione * (float)gruppo.getItems().size()) {
                                ++punteggioGruppo;
                            }
                        }
                        punteggioBlocco += punteggioGruppo;
                        punteggioGruppo = 0;
                    }
                    for (Range range : blocco.getRanges()) {
                        if (punteggioBlocco > range.getMax()) continue;
                        blocco.setPunteggioNormalizzato(range.getPunteggio());
                        break;
                    }
                    punteggioProva += blocco.getPunteggioNormalizzato();
                    punteggioBlocco = 0;
                }
                if (fascicolo.getStrumento().getMateria().equals("Italiano")) {
                    alunnoEsaminato.setPunteggioItaliano(punteggioProva);
                } else if (fascicolo.getStrumento().getMateria().equals("Matematica")) {
                    alunnoEsaminato.setPunteggioMatematica(punteggioProva);
                } else {
                    System.out.println("Pazzia");
                }
                if (fascicoliCompilati.lastIndexOf(fascicolo) != 1) continue;
                sommaPunteggio = alunnoEsaminato.getPunteggioItaliano() + alunnoEsaminato.getPunteggioMatematica();
                if (sommaPunteggio >= 0) {
                    voto = sommaPunteggio <= 40 ? 4 : (sommaPunteggio <= 54 ? 5 : (sommaPunteggio <= 64 ? 6 : (sommaPunteggio <= 73 ? 7 : (sommaPunteggio <= 82 ? 8 : (sommaPunteggio <= 91 ? 9 : 10)))));
                }
                alunnoEsaminato.setVotoInvalsi("" + voto);
                this.proveMgr.salvaProvaAlunno(nextALunno, fascicoliCompilati.get(0), "standard - valutazione INVALSI", fascicoliCompilati.get(0).getItemsConRisposte(), "Non disponibile");
                this.alunniMgr.updateContestoEsameAlunno(alunnoEsaminato);
            }
        }
        return alunniEsaminati;
    }

    public static void main(String[] args) {
        try {
            List<AlunnoValutato> alunni = CalcolaPunteggi.getIstance().calcolaTuttiIPunteggi("RMIC000000");
            for (AlunnoValutato alunnoEsaminato : alunni) {
                System.out.println(((AlunnoEsaminato)alunnoEsaminato).getCognome() + ";" + ((AlunnoEsaminato)alunnoEsaminato).getNome() + ";" + ((AlunnoEsaminato)alunnoEsaminato).getPunteggioItaliano() + ";" + ((AlunnoEsaminato)alunnoEsaminato).getPunteggioMatematica() + ";" + (((AlunnoEsaminato)alunnoEsaminato).getPunteggioItaliano() + ((AlunnoEsaminato)alunnoEsaminato).getPunteggioMatematica()) + ";" + ((AlunnoEsaminato)alunnoEsaminato).getVotoInvalsi());
            }
        }
        catch (ScuoleMgtException ex) {
            Logger.getLogger(CalcolaPunteggi.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (AlunniMgtException ex) {
            Logger.getLogger(CalcolaPunteggi.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ProveMgtException ex) {
            Logger.getLogger(CalcolaPunteggi.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

