/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.scuole;

import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.CorsoDiStudio;
import invalsi.beans.scuole.Plesso;
import invalsi.dao.interfaces.scuole.IPlessoDao;
import invalsi.dao.local.scuole.AbstractLocalDao;
import invalsi.eccezioni.dao.scuole.PlessoDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlessoLocalDao
extends AbstractLocalDao
implements IPlessoDao {
    private static final String MECCANOGRAFICO = "MECCANOGRAFICO";
    private static final String ISTITUTO = "ISTITUTO";
    private static final String FORMAZIONE = "FORMAZIONE";

    public PlessoLocalDao() throws PlessoDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlessoDaoException(ex.getMessage());
        }
    }

    @Override
    public List<Plesso> getPlessiByIstituto(String istituto) throws PlessoDaoException {
        LinkedList<Plesso> plessi = new LinkedList<Plesso>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("SELECT MECCANOGRAFICO, ISTITUTO, FORMAZIONE FROM PLESSO WHERE ISTITUTO= ?;");
            stat.setString(1, istituto);
            stat.execute();
            result = stat.getResultSet();
            Plesso nextPlesso = null;
            while (result.next()) {
                nextPlesso = new Plesso(result.getString(MECCANOGRAFICO), result.getString(ISTITUTO), result.getInt(FORMAZIONE));
                plessi.add(nextPlesso);
            }
        }
        catch (ConnectionException e) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new PlessoDaoException(e.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlessoDaoException("Impossibile recuoerare i plessi dal DB");
        }
        return plessi;
    }

    @Override
    public List<Plesso> getPlessiWithCorsiAndClassiBySvolgituraProve(String istituto) throws PlessoDaoException {
        LinkedList<Plesso> plessi = new LinkedList<Plesso>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select distinct PLESSO.ISTITUTO, PLESSO.MECCANOGRAFICO, PLESSO.FORMAZIONE,\n               CORSO_DI_STUDIO.ID, INDIRIZZO.NOME, CORSO_DI_STUDIO.SEZIONE,\n               CLASSE.ID, CLASSE.CODICE, CLASSE.ANNO_DI_CORSO, CLASSE.LIVELLO\n\tFROM PLESSO\n\tjoin CORSO_DI_STUDIO on CORSO_DI_STUDIO.PLESSO = PLESSO.MECCANOGRAFICO\n\tjoin CLASSE on CLASSE.CORSO_DI_STUDIO = CORSO_DI_STUDIO.ID\n\tjoin INDIRIZZO on INDIRIZZO.ID = CORSO_DI_STUDIO.INDIRIZZO\n\tjoin ALUNNO on ALUNNO.CLASSE = CLASSE.ID\nwhere PLESSO.ISTITUTO = '?' AND (SELECT TOP(1) COUNT(SVOLGE_PROVA.ALUNNO) FROM SVOLGE_PROVA\n\t\t\t\t\t\t\t\t\t\t\t+\n\t\t\t\t\t\t\t\tSELECT COUNT(COMPILA_QUESTIONARIO.ALUNNO) FROM COMPILA_QUESTIONARIO)> 0            \nORDER BY PLESSO.ISTITUTO, PLESSO.MECCANOGRAFICO,CORSO_DI_STUDIO.ID,CLASSE.ID;");
            stat.setString(1, istituto);
            stat.execute();
            result = stat.getResultSet();
            Plesso plesso = null;
            CorsoDiStudio corso = null;
            Classe classe = null;
            LinkedList<CorsoDiStudio> corsi = null;
            LinkedList<Classe> classi = null;
            String meccanografco = "";
            int idCorso = 0;
            while (result.next()) {
                if (idCorso != result.getInt("CORSO_DI_STUDIO.ID")) {
                    corso = new CorsoDiStudio(result.getInt("CORSO_DI_STUDIO.ID"), result.getString("CORSO_DI_STUDIO.SEZIONE"), result.getString("INDIRIZZO.NOME"));
                    classi = new LinkedList<Classe>();
                    corso.setClassi(classi);
                    idCorso = corso.getId();
                    if (!meccanografco.equals(result.getString("PLESSO.MECCANOGRAFICO"))) {
                        plesso = new Plesso(result.getString("PLESSO.MECCANOGRAFICO"), result.getString("PLESSO.ISTITUTO"), result.getInt("PLESSO.FORMAZIONE"));
                        corsi = new LinkedList<CorsoDiStudio>();
                        plesso.setCorsi(corsi);
                        plessi.add(plesso);
                        meccanografco = plesso.getMeccanografico();
                    }
                    corsi.add(corso);
                }
                classe = new Classe(result.getInt("CLASSE.ID"), result.getString("CLASSE.CODICE"), result.getInt("CLASSE.ANNO_DI_CORSO"), result.getInt("CLASSE.LIVELLO"));
                classi.add(classe);
            }
        }
        catch (ConnectionException e) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new PlessoDaoException(e.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlessoDaoException("Impossibile recuoerare i plessi dal DB");
        }
        return plessi;
    }

    @Override
    public Collection<Plesso> getPlessiPopolatiConCorsiByIstitutoAndCorsi(String istituto, Collection<CorsoDiStudio> corsi) throws PlessoDaoException {
        HashMap<String, Plesso> plessi = new HashMap<String, Plesso>();
        LinkedList<CorsoDiStudio> corsiPerPlesso = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select distinct PLESSO.MECCANOGRAFICO, PLESSO.ISTITUTO, PLESSO.FORMAZIONE, CORSO_DI_STUDIO.ID\nfrom PLESSO\njoin CORSO_DI_STUDIO on CORSO_DI_STUDIO.PLESSO=PLESSO.MECCANOGRAFICO\nwhere PLESSO.ISTITUTO=? and CORSO_DI_STUDIO.ID=?\norder by PLESSO.MECCANOGRAFICO, CORSO_DI_STUDIO.ID");
            for (CorsoDiStudio corso : corsi) {
                stat.setString(1, istituto);
                stat.setInt(2, corso.getId());
                stat.execute();
                result = stat.getResultSet();
                Plesso nextPlesso = null;
                while (result.next()) {
                    if (plessi.get(result.getString("PLESSO.MECCANOGRAFICO")) == null) {
                        nextPlesso = new Plesso(result.getString("PLESSO.MECCANOGRAFICO"), result.getString("PLESSO.ISTITUTO"), result.getInt("PLESSO.FORMAZIONE"));
                        plessi.put(result.getString("PLESSO.MECCANOGRAFICO"), nextPlesso);
                        corsiPerPlesso = new LinkedList<CorsoDiStudio>();
                        plessi.put(result.getString("PLESSO.MECCANOGRAFICO"), nextPlesso);
                    }
                    corsiPerPlesso.add(corso);
                    corso.setPlesso(nextPlesso);
                }
            }
        }
        catch (ConnectionException e) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new PlessoDaoException(e.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlessoDaoException("Impossibile recuoerare i plessi dal DB");
        }
        return plessi.values();
    }

    @Override
    public List<String> getAllIstituti() throws PlessoDaoException {
        LinkedList<String> istituti = new LinkedList<String>();
        Connection conn = null;
        PreparedStatement stat = null;
        ResultSet result = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select distinct ISTITUTO from PLESSO order by ISTITUTO;");
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                istituti.add(result.getString(ISTITUTO));
            }
        }
        catch (ConnectionException e) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new PlessoDaoException(e.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(PlessoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlessoDaoException("Impossibile recuoerare i plessi dal DB");
        }
        return istituti;
    }
}

