/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.prove;

import invalsi.beans.prove.Fascicolo;
import invalsi.beans.prove.Strumento;
import invalsi.dao.interfaces.prove.IStrumentoDao;
import invalsi.dao.local.prove.AbstractLocalDao;
import invalsi.eccezioni.dao.prove.StrumentoDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StrumentoLocalDao
extends AbstractLocalDao
implements IStrumentoDao {
    public StrumentoLocalDao() throws StrumentoDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new StrumentoDaoException(ex.getMessage());
        }
    }

    @Override
    public List<Strumento> getStrumentiByLivello(int livello) throws StrumentoDaoException {
        LinkedList<Strumento> strumenti = new LinkedList<Strumento>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("SELECT STRUMENTO.ID, STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.ANNO, STRUMENTO.LIVELLO, STRUMENTO.TIPO \n\tFROM STRUMENTO JOIN MATERIA ON STRUMENTO.MATERIA=MATERIA.CODICE WHERE STRUMENTO.LIVELLO=?;");
            stat.setInt(1, livello);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                Strumento nextStrumento = new Strumento(result.getInt("STRUMENTO.ID"), result.getString("STRUMENTO.PROGETTO"), result.getString("STRUMENTO.ANNO"), result.getString("MATERIA.NOME"), result.getInt("STRUMENTO.LIVELLO"), result.getString("STRUMENTO.TIPO"));
                strumenti.add(nextStrumento);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare le Prove dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new StrumentoDaoException(ex.getMessage());
        }
        return strumenti;
    }

    @Override
    public Strumento getStrumento(String progetto, String anno, String materia, int livello, String tipo) throws StrumentoDaoException {
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Strumento prova = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("SELECT STRUMENTO.ID, STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.ANNO, STRUMENTO.LIVELLO, STRUMENTO.TIPO\nFROM STRUMENTO JOIN MATERIA ON STRUMENTO.MATERIA=MATERIA.CODICE JOIN TIPO_STRUMENTO ON STRUMENTO.TIPO=TIPO_STRUMENTO.NOME\nWHERE STRUMENTO.PROGETTO = ? AND\nMATERIA.NOME = ? AND\nSTRUMENTO.ANNO = ? AND\nSTRUMENTO.LIVELLO = ? AND\nSTRUMENTO.TIPO = ? ");
            stat.setString(1, progetto);
            stat.setString(2, materia);
            stat.setString(3, anno);
            stat.setInt(4, livello);
            stat.setString(5, tipo);
            stat.execute();
            result = stat.getResultSet();
            if (result.next()) {
                prova = new Strumento(result.getInt("STRUMENTO.ID"), result.getString("STRUMENTO.PROGETTO"), result.getString("STRUMENTO.ANNO"), result.getString("MATERIA.NOME"), result.getInt("STRUMENTO.LIVELLO"), result.getString("STRUMENTO.TIPO"));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare la Strumento dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new StrumentoDaoException(ex.getMessage());
        }
        return prova;
    }

    @Override
    public List<Strumento> getStrumentiWithFascicoli() throws StrumentoDaoException {
        LinkedList<Strumento> strumenti = new LinkedList<Strumento>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Strumento nextStrumento = null;
        Fascicolo nextFascicolo = null;
        LinkedList<Fascicolo> fascicoli = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select STRUMENTO.ID, STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.ANNO, STRUMENTO.LIVELLO, STRUMENTO.TIPO, FASCICOLO.SEQUENZIALE, FASCICOLO.DOMANDA, FASCICOLO.CODICE \nFROM FASCICOLO join STRUMENTO on FASCICOLO.STRUMENTO = STRUMENTO.ID join MATERIA ON STRUMENTO.MATERIA=MATERIA.CODICE\norder by STRUMENTO.ID, FASCICOLO.SEQUENZIALE;");
            stat.execute();
            result = stat.getResultSet();
            int provaId = 0;
            while (result.next()) {
                if (provaId != result.getInt("STRUMENTO.ID")) {
                    nextStrumento = new Strumento(result.getInt("STRUMENTO.ID"), result.getString("STRUMENTO.PROGETTO"), result.getString("STRUMENTO.ANNO"), result.getString("MATERIA.NOME"), result.getInt("STRUMENTO.LIVELLO"), result.getString("STRUMENTO.TIPO"));
                    strumenti.add(nextStrumento);
                    fascicoli = new LinkedList<Fascicolo>();
                    nextStrumento.setFascicoli(fascicoli);
                    provaId = result.getInt("STRUMENTO.ID");
                }
                nextFascicolo = new Fascicolo(result.getString("FASCICOLO.CODICE"), result.getInt("FASCICOLO.SEQUENZIALE"), result.getString("FASCICOLO.DOMANDA"));
                nextFascicolo.setStrumento(nextStrumento);
                fascicoli.add(nextFascicolo);
            }
            provaId = nextStrumento.getId();
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare le Prove dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new StrumentoDaoException(ex.getMessage());
        }
        return strumenti;
    }

    @Override
    public List<Strumento> getAllStrumenti() throws StrumentoDaoException {
        LinkedList<Strumento> strumenti = new LinkedList<Strumento>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Strumento nextStrumento = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select STRUMENTO.ID, STRUMENTO.PROGETTO, STRUMENTO.ANNO, MATERIA.NOME, STRUMENTO.LIVELLO, STRUMENTO.TIPO\nfrom STRUMENTO join MATERIA on STRUMENTO.MATERIA=MATERIA.CODICE\nORDER BY PROGETTO, ANNO, LIVELLO, MATERIA.NOME;");
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                nextStrumento = new Strumento(result.getInt("STRUMENTO.ID"), result.getString("STRUMENTO.PROGETTO"), result.getString("STRUMENTO.ANNO"), result.getString("MATERIA.NOME"), result.getInt("STRUMENTO.LIVELLO"), result.getString("STRUMENTO.TIPO"));
                strumenti.add(nextStrumento);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare le Prove dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new StrumentoDaoException(ex.getMessage());
        }
        return strumenti;
    }

    @Override
    public Strumento getStrumentoByProgettoMateriaLivelloTipoWithFascicoli(String progetto, String materia, int livello, String tipo) throws StrumentoDaoException {
        Strumento prova = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select STRUMENTO.ID, STRUMENTO.PROGETTO, STRUMENTO.ANNO, MATERIA.NOME, STRUMENTO.LIVELLO, STRUMENTO.TIPO, FASCICOLO.SEQUENZIALE, FASCICOLO.DOMANDA, FASCICOLO.CODICE\nfrom STRUMENTO JOIN FASCICOLO on STRUMENTO.ID = FASCICOLO.STRUMENTO join MATERIA on MATERIA.CODICE=STRUMENTO.MATERIA\nwhere STRUMENTO.PROGETTO=? and MATERIA.NOME=? and STRUMENTO.LIVELLO=? and STRUMENTO.TIPO=?\norder BY STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.LIVELLO, FASCICOlO.SEQUENZIALE;");
            stat.setString(1, progetto);
            stat.setString(2, materia);
            stat.setInt(3, livello);
            stat.setString(4, tipo);
            stat.execute();
            result = stat.getResultSet();
            if (result.next()) {
                prova = new Strumento(result.getInt("STRUMENTO.ID"), result.getString("STRUMENTO.PROGETTO"), result.getString("STRUMENTO.ANNO"), result.getString("MATERIA.NOME"), result.getInt("STRUMENTO.LIVELLO"), result.getString("STRUMENTO.TIPO"));
                Fascicolo fascicolo = new Fascicolo(result.getString("FASCICOLO.CODICE"), result.getInt("FASCICOLO.SEQUENZIALE"), result.getString("FASCICOLO.DOMANDA"));
                fascicolo.setStrumento(prova);
                LinkedList<Fascicolo> fascicoli = new LinkedList<Fascicolo>();
                fascicoli.add(fascicolo);
                prova.setFascicoli(fascicoli);
                while (result.next()) {
                    fascicolo = new Fascicolo(result.getString("FASCICOLO.CODICE"), result.getInt("FASCICOLO.SEQUENZIALE"), result.getString("FASCICOLO.DOMANDA"));
                    fascicoli.add(fascicolo);
                }
            }
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare la Strumento dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new StrumentoDaoException(ex.getMessage());
        }
        return prova;
    }

    @Override
    public void strumentoCompilatoDallAlunno(int idAlunno, int idStrumento, int sequenzialeFascicolo, boolean isQuestionario, String valore, Connection conn) throws StrumentoDaoException {
        PreparedStatement stat_delete = null;
        PreparedStatement stat_salva = null;
        try {
            if (isQuestionario) {
                stat_delete = conn.prepareStatement("delete from COMPILA_QUESTIONARIO where ALUNNO=? AND STRUMENTO=?;");
                stat_salva = conn.prepareStatement("insert into COMPILA_QUESTIONARIO(ALUNNO,STRUMENTO,FASCICOLO,VALORE) values (?,?,?,?);");
            } else {
                stat_delete = conn.prepareStatement("delete from SVOLGE_PROVA where ALUNNO=? AND STRUMENTO=?;");
                stat_salva = conn.prepareStatement("insert into SVOLGE_PROVA(ALUNNO,STRUMENTO,FASCICOLO,VALORE) values (?,?,?,?);");
            }
            stat_delete.setInt(1, idAlunno);
            stat_delete.setInt(2, idStrumento);
            stat_delete.execute();
            stat_salva.setInt(1, idAlunno);
            stat_salva.setInt(2, idStrumento);
            if (sequenzialeFascicolo <= 0) {
                stat_salva.setNull(3, 4);
            } else {
                stat_salva.setInt(3, sequenzialeFascicolo);
            }
            stat_salva.setString(4, valore);
            stat_salva.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel salvare l'informazione");
        }
    }

    @Override
    public void salvaPunteggioDellAlunnoPerLaProva(int idAlunno, int idStrumento, int punteggioStrumento, String tempoExtra, Connection conn) throws StrumentoDaoException {
        PreparedStatement stat_cancella_punteggio = null;
        PreparedStatement stat_salva_punteggio = null;
        try {
            stat_cancella_punteggio = conn.prepareStatement("delete from ESITO_PROVA where ESITO_PROVA.ALUNNO=? AND ESITO_PROVA.STRUMENTO=?;");
            stat_salva_punteggio = conn.prepareStatement("insert into ESITO_PROVA(ALUNNO,STRUMENTO,VALORE,TEMPO_AGGIUNTIVO ) values (?,?,?,select TEMPO_AGGIUNTIVO.ID from TEMPO_AGGIUNTIVO where TEMPO_AGGIUNTIVO.VALORE=?);");
            stat_cancella_punteggio.setInt(1, idAlunno);
            stat_cancella_punteggio.setInt(2, idStrumento);
            stat_salva_punteggio.setInt(1, idAlunno);
            stat_salva_punteggio.setInt(2, idStrumento);
            stat_salva_punteggio.setInt(3, punteggioStrumento);
            stat_salva_punteggio.setString(4, tempoExtra);
            stat_cancella_punteggio.execute();
            stat_salva_punteggio.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel salvare l'esito della prova nel DB");
        }
    }

    @Override
    public Map<String, Integer> getPunteggiProve(int idAlunno, Connection conn) throws StrumentoDaoException {
        HashMap<String, Integer> punteggi = new HashMap<String, Integer>();
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            stat = conn.prepareStatement("select STRUMENTO.ID, STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.ANNO, STRUMENTO.LIVELLO, STRUMENTO.TIPO,\n\t  ESITO_PROVA.VALORE\nfrom STRUMENTO join ESITO_PROVA on STRUMENTO.ID = ESITO_PROVA.STRUMENTO\n           join MATERIA on MATERIA.CODICE =  STRUMENTO.MATERIA\nwhere ESITO_PROVA.ALUNNO = ?;");
            stat.setInt(1, idAlunno);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                String materia = result.getString("MATERIA.NOME");
                int punteggio = result.getInt("ESITO_STRUMENTO.VALORE");
                if (materia.equals("Italiano")) {
                    punteggi.put(materia, punteggio);
                    continue;
                }
                if (!materia.equals("Matematica")) continue;
                punteggi.put(materia, punteggio);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare i Bocchi di correzione!");
        }
        return punteggi;
    }

    @Override
    public void salvaVotoInvalsiAlunno(int idAlunno, String voto, Connection conn) throws StrumentoDaoException {
        PreparedStatement stat_salva = null;
        try {
            stat_salva = conn.prepareStatement("update ESAME_ALUNNO set VOTO_INVALSI=\n(select VOTO_ESAME.ID from VOTO_ESAME where VOTO_ESAME.VALORE= ?) \n where ALUNNO=?;");
            stat_salva.setString(1, voto);
            stat_salva.setInt(2, idAlunno);
            stat_salva.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare la Strumento dal DB");
        }
    }

    @Override
    public void deleteEsitoProvaAlunno(int idAlunno, int idStrumento, Connection conn) throws StrumentoDaoException {
        PreparedStatement stat_cancella = null;
        PreparedStatement stat_crea_vuoto = null;
        try {
            stat_cancella = conn.prepareStatement("delete from ESITO_PROVA where ESITO_PROVA.ALUNNO=? AND ESITO_PROVA.STRUMENTO=?;");
            stat_crea_vuoto = conn.prepareStatement("insert into ESITO_PROVA (ALUNNO,STRUMENTO) values (?,?);");
            stat_cancella.setInt(1, idAlunno);
            stat_cancella.setInt(2, idStrumento);
            stat_crea_vuoto.setInt(1, idAlunno);
            stat_crea_vuoto.setInt(2, idStrumento);
            stat_cancella.execute();
            stat_crea_vuoto.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare la Strumento dal DB");
        }
    }

    @Override
    public void setQuestionarioCompilato(int idAlunno, int idStrumento, String valore, Connection conn) throws StrumentoDaoException {
        PreparedStatement stat_cancella = null;
        PreparedStatement stat_salva = null;
        try {
            stat_cancella = conn.prepareStatement("delete from COMPILA_QUESTIONARIO where ALUNNO=? AND STRUMENTO=?;");
            stat_cancella.setInt(1, idAlunno);
            stat_cancella.setInt(2, idStrumento);
            stat_cancella.executeUpdate();
            stat_cancella.execute();
            stat_salva = conn.prepareStatement("insert into COMPILA_QUESTIONARIO(ALUNNO,STRUMENTO,FASCICOLO,VALORE) values (?,?,?,?);");
            stat_salva.setInt(1, idAlunno);
            stat_salva.setInt(2, idStrumento);
            stat_salva.setInt(3, 1);
            stat_salva.setString(4, valore);
            stat_salva.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(StrumentoLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new StrumentoDaoException("Errore nel recuperare il Questionario dal DB");
        }
    }
}

