/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.prove;

import invalsi.beans.prove.Item;
import invalsi.beans.prove.ItemRisposto;
import invalsi.dao.interfaces.prove.IItemDao;
import invalsi.dao.local.prove.AbstractLocalDao;
import invalsi.eccezioni.dao.prove.ItemDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ItemLocalDao
extends AbstractLocalDao
implements IItemDao {
    private Object ex;

    public ItemLocalDao() throws ItemDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ItemDaoException(ex.getMessage());
        }
    }

    @Override
    public List<Item> getItemsByFascicolo(int idStrumento, int sequenzialeFascicolo) throws ItemDaoException {
        LinkedList<Item> items = new LinkedList<Item>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Item nextItem = null;
        LinkedList<String> listaRisposteItem = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select ITEM.STRUMENTO, ITEM.FASCICOLO, ITEM.POSIZIONE,ITEM.ETICHETTA, ITEM.CODICE_FORTE, ITEM.ALTERNATIVE_DI_RISPOSTA, ITEM.ID, ITEM.RISPOSTA_CORRETTA, ITEM.GRUPPO, TIPO_DOMANDA.NOME\n            \tfrom ITEM join TIPO_DOMANDA on ITEM.TIPO_DOMANDA=TIPO_DOMANDA.CODICE\n            where ITEM.STRUMENTO=? AND ITEM.FASCICOLO=?\n            order by ITEM.POSIZIONE;");
            stat.setInt(1, idStrumento);
            stat.setInt(2, sequenzialeFascicolo);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                listaRisposteItem = new LinkedList<String>();
                String stringRisposte = result.getString("ITEM.ALTERNATIVE_DI_RISPOSTA");
                listaRisposteItem.addAll(Arrays.asList(stringRisposte.split("\\;")));
                nextItem = new Item(result.getInt("ITEM.ID"), result.getInt("ITEM.POSIZIONE"), result.getString("ITEM.ETICHETTA"), result.getString("ITEM.CODICE_FORTE"), listaRisposteItem, result.getString("ITEM.RISPOSTA_CORRETTA"), result.getInt("ITEM.GRUPPO"), result.getString("TIPO_DOMANDA.NOME"));
                listaRisposteItem = new LinkedList();
                items.add(nextItem);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ItemDaoException("Errore nel recuperare i Fascicoli dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ItemDaoException(ex.getMessage());
        }
        return items;
    }

    @Override
    public void salvaRisposteAlunnoItems(int idAlunno, List<ItemRisposto> itemsConRisposte, Connection conn) throws ItemDaoException {
        PreparedStatement stat = null;
        try {
            stat = conn.prepareStatement("insert into RISPOSTA_ITEM (ALUNNO, ITEM, RISPOSTA) values (?,?,?);");
            for (ItemRisposto item : itemsConRisposte) {
                stat.setInt(1, idAlunno);
                stat.setInt(2, item.getId());
                stat.setString(3, item.getRispostaScelta());
                stat.execute();
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ItemDaoException("Errore nel salvare le risposte");
        }
    }

    @Override
    public void cancellaRisposteAlunno(int idAlunno, int idStrumento, boolean isProva, Connection conn) throws ItemDaoException {
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("delete RISPOSTA_ITEM where ALUNNO=? and ITEM IN (SELECT ITEM.ID from ITEM WHERE STRUMENTO=?);");
            stat.setInt(1, idAlunno);
            stat.setInt(2, idStrumento);
            stat.execute();
        }
        catch (SQLException e) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ItemDaoException("Errore nel recuperare i Fascicoli dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ItemDaoException(ex.getMessage());
        }
    }

    @Override
    public Map<Integer, String> getRisposteByStrumentoFascicoloAndAlunno(int idStrumento, int sequenzialeFascicolo, int idAlunno) throws ItemDaoException {
        HashMap<Integer, String> etichetteItemRisposte = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        etichetteItemRisposte = new HashMap<Integer, String>();
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select ITEM.ID, ITEM.POSIZIONE, ITEM.ETICHETTA, RISPOSTA_ITEM.ALUNNO, RISPOSTA_ITEM.RISPOSTA\nfrom ITEM \n\tjoin RISPOSTA_ITEM on ITEM.ID = RISPOSTA_ITEM.ITEM\nwhere ITEM.STRUMENTO=? AND ITEM.FASCICOLO=? AND RISPOSTA_ITEM.ALUNNO=?\norder by ITEM.POSIZIONE;");
            stat.setInt(1, idStrumento);
            stat.setInt(2, sequenzialeFascicolo);
            stat.setInt(3, idAlunno);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                etichetteItemRisposte.put(result.getInt("ITEM.ID"), result.getString("RISPOSTA_ITEM.RISPOSTA"));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ItemDaoException("Errore nel recuperare i Fascicoli dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ItemDaoException(ex.getMessage());
        }
        return etichetteItemRisposte;
    }

    @Override
    public List<Item> getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(int livello, String materia, String tipo, int sequenzialeFascicolo) throws ItemDaoException {
        LinkedList<Item> items = new LinkedList<Item>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Item nextItem = null;
        ArrayList<String> listaRisposteItem = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select distinct ITEM.ID, ITEM.POSIZIONE, ITEM.ETICHETTA, ITEM.CODICE_FORTE, ITEM.ALTERNATIVE_DI_RISPOSTA, ITEM.RISPOSTA_CORRETTA, ITEM.GRUPPO, TIPO_DOMANDA.NOME\n\tfrom \tITEM\n\t\tjoin FASCICOLO on ITEM.FASCICOLO = FASCICOLO.SEQUENZIALE and ITEM.STRUMENTO = FASCICOLO.STRUMENTO\n\t\tjoin STRUMENTO on ITEM.STRUMENTO = STRUMENTO.ID\n\t\tjoin MATERIA on MATERIA.CODICE = STRUMENTO.MATERIA\n         join TIPO_DOMANDA on ITEM.TIPO_DOMANDA=TIPO_DOMANDA.CODICE\nwhere STRUMENTO.LIVELLO=? and MATERIA.NOME = ? and STRUMENTO.TIPO = ? and FASCICOLO.SEQUENZIALE=?  \norder by ITEM.POSIZIONE;\t");
            stat.setInt(1, livello);
            stat.setString(2, materia);
            stat.setString(3, tipo);
            stat.setInt(4, sequenzialeFascicolo);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                String stringRisposte = result.getString("ITEM.ALTERNATIVE_DI_RISPOSTA");
                listaRisposteItem = new ArrayList<String>();
                listaRisposteItem.addAll(Arrays.asList(stringRisposte.split("\\;")));
                nextItem = new Item(result.getInt("ITEM.ID"), result.getInt("ITEM.POSIZIONE"), result.getString("ITEM.ETICHETTA"), result.getString("ITEM.CODICE_FORTE"), listaRisposteItem, result.getString("ITEM.RISPOSTA_CORRETTA"), result.getInt("ITEM.GRUPPO"), result.getString("TIPO_DOMANDA.NOME"));
                items.add(nextItem);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ItemDaoException("Errore nel recuperare gli Items");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ItemDaoException(ex.getMessage());
        }
        return items;
    }

    @Override
    public List<ItemRisposto> getItemsWithRisposteByStrumentoAndAlunno(int idStrumento, int idAlunno) throws ItemDaoException {
        LinkedList<ItemRisposto> items = new LinkedList<ItemRisposto>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        ItemRisposto nextItem = null;
        LinkedList<String> listaRisposteItem = null;
        boolean isProva = false;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select ITEM.STRUMENTO, ITEM.FASCICOLO, ITEM.POSIZIONE,ITEM.ETICHETTA, ITEM.CODICE_FORTE, \n            ITEM.ALTERNATIVE_DI_RISPOSTA, ITEM.ID, ITEM.RISPOSTA_CORRETTA, ITEM.GRUPPO,\n            RISPOSTA_ITEM.RISPOSTA, TIPO_DOMANDA.NOME\nfrom ITEM \njoin RISPOSTA_ITEM on ITEM.ID=RISPOSTA_ITEM.ITEM\njoin TIPO_DOMANDA on ITEM.TIPO_DOMANDA=TIPO_DOMANDA.CODICE \nwhere ITEM.STRUMENTO=? AND RISPOSTA_ITEM.ALUNNO=?\norder by ITEM.STRUMENTO, ITEM.FASCICOLO, ITEM.POSIZIONE;");
            isProva = true;
            stat.setInt(1, idStrumento);
            stat.setInt(2, idAlunno);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                String stringRisposte;
                listaRisposteItem = new LinkedList<String>();
                if (isProva) {
                    listaRisposteItem = new LinkedList();
                    stringRisposte = result.getString("ITEM.ALTERNATIVE_DI_RISPOSTA");
                    listaRisposteItem.addAll(Arrays.asList(stringRisposte.split("\\;")));
                    nextItem = new ItemRisposto(result.getInt("ITEM.ID"), result.getInt("ITEM.POSIZIONE"), result.getString("ITEM.ETICHETTA"), result.getString("ITEM.CODICE_FORTE"), listaRisposteItem, result.getString("ITEM.RISPOSTA_CORRETTA"), result.getString("RISPOSTA_ITEM.RISPOSTA"), result.getInt("ITEM.GRUPPO"), result.getString("TIPO_DOMANDA.NOME"));
                } else {
                    stringRisposte = result.getString("ITEM.ALTERNATIVE_DI_RISPOSTA");
                    listaRisposteItem.addAll(Arrays.asList(stringRisposte.split("\\;")));
                    nextItem = new ItemRisposto(result.getInt("ITEM.ID"), result.getInt("ITEM.POSIZIONE"), result.getString("ITEM.ETICHETTA"), "NA", listaRisposteItem, "NA", result.getString("ITEM.RISPOSTA"), 0);
                }
                items.add(nextItem);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new ItemDaoException("Errore nel recuperare i Fascicoli dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(ItemLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ItemDaoException(ex.getMessage());
        }
        return items;
    }
}

