/*
 * Decompiled with CFR 0.152.
 */
package invalsi.dao.local.prove;

import invalsi.beans.prove.Fascicolo;
import invalsi.beans.prove.FascicoloCompilato;
import invalsi.beans.prove.ItemRisposto;
import invalsi.beans.prove.Strumento;
import invalsi.dao.interfaces.prove.IFascicoloDao;
import invalsi.dao.local.prove.AbstractLocalDao;
import invalsi.eccezioni.dao.prove.FascicoloDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FascicoloLocalDao
extends AbstractLocalDao
implements IFascicoloDao {
    public FascicoloLocalDao() throws FascicoloDaoException {
        try {
            this.connMgr = ConnectionMgr.getIstance();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new FascicoloDaoException(ex.getMessage());
        }
    }

    @Override
    public List<Fascicolo> getFascicoliByStrumento(int provaId) throws FascicoloDaoException {
        LinkedList<Fascicolo> fascicoli = new LinkedList<Fascicolo>();
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        Fascicolo nextFascicolo = null;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("SELECT CODICE, SEQUENZIALE, DOMANDA FROM FASCICOLO WHERE  STRUMENTO=? order by SEQUENZIALE;");
            stat.setInt(1, provaId);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                nextFascicolo = new Fascicolo(result.getString("CODICE"), result.getInt("SEQUENZIALE"), result.getString("DOMANDA"));
                fascicoli.add(nextFascicolo);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new FascicoloDaoException("Errore nel recuperare i Fascicoli dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new FascicoloDaoException(ex.getMessage());
        }
        return fascicoli;
    }

    @Override
    public Fascicolo getFascicoloByStrumentoAndAlunno(int idStrumento, int idAlunno, boolean isQuestionario) throws FascicoloDaoException {
        Fascicolo fascicolo = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        try {
            conn = this.connMgr.getConnection();
            stat = isQuestionario ? conn.prepareStatement("select distinct FASCICOLO.STRUMENTO, FASCICOLO.SEQUENZIALE, FASCICOLO.CODICE, FASCICOLO.DOMANDA \nfrom FASCICOLO \njoin COMPILA_QUESTIONARIO on FASCICOLO.STRUMENTO=COMPILA_QUESTIONARIO.STRUMENTO AND FASCICOLO.SEQUENZIALE=COMPILA_QUESTIONARIO.FASCICOLO\nwhere FASCICOLO.STRUMENTO=? AND COMPILA_QUESTIONARIO.ALUNNO=? ;") : conn.prepareStatement("select distinct FASCICOLO.STRUMENTO, FASCICOLO.SEQUENZIALE, FASCICOLO.CODICE, FASCICOLO.DOMANDA \nfrom FASCICOLO \n\tjoin SVOLGE_PROVA on FASCICOLO.STRUMENTO=SVOLGE_PROVA.STRUMENTO AND FASCICOLO.SEQUENZIALE=SVOLGE_PROVA.FASCICOLO\nwhere FASCICOLO.STRUMENTO=? AND SVOLGE_PROVA.ALUNNO=? ;");
            stat.setInt(1, idStrumento);
            stat.setInt(2, idAlunno);
            stat.execute();
            result = stat.getResultSet();
            if (result.next()) {
                fascicolo = new Fascicolo(result.getString("FASCICOLO.CODICE"), result.getInt("FASCICOLO.SEQUENZIALE"), result.getString("FASCICOLO.DOMANDA"));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new FascicoloDaoException("Errore nel recuperare il Fascicolo dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new FascicoloDaoException(ex.getMessage());
        }
        return fascicolo;
    }

    @Override
    public List<FascicoloCompilato> getFascicoliByAlunnoValutato(int idAlunno) throws FascicoloDaoException {
        LinkedList<ItemRisposto> items = null;
        LinkedList<FascicoloCompilato> fascicoli = new LinkedList<FascicoloCompilato>();
        ItemRisposto item = null;
        Connection conn = null;
        ResultSet result = null;
        PreparedStatement stat = null;
        int prova = 0;
        boolean questionario = false;
        try {
            conn = this.connMgr.getConnection();
            stat = conn.prepareStatement("select distinct RISPOSTA_ITEM.ALUNNO, RISPOSTA_ITEM.ITEM, RISPOSTA_ITEM.RISPOSTA,\n\t\t\t ITEM.POSIZIONE, ITEM.ETICHETTA, ITEM.CODICE_FORTE,\n\t\t\t ITEM.FASCICOLO, FASCICOLO.DOMANDA, FASCICOLO.CODICE,\n\t\t\t ITEM.ALTERNATIVE_DI_RISPOSTA, ITEM.RISPOSTA_CORRETTA, ITEM.GRUPPO,\n                  TIPO_DOMANDA.NOME,\n\t\t\t FASCICOLO.STRUMENTO, STRUMENTO.PROGETTO, MATERIA.NOME, STRUMENTO.ANNO, STRUMENTO.LIVELLO, STRUMENTO.TIPO\n                        \n\tfrom \tRISPOSTA_ITEM \n          join ALUNNO on ALUNNO.ID = RISPOSTA_ITEM.ALUNNO\n          join ITEM on ITEM.ID = RISPOSTA_ITEM.ITEM\n          join TIPO_DOMANDA on ITEM.TIPO_DOMANDA=TIPO_DOMANDA.CODICE\n          join FASCICOLO on FASCICOLO.STRUMENTO = ITEM.STRUMENTO and FASCICOLO.SEQUENZIALE=ITEM.FASCICOLO\n          join STRUMENTO on STRUMENTO.ID = FASCICOLO.STRUMENTO\n          join MATERIA on MATERIA.CODICE = STRUMENTO.MATERIA \n                        \nwhere ALUNNO.ID=?\norder by  MATERIA.NOME, STRUMENTO.TIPO,ITEM.POSIZIONE;");
            stat.setInt(1, idAlunno);
            stat.execute();
            result = stat.getResultSet();
            while (result.next()) {
                if (prova != result.getInt("FASCICOlO.STRUMENTO")) {
                    Strumento strumento = new Strumento(result.getInt("FASCICOLO.STRUMENTO"), result.getString("STRUMENTO.PROGETTO"), result.getString("STRUMENTO.ANNO"), result.getString("MATERIA.NOME"), result.getInt("STRUMENTO.LIVELLO"), result.getString("STRUMENTO.TIPO"));
                    FascicoloCompilato fascicolo = new FascicoloCompilato(strumento, result.getString("FASCICOLO.CODICE"), result.getInt("ITEM.FASCICOLO"), result.getString("FASCICOLO.DOMANDA"), items);
                    items = new LinkedList<ItemRisposto>();
                    fascicolo.setItemsConRisposte(items);
                    fascicoli.add(fascicolo);
                    prova = result.getInt("FASCICOlO.STRUMENTO");
                }
                LinkedList<String> risposte = new LinkedList<String>();
                String risposteString = result.getString("ITEM.ALTERNATIVE_DI_RISPOSTA");
                risposte.addAll(Arrays.asList(risposteString.split("\\;")));
                item = new ItemRisposto(result.getInt("RISPOSTA_ITEM.ITEM"), result.getInt("ITEM.POSIZIONE"), result.getString("ITEM.ETICHETTA"), result.getString("ITEM.CODICE_FORTE"), risposte, result.getString("ITEM.RISPOSTA_CORRETTA"), result.getString("RISPOSTA_ITEM.RISPOSTA"), result.getInt("ITEM.GRUPPO"), result.getString("TIPO_DOMANDA.NOME"));
                items.add(item);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, e);
            throw new FascicoloDaoException("Errore nel recuperare i Fascicoli dal DB");
        }
        catch (ConnectionException ex) {
            Logger.getLogger(FascicoloLocalDao.class.getName()).log(Level.SEVERE, null, ex);
            throw new FascicoloDaoException(ex.getMessage());
        }
        return fascicoli;
    }
}

