/*
 * Decompiled with CFR 0.152.
 */
package invalsi.business.prove.impl;

import invalsi.beans.alunni.Alunno;
import invalsi.beans.alunni.AlunnoEsaminato;
import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.prove.Fascicolo;
import invalsi.beans.prove.FascicoloCompilato;
import invalsi.beans.prove.Item;
import invalsi.beans.prove.ItemRisposto;
import invalsi.beans.prove.Strumento;
import invalsi.beans.prove.correzione.BloccoDiCorrezione;
import invalsi.beans.prove.correzione.Gruppo;
import invalsi.beans.prove.correzione.Range;
import invalsi.business.alunni.IAlunniMgt;
import invalsi.business.alunni.impl.AlunniMgr;
import invalsi.business.prove.IProveMgt;
import invalsi.dao.interfaces.prove.IFascicoloDao;
import invalsi.dao.interfaces.prove.IItemDao;
import invalsi.dao.interfaces.prove.IStrumentoDao;
import invalsi.dao.interfaces.prove.correzione.IBloccoDiCorrezioneDao;
import invalsi.dao.local.prove.FascicoloLocalDao;
import invalsi.dao.local.prove.ItemLocalDao;
import invalsi.dao.local.prove.StrumentoLocalDao;
import invalsi.dao.local.prove.correzione.BloccoDiCorrezioneLocalDao;
import invalsi.eccezioni.business.alunni.AlunniMgtException;
import invalsi.eccezioni.business.prove.ProveMgtException;
import invalsi.eccezioni.dao.prove.FascicoloDaoException;
import invalsi.eccezioni.dao.prove.ItemDaoException;
import invalsi.eccezioni.dao.prove.StrumentoDaoException;
import invalsi.eccezioni.prove.correzione.BloccoDiCorrezioneDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProveMgr
implements IProveMgt {
    private static volatile IProveMgt myIstance = null;
    private IAlunniMgt alunniMgr;
    private final IStrumentoDao strumentoDao;
    private final IFascicoloDao fascicoloDao;
    private final IItemDao itemDao;
    private final IBloccoDiCorrezioneDao bloccoDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProveMgt getIstance() throws ProveMgtException {
        if (myIstance != null) return myIstance;
        Class<ProveMgr> clazz = ProveMgr.class;
        synchronized (ProveMgr.class) {
            if (myIstance != null) return myIstance;
            myIstance = new ProveMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myIstance;
        }
    }

    private ProveMgr() throws ProveMgtException {
        try {
            this.alunniMgr = AlunniMgr.getIstance();
            this.strumentoDao = new StrumentoLocalDao();
            this.fascicoloDao = new FascicoloLocalDao();
            this.itemDao = new ItemLocalDao();
            this.bloccoDao = new BloccoDiCorrezioneLocalDao();
        }
        catch (AlunniMgtException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        catch (FascicoloDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        catch (BloccoDiCorrezioneDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
    }

    @Override
    public Fascicolo getFascicoloByCodice(String codice) throws ProveMgtException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Fascicolo> getFascicoliByStrumento(int idStrumento) throws ProveMgtException {
        List<Fascicolo> fascicoli = null;
        try {
            fascicoli = this.fascicoloDao.getFascicoliByStrumento(idStrumento);
        }
        catch (FascicoloDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        return fascicoli;
    }

    @Override
    public List<Item> getItemsByFascicolo(int idStrumento, int sequenzialeFascicolo) throws ProveMgtException {
        List<Item> items = null;
        try {
            items = this.itemDao.getItemsByFascicolo(idStrumento, sequenzialeFascicolo);
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Items non trovati");
        }
        return items;
    }

    @Override
    public List<Strumento> getAllStrumnetiWithFascicoli() throws ProveMgtException {
        List<Strumento> proveConFascicoli = null;
        try {
            proveConFascicoli = this.strumentoDao.getStrumentiWithFascicoli();
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Impossibile recuerare la lista degli strumenti");
        }
        return proveConFascicoli;
    }

    @Override
    public List<Strumento> getAllStrumenti() throws ProveMgtException {
        List<Strumento> strumenti = null;
        try {
            strumenti = this.strumentoDao.getAllStrumenti();
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Strumenti non trvati");
        }
        return strumenti;
    }

    @Override
    public Strumento getStrumentoWithFascicoli(String progetto, String materia, int livello, String tipo) throws ProveMgtException {
        Strumento prova = null;
        try {
            prova = this.strumentoDao.getStrumentoByProgettoMateriaLivelloTipoWithFascicoli(progetto, materia, livello, tipo);
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Impossibile recuperare i fascicoli per lo strumento selezionato");
        }
        return prova;
    }

    @Override
    public Fascicolo getFascicoloByStrumentoAndAlunno(Strumento strumento, Alunno alunno) throws ProveMgtException {
        Fascicolo fascicolo = null;
        int idStrumento = strumento.getId();
        int idAlunno = alunno.getId();
        boolean isQuestionario = false;
        try {
            if (strumento.getTipo().substring(0, 3).equals("QST")) {
                isQuestionario = true;
            }
            fascicolo = this.fascicoloDao.getFascicoloByStrumentoAndAlunno(idStrumento, idAlunno, isQuestionario);
        }
        catch (FascicoloDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Fascicolo non trovato");
        }
        return fascicolo;
    }

    @Override
    public Map<Integer, String> getRisposteByFascicoloAndAlunno(Fascicolo fascicolo, Alunno alunno) throws ProveMgtException {
        int idStrumento = fascicolo.getStrumento().getId();
        int sequenzialeFascicolo = fascicolo.getSequenziale();
        int idAlunno = alunno.getId();
        Map<Integer, String> etichetteItemsRisposte = null;
        try {
            etichetteItemsRisposte = this.itemDao.getRisposteByStrumentoFascicoloAndAlunno(idStrumento, sequenzialeFascicolo, idAlunno);
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Fascicolo non trovato");
        }
        return etichetteItemsRisposte;
    }

    @Override
    public List<Strumento> getStrumentiByLivello(int livello) throws ProveMgtException {
        List<Strumento> strumenti = null;
        try {
            strumenti = this.strumentoDao.getStrumentiByLivello(livello);
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Strumenti non trvati");
        }
        return strumenti;
    }

    private void setStrumentoNonCompilatoDallAlunno(Alunno alunno, Strumento strumento, String motivo, Connection conn) throws ProveMgtException {
        try {
            this.cancellaRisposteAlunno(alunno, strumento.getId(), conn);
            Fascicolo fascicolo = new Fascicolo(null, -2, null);
            fascicolo.setStrumento(strumento);
            boolean isQestionario = false;
            if (strumento.getTipo().substring(0, 3).equals("QST")) {
                isQestionario = true;
            }
            this.strumentoDao.strumentoCompilatoDallAlunno(alunno.getId(), fascicolo.getStrumento().getId(), fascicolo.getSequenziale(), isQestionario, motivo, conn);
            if (strumento.getLivello() == 8 && motivo.equals("NON svolge la prova standard o ASSENTE")) {
                this.strumentoDao.deleteEsitoProvaAlunno(alunno.getId(), strumento.getId(), conn);
                this.strumentoDao.salvaVotoInvalsiAlunno(alunno.getId(), "", conn);
            }
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            try {
                conn.rollback();
                conn.setAutoCommit(true);
                conn.setTransactionIsolation(2);
            }
            catch (Exception ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            throw new ProveMgtException(ex.getMessage());
        }
    }

    private void strumentoCompilatoDallAlunno(Alunno alunno, Fascicolo fascicolo, List<ItemRisposto> itemsConRisposte, String tipoCompilazione, String tempoExtra, Connection conn) throws ProveMgtException {
        try {
            boolean isQestionario = false;
            if (fascicolo.getStrumento().getTipo().substring(0, 3).equals("QST")) {
                isQestionario = true;
            }
            this.strumentoDao.strumentoCompilatoDallAlunno(alunno.getId(), fascicolo.getStrumento().getId(), fascicolo.getSequenziale(), isQestionario, tipoCompilazione, conn);
            this.cancellaRisposteAlunno(alunno, fascicolo.getStrumento().getId(), conn);
            this.itemDao.salvaRisposteAlunnoItems(alunno.getId(), itemsConRisposte, conn);
            if (fascicolo.getStrumento().getLivello() == 8) {
                AlunnoEsaminato alunnoEsaminato = (AlunnoEsaminato)alunno;
                int punteggioProva = 0;
                int punteggioBlocco = 0;
                int punteggioGruppo = 0;
                int voto = 0;
                int sommaPunteggio = 0;
                List<BloccoDiCorrezione> blocchi = this.bloccoDao.getBlocchiDiItemConRisposte(alunnoEsaminato.getId(), fascicolo.getStrumento().getId(), fascicolo.getSequenziale());
                for (BloccoDiCorrezione blocco : blocchi) {
                    for (Gruppo gruppo : blocco.getGruppi()) {
                        float fattoreDiCorrezione = gruppo.getFattoreDiCorrezione();
                        if (fattoreDiCorrezione == 0.0f) {
                            for (ItemRisposto item : gruppo.getItems()) {
                                if (!item.getRispostaCorretta().equals(item.getRispostaScelta())) continue;
                                ++punteggioGruppo;
                            }
                        } else {
                            int risposteCorrettePerGruppo = 0;
                            for (ItemRisposto item : gruppo.getItems()) {
                                if (!item.getRispostaCorretta().equals(item.getRispostaScelta())) continue;
                                ++risposteCorrettePerGruppo;
                            }
                            if ((float)risposteCorrettePerGruppo >= fattoreDiCorrezione * (float)gruppo.getItems().size()) {
                                ++punteggioGruppo;
                            }
                        }
                        punteggioBlocco += punteggioGruppo;
                        punteggioGruppo = 0;
                    }
                    for (Range range : blocco.getRanges()) {
                        if (punteggioBlocco > range.getMax()) continue;
                        blocco.setPunteggioNormalizzato(range.getPunteggio());
                        break;
                    }
                    punteggioProva += blocco.getPunteggioNormalizzato();
                    punteggioBlocco = 0;
                }
                this.strumentoDao.salvaPunteggioDellAlunnoPerLaProva(alunno.getId(), fascicolo.getStrumento().getId(), punteggioProva, tempoExtra, conn);
                if (fascicolo.getStrumento().getMateria().equals("Italiano")) {
                    alunnoEsaminato.setPunteggioItaliano(punteggioProva);
                } else if (fascicolo.getStrumento().getMateria().equals("Matematica")) {
                    alunnoEsaminato.setPunteggioMatematica(punteggioProva);
                }
                sommaPunteggio = alunnoEsaminato.getPunteggioItaliano() + alunnoEsaminato.getPunteggioMatematica();
                if (sommaPunteggio >= 0) {
                    voto = sommaPunteggio <= 40 ? 4 : (sommaPunteggio <= 54 ? 5 : (sommaPunteggio <= 64 ? 6 : (sommaPunteggio <= 73 ? 7 : (sommaPunteggio <= 82 ? 8 : (sommaPunteggio <= 91 ? 9 : 10)))));
                    this.strumentoDao.salvaVotoInvalsiAlunno(alunno.getId(), Integer.toString(voto), conn);
                    alunnoEsaminato.setVotoInvalsi(Integer.toString(voto));
                }
            }
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        catch (StrumentoDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        catch (BloccoDiCorrezioneDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
    }

    private void cancellaRisposteAlunno(Alunno alunno, int idStrumento, Connection conn) throws ProveMgtException {
        boolean isProva = false;
        try {
            this.itemDao.cancellaRisposteAlunno(alunno.getId(), idStrumento, isProva, conn);
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Impossibile eliminare le vecchie risposte");
        }
    }

    private void cancellaTuttiIFile(File cartella) {
        File[] files;
        for (File file : files = cartella.listFiles()) {
            file.delete();
        }
    }

    @Override
    public List<ItemRisposto> getItemsWithRisposteByStrumentoAndAlunno(int idStrumento, Alunno alunno) throws ProveMgtException {
        List<ItemRisposto> items = null;
        try {
            items = this.itemDao.getItemsWithRisposteByStrumentoAndAlunno(idStrumento, alunno.getId());
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Items non trovati");
        }
        return items;
    }

    @Override
    public List<Item> getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(int livello, String materia, String tipoProva, int sequenzialeFascicolo) throws ProveMgtException {
        List<Item> items = null;
        try {
            items = this.itemDao.getItemsByLivelloMateriaTipoAndSequenzialeFascicolo(livello, materia, tipoProva, sequenzialeFascicolo);
        }
        catch (ItemDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Items non trovati");
        }
        return items;
    }

    @Override
    public List<FascicoloCompilato> getFascicoliByAlunnoValutato(AlunnoValutato alunno) throws ProveMgtException {
        List<FascicoloCompilato> fascicoli = null;
        try {
            fascicoli = this.fascicoloDao.getFascicoliByAlunnoValutato(alunno.getId());
            alunno.setFascicoliCompilati(fascicoli);
        }
        catch (FascicoloDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException("Items non trovati");
        }
        return fascicoli;
    }

    @Override
    public boolean salvaProvaAlunno(Alunno alunno, Fascicolo fascicolo, String svolgeProva, List<ItemRisposto> itemsConRisposte, String tempoExtra) throws ProveMgtException {
        boolean fatto = false;
        List<Strumento> strumenti = null;
        Strumento strumentoSelezionato = null;
        try {
            try {
                ConnectionMgr.getIstance().resetConnection();
            }
            catch (Exception e) {
                // empty catch block
            }
            ConnectionMgr.getIstance().getConnection().setAutoCommit(false);
            this.alunniMgr.updateContestoAlunno(alunno);
            if (alunno.getClass().equals(AlunnoEsaminato.class)) {
                this.alunniMgr.updateContestoEsameAlunno((AlunnoEsaminato)alunno);
            }
            strumentoSelezionato = fascicolo.getStrumento();
            if (!alunno.getStato().equals("Frequentante") || alunno.getClass().equals(AlunnoEsaminato.class) && ((AlunnoEsaminato)alunno).getAmmesso().equals("No")) {
                strumenti = this.getStrumentiByLivello(fascicolo.getStrumento().getLivello());
                for (Strumento nextStrumento : strumenti) {
                    if (strumentoSelezionato.getTipo().substring(0, 3).equals("QST")) {
                        this.setStrumentoNonCompilatoDallAlunno(alunno, nextStrumento, "NON compila il questionario o ASSENTE", ConnectionMgr.getIstance().getConnection());
                        continue;
                    }
                    this.setStrumentoNonCompilatoDallAlunno(alunno, nextStrumento, "NON svolge la prova standard o ASSENTE", ConnectionMgr.getIstance().getConnection());
                }
            } else if (svolgeProva.equals("NON compila il questionario o ASSENTE") || svolgeProva.equals("NON svolge la prova standard o ASSENTE")) {
                this.setStrumentoNonCompilatoDallAlunno(alunno, strumentoSelezionato, svolgeProva, ConnectionMgr.getIstance().getConnection());
            } else {
                this.strumentoCompilatoDallAlunno(alunno, fascicolo, itemsConRisposte, svolgeProva, tempoExtra, ConnectionMgr.getIstance().getConnection());
            }
            ConnectionMgr.getIstance().getConnection().commit();
            ConnectionMgr.getIstance().getConnection().setAutoCommit(true);
            ConnectionMgr.getIstance().resetConnection();
            fatto = true;
        }
        catch (ClassNotFoundException ex) {
            try {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
                ConnectionMgr.getIstance().getConnection().rollback();
                ConnectionMgr.getIstance().getConnection().setAutoCommit(true);
                throw new ProveMgtException(ex.getMessage());
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (ConnectionException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (SQLException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        catch (ConnectionException ex) {
            try {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
                ConnectionMgr.getIstance().getConnection().rollback();
                ConnectionMgr.getIstance().getConnection().setAutoCommit(true);
                throw new ProveMgtException(ex.getMessage());
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (ConnectionException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (SQLException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        catch (SQLException ex) {
            try {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
                ConnectionMgr.getIstance().getConnection().rollback();
                ConnectionMgr.getIstance().getConnection().setAutoCommit(true);
                throw new ProveMgtException(ex.getMessage());
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (ConnectionException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (SQLException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        catch (AlunniMgtException ex) {
            try {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
                ConnectionMgr.getIstance().getConnection().rollback();
                ConnectionMgr.getIstance().getConnection().setAutoCommit(true);
                throw new ProveMgtException(ex.getMessage());
            }
            catch (ClassNotFoundException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (ConnectionException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (SQLException ex1) {
                Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        return fatto;
    }

    @Override
    public List<BloccoDiCorrezione> getBlocchiDiItemConRisposte(AlunnoEsaminato alunnoEsaminato, FascicoloCompilato fascicocloCompilato) throws ProveMgtException {
        List<BloccoDiCorrezione> blocchi;
        try {
            blocchi = this.bloccoDao.getBlocchiDiItemConRisposte(alunnoEsaminato.getId(), fascicocloCompilato.getStrumento().getId(), fascicocloCompilato.getSequenziale());
        }
        catch (BloccoDiCorrezioneDaoException ex) {
            Logger.getLogger(ProveMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new ProveMgtException(ex.getMessage());
        }
        return blocchi;
    }
}

