/*
 * Decompiled with CFR 0.152.
 */
package invalsi.business.alunni.impl;

import invalsi.beans.alunni.Alunno;
import invalsi.beans.alunni.AlunnoEsaminato;
import invalsi.beans.alunni.AlunnoValutato;
import invalsi.beans.scuole.Classe;
import invalsi.beans.scuole.StoricoClasse;
import invalsi.business.alunni.IAlunniMgt;
import invalsi.business.scuole.impl.ScuoleMgr;
import invalsi.dao.interfaces.alunni.IAlunnoDao;
import invalsi.dao.local.alunni.AlunnoLocalDao;
import invalsi.dao.remote.alunni.AlunnoRemoteDao;
import invalsi.eccezioni.business.alunni.AlunniMgtException;
import invalsi.eccezioni.dao.alunni.AlunnoDaoException;
import invalsi.eccezioni.utils.db.ConnectionException;
import invalsi.utils.db.ConnectionMgr;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlunniMgr
implements IAlunniMgt {
    private static volatile IAlunniMgt myIstance = null;
    private final IAlunnoDao alunnoLocalDao;
    private final IAlunnoDao alunnoRemoteDao;
    private String origineAlunnni = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IAlunniMgt getIstance() throws AlunniMgtException {
        if (myIstance != null) return myIstance;
        Class<AlunniMgr> clazz = AlunniMgr.class;
        synchronized (AlunniMgr.class) {
            if (myIstance != null) return myIstance;
            myIstance = new AlunniMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myIstance;
        }
    }

    private AlunniMgr() throws AlunniMgtException {
        try {
            this.alunnoLocalDao = new AlunnoLocalDao();
            this.alunnoRemoteDao = new AlunnoRemoteDao();
            this.origineAlunnni = "Alunni letti da db";
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Alunno> getAlunniByClasse(Classe classe) throws AlunniMgtException {
        List<Alunno> alunni = null;
        this.origineAlunnni = "Alunni letti da db";
        try {
            alunni = this.alunnoLocalDao.getAlunniByClasse(classe, true);
        }
        catch (AlunnoDaoException ex) {
            alunni = null;
        }
        if (alunni == null || alunni.isEmpty()) {
            try {
                this.origineAlunnni = "Alunni letti da remoto";
                alunni = this.alunnoRemoteDao.getAlunniByClasse(classe, true);
            }
            catch (AlunnoDaoException exe) {
                alunni = null;
            }
            finally {
                if (alunni == null || alunni.isEmpty()) {
                    alunni = new LinkedList<Alunno>();
                    this.origineAlunnni = "Alunni appena creati";
                } else {
                    try {
                        this.alunnoLocalDao.salvaAlunniDellaClasse(classe, alunni);
                        alunni = this.alunnoLocalDao.getAlunniByClasse(classe, true);
                    }
                    catch (AlunnoDaoException ex) {
                        Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
                        throw new AlunniMgtException(ex.getMessage());
                    }
                }
            }
        }
        return alunni;
    }

    private List<Alunno> creaAlunniDelleClasse(Classe classe) throws AlunniMgtException {
        List<Alunno> alunni = null;
        try {
            ConnectionMgr.getIstance().resetConnection();
            this.alunnoLocalDao.creaAlunniDellaClasse(classe.getId(), classe.getLivello());
            if (classe.getLivello() == 8 && null != classe.getCorsoDiStudio() && null != classe.getCorsoDiStudio().getPlesso() && null != classe.getCorsoDiStudio().getPlesso().getMeccanografico() && classe.getCorsoDiStudio().getPlesso().getMeccanografico().subSequence(0, 2).equals("ES")) {
                this.alunnoLocalDao.setAlunniEsaminatiEsterni(classe.getId());
            }
            alunni = this.alunnoLocalDao.getAlunniByClasse(classe, true);
            ConnectionMgr.getIstance().resetConnection();
        }
        catch (AlunnoDaoException ade) {
            try {
                ConnectionMgr.getIstance().resetConnection();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            }
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ade);
            throw new AlunniMgtException(ade.getMessage());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
        return alunni;
    }

    @Override
    public Map<String, Map<Integer, String>> getContestoFieldValues() throws AlunniMgtException {
        try {
            HashMap<String, Map<Integer, String>> contestoCombos = null;
            Map<Integer, String> luogoNascita = null;
            Map<Integer, String> meseNascita = null;
            Map<Integer, String> giornoNascita = null;
            Map<Integer, String> arrivoItalia_2 = null;
            Map<Integer, String> arrivoItalia_5 = null;
            Map<Integer, String> arrivoItalia_6 = null;
            Map<Integer, String> arrivoItalia_8 = null;
            Map<Integer, String> arrivoItalia_10 = null;
            Map<Integer, String> voto = null;
            Map<Integer, String> istruzione = null;
            Map<Integer, String> occupazione = null;
            Map<Integer, String> statoAlunno = null;
            Map<Integer, String> oreDiLezione_2 = null;
            Map<Integer, String> oreDiLezione_5 = null;
            Map<Integer, String> oreDiLezione_6 = null;
            Map<Integer, String> oreDiLezione_8 = null;
            Map<Integer, String> oreDiLezione_10 = null;
            Map<Integer, String> orePerMateria = null;
            Map<Integer, String> disabilita = null;
            Map<Integer, String> tipoCandidato = null;
            Map<Integer, String> votoAmmissione = null;
            Map<Integer, String> votoEsame = null;
            Map<Integer, String> ammesso = null;
            Map<Integer, String> tempoAggiuntivo = null;
            luogoNascita = this.alunnoLocalDao.getOpzioniContestoPossibili("LUOGHO_NASCITA");
            meseNascita = this.alunnoLocalDao.getOpzioniContestoPossibili("MSSE_NASCITA");
            giornoNascita = this.alunnoLocalDao.getOpzioniContestoPossibili("GIORNO_NASCITA");
            arrivoItalia_2 = this.alunnoLocalDao.getOpzioniContestoPossibili("ARRIVO_ITALIA_2");
            arrivoItalia_5 = this.alunnoLocalDao.getOpzioniContestoPossibili("ARRIVO_ITALIA_5");
            arrivoItalia_6 = this.alunnoLocalDao.getOpzioniContestoPossibili("ARRIVO_ITALIA_6");
            arrivoItalia_8 = this.alunnoLocalDao.getOpzioniContestoPossibili("ARRIVO_ITALIA_8");
            arrivoItalia_10 = this.alunnoLocalDao.getOpzioniContestoPossibili("ARRIVO_ITALIA_10");
            oreDiLezione_2 = this.alunnoLocalDao.getOpzioniContestoPossibili("ORE_LEZIONE_2");
            oreDiLezione_5 = this.alunnoLocalDao.getOpzioniContestoPossibili("ORE_LEZIONE_5");
            oreDiLezione_6 = this.alunnoLocalDao.getOpzioniContestoPossibili("ORE_LEZIONE_6");
            oreDiLezione_8 = this.alunnoLocalDao.getOpzioniContestoPossibili("ORE_LEZIONE_8");
            oreDiLezione_10 = this.alunnoLocalDao.getOpzioniContestoPossibili("ORE_LEZIONE_10");
            orePerMateria = this.alunnoLocalDao.getOpzioniContestoPossibili("ORE_MATERIA");
            voto = this.alunnoLocalDao.getOpzioniContestoPossibili("VOTI");
            istruzione = this.alunnoLocalDao.getOpzioniContestoPossibili("ISTRUZIONE");
            occupazione = this.alunnoLocalDao.getOpzioniContestoPossibili("OCCUPAZIONE");
            statoAlunno = this.alunnoLocalDao.getOpzioniContestoPossibili("STATI_ALUNNO");
            disabilita = this.alunnoLocalDao.getOpzioniContestoPossibili("DISABILITA");
            tipoCandidato = this.alunnoLocalDao.getOpzioniContestoPossibili("TIPI_CANDIDATO_ESAME");
            votoAmmissione = this.alunnoLocalDao.getOpzioniContestoPossibili("VOTI_AMMISSIONE");
            votoEsame = this.alunnoLocalDao.getOpzioniContestoPossibili("VOTI_ESAME");
            ammesso = this.alunnoLocalDao.getOpzioniContestoPossibili("AMMESSO");
            tempoAggiuntivo = this.alunnoLocalDao.getOpzioniContestoPossibili("TEMPI_AGGIUNTIVI");
            contestoCombos = new HashMap<String, Map<Integer, String>>();
            contestoCombos.put("LUOGHO_NASCITA", luogoNascita);
            contestoCombos.put("MSSE_NASCITA", meseNascita);
            contestoCombos.put("GIORNO_NASCITA", giornoNascita);
            contestoCombos.put("ARRIVO_ITALIA_2", arrivoItalia_2);
            contestoCombos.put("ARRIVO_ITALIA_5", arrivoItalia_5);
            contestoCombos.put("ARRIVO_ITALIA_6", arrivoItalia_6);
            contestoCombos.put("ARRIVO_ITALIA_8", arrivoItalia_8);
            contestoCombos.put("ARRIVO_ITALIA_10", arrivoItalia_10);
            contestoCombos.put("ORE_LEZIONE_2", oreDiLezione_2);
            contestoCombos.put("ORE_LEZIONE_5", oreDiLezione_5);
            contestoCombos.put("ORE_LEZIONE_6", oreDiLezione_6);
            contestoCombos.put("ORE_LEZIONE_8", oreDiLezione_8);
            contestoCombos.put("ORE_LEZIONE_10", oreDiLezione_10);
            contestoCombos.put("ORE_MATERIA", orePerMateria);
            contestoCombos.put("VOTI", voto);
            contestoCombos.put("ISTRUZIONE", istruzione);
            contestoCombos.put("OCCUPAZIONE", occupazione);
            contestoCombos.put("STATI_ALUNNO", statoAlunno);
            contestoCombos.put("DISABILITA", disabilita);
            contestoCombos.put("TIPI_CANDIDATO_ESAME", tipoCandidato);
            contestoCombos.put("VOTI_AMMISSIONE", votoAmmissione);
            contestoCombos.put("VOTI_ESAME", votoEsame);
            contestoCombos.put("AMMESSO", ammesso);
            contestoCombos.put("TEMPI_AGGIUNTIVI", tempoAggiuntivo);
            return contestoCombos;
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException("Non \u00e8 stato possibile caricare le opzioni di contesto");
        }
    }

    @Override
    public void updateContestoAlunno(Alunno alunno) throws AlunniMgtException {
        int idAlunno = alunno.getId();
        String sidi = alunno.getSidi();
        String scrittoItaliano = alunno.getVotoScrittoItaliano();
        String oraleItaliano = alunno.getVotoOraleItaliano();
        String scrittoMatematica = alunno.getVotoScrittoMatematica();
        String oraleMatematica = alunno.getVotoOraleMatematica();
        String disabilita = alunno.getDisabilita();
        String statoAlunno = alunno.getStato();
        try {
            if (sidi != null) {
                this.alunnoLocalDao.updateSidiAlunno(idAlunno, sidi);
            }
            this.alunnoLocalDao.updateContestoAlunno(idAlunno, scrittoItaliano, oraleItaliano, scrittoMatematica, oraleMatematica, disabilita, statoAlunno);
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException("Non \u00e8 stato possibile aggiornare il contesto dell'alunno");
        }
    }

    @Override
    public List<AlunnoValutato> getAlunniValutatiByClasse(Classe classe) throws AlunniMgtException {
        try {
            return this.alunnoLocalDao.getAlunniValutatiByClasse(classe);
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException("Non \u00e8 stato possibile recuperare gli alunni valutati");
        }
    }

    @Override
    public String getSvolgeProva(AlunnoValutato alunno, String tipoProva, String materia) throws AlunniMgtException {
        String svolgeProvaResult;
        try {
            svolgeProvaResult = this.alunnoLocalDao.getSvolgeProva(alunno.getId(), tipoProva, materia);
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException("Non \u00e8 stato possibile recuperare gli alunni valutati");
        }
        return svolgeProvaResult;
    }

    @Override
    public AlunnoValutato aggiungiAlunnoAllaClasse(StoricoClasse storicoClasse) throws AlunniMgtException {
        AlunnoValutato alunno = null;
        try {
            ConnectionMgr.getIstance().resetConnection();
            alunno = this.alunnoLocalDao.aggiungiAlunnoAllaClasse(storicoClasse);
            storicoClasse.getAlunni().add(alunno);
            ConnectionMgr.getIstance().resetConnection();
        }
        catch (AlunnoDaoException ade) {
            try {
                ConnectionMgr.getIstance().resetConnection();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            }
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ade);
            throw new AlunniMgtException(ade.getMessage());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
        return alunno;
    }

    @Override
    public Map<String, String> getInfoOnProveAndQuestionari(Alunno alunno, int livello) throws AlunniMgtException {
        Map<String, String> infoAlunno = null;
        try {
            infoAlunno = this.alunnoLocalDao.getInfoOnProveAndQuestionari(alunno.getId(), livello);
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
        return infoAlunno;
    }

    @Override
    public void updateContestoEsameAlunno(AlunnoEsaminato alunnoEsaminato) throws AlunniMgtException {
        int idAlunno = alunnoEsaminato.getId();
        String cognome = alunnoEsaminato.getCognome();
        String nome = alunnoEsaminato.getNome();
        String tipoCandidato = alunnoEsaminato.getTipoCandidato();
        String ammesso = alunnoEsaminato.getAmmesso();
        String votoAmmissione = alunnoEsaminato.getVotoAmmissione();
        String votoEsameItaliano = alunnoEsaminato.getVotoProvaEsameItaliano();
        String votoEsameMatematica = alunnoEsaminato.getVotoProvaEsameMatematica();
        String votoEsameLingua = alunnoEsaminato.getVotoProvaEsameLingua();
        String votoEsameInvalsi = alunnoEsaminato.getVotoInvalsi();
        if (null == votoEsameInvalsi || votoEsameInvalsi == "" || votoEsameInvalsi.equals("Non applicabile") || votoEsameInvalsi.equals("Non disponibile")) {
            votoEsameInvalsi = "ASSENTE";
        }
        if (null == votoAmmissione || votoAmmissione == "" || votoAmmissione.equals("Non applicabile") || votoAmmissione.equals("Non disponibile")) {
            votoAmmissione = "";
        }
        try {
            this.alunnoLocalDao.updateContestoEsameAlunno(idAlunno, cognome, nome, tipoCandidato, ammesso, votoAmmissione, votoEsameItaliano, votoEsameMatematica, votoEsameLingua, votoEsameInvalsi);
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(ScuoleMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
    }

    @Override
    public AlunnoEsaminato getAlunnoEsaminato(int idAlunno) throws AlunniMgtException {
        try {
            return this.alunnoLocalDao.getAlunnoEsaminato(idAlunno);
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException("Non \u00e8 stato possibile recuperare l'alunno");
        }
    }

    public String getOrigineALunni() {
        return this.origineAlunnni;
    }

    @Override
    public void cleanAlunniDelleClasse(StoricoClasse storicoClasse) throws AlunniMgtException {
        try {
            ConnectionMgr.getIstance().resetConnection();
            ConnectionMgr.getIstance().getConnection().setAutoCommit(false);
            this.alunnoLocalDao.cleanAlunniDelleClasse(storicoClasse.getId());
            ConnectionMgr.getIstance().getConnection().setAutoCommit(true);
            ConnectionMgr.getIstance().resetConnection();
        }
        catch (AlunnoDaoException ade) {
            try {
                ConnectionMgr.getIstance().resetConnection();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            }
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ade);
            throw new AlunniMgtException(ade.getMessage());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
        catch (ConnectionException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
    }

    @Override
    public boolean ciSonoRisposteDellAlunno(Alunno alunno) throws AlunniMgtException {
        try {
            return this.alunnoLocalDao.ciSonoRisposteDellAlunno(alunno.getId());
        }
        catch (AlunnoDaoException ex) {
            Logger.getLogger(AlunniMgr.class.getName()).log(Level.SEVERE, null, ex);
            throw new AlunniMgtException(ex.getMessage());
        }
    }
}

